/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightPsiClassBuilder;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderAnnotationContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderHelperLightPsiClass;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class DefaultBuilderStrategySupport
extends BuilderAnnotationContributor {
    public static final String DEFAULT_STRATEGY_NAME = "DefaultStrategy";

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        if (context == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(0);
        }
        new DefaultBuilderStrategyHandler(context).doProcess();
    }

    @NotNull
    public static String getBuilderClassName(@NotNull PsiAnnotation annotation, @NotNull GrTypeDefinition clazz) {
        String builderClassName;
        if (annotation == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(1);
        }
        if (clazz == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(2);
        }
        String string = (builderClassName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"builderClassName")) == null ? String.format("%s%s", clazz.getName(), "Builder") : builderClassName;
        if (string == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static LightMethodBuilder createBuildMethod(@NotNull PsiAnnotation annotation, @NotNull PsiType builtType) {
        if (annotation == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(4);
        }
        if (builtType == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(5);
        }
        LightMethodBuilder buildMethod = new LightMethodBuilder(annotation.getManager(), DefaultBuilderStrategySupport.getBuildMethodName(annotation));
        buildMethod.setOriginInfo("via @Builder");
        buildMethod.setMethodReturnType(builtType);
        LightMethodBuilder lightMethodBuilder = buildMethod;
        if (lightMethodBuilder == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(6);
        }
        return lightMethodBuilder;
    }

    @NotNull
    public static LightMethodBuilder createFieldSetter(@NotNull PsiClass builderClass, @NotNull PsiVariable field, @NotNull PsiAnnotation annotation) {
        if (builderClass == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(7);
        }
        if (field == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(8);
        }
        if (annotation == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(9);
        }
        String name = Objects.requireNonNull(field.getName());
        LightMethodBuilder lightMethodBuilder = DefaultBuilderStrategySupport.createFieldSetter(builderClass, name, field.getType(), annotation, (PsiElement)field);
        if (lightMethodBuilder == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(10);
        }
        return lightMethodBuilder;
    }

    @NotNull
    public static LightMethodBuilder createFieldSetter(@NotNull PsiClass builderClass, @NotNull String name, @NotNull PsiType type, @NotNull PsiAnnotation annotation, @NotNull PsiElement navigationElement) {
        if (builderClass == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(11);
        }
        if (name == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(12);
        }
        if (type == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(13);
        }
        if (annotation == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(14);
        }
        if (navigationElement == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(15);
        }
        LightMethodBuilder fieldSetter = new LightMethodBuilder(builderClass.getManager(), DefaultBuilderStrategySupport.getFieldMethodName(annotation, name));
        fieldSetter.addModifier("public");
        fieldSetter.addParameter(name, type);
        fieldSetter.setContainingClass(builderClass);
        fieldSetter.setMethodReturnType((PsiType)JavaPsiFacade.getElementFactory((Project)builderClass.getProject()).createType(builderClass));
        fieldSetter.setNavigationElement(navigationElement);
        fieldSetter.setOriginInfo("via @Builder");
        LightMethodBuilder lightMethodBuilder = fieldSetter;
        if (lightMethodBuilder == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(16);
        }
        return lightMethodBuilder;
    }

    @NotNull
    public static String getFieldMethodName(@NotNull PsiAnnotation annotation, @NotNull String fieldName) {
        String prefix;
        if (annotation == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(17);
        }
        if (fieldName == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(18);
        }
        String string = StringUtil.isEmpty((String)(prefix = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"prefix"))) ? fieldName : String.format("%s%s", prefix, StringUtil.capitalize((String)fieldName));
        if (string == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static String getBuildMethodName(@NotNull PsiAnnotation annotation) {
        String buildMethodName;
        if (annotation == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(20);
        }
        String string = StringUtil.isEmpty((String)(buildMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"buildMethodName"))) ? "build" : buildMethodName;
        if (string == null) {
            DefaultBuilderStrategySupport.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 16: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 16: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtType";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderClassName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildMethod";
                break;
            }
            case 10: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldSetter";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldMethodName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyTransformation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderClassName";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 16: 
            case 19: 
            case 21: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBuildMethod";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFieldSetter";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFieldMethodName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getBuildMethodName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 16: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DefaultBuilderStrategyHandler {
        @NotNull
        private final TransformationContext myContext;
        @NotNull
        private final GrTypeDefinition myContainingClass;

        private DefaultBuilderStrategyHandler(@NotNull TransformationContext context) {
            if (context == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(0);
            }
            this.myContext = context;
            this.myContainingClass = context.getCodeClass();
        }

        public void doProcess() {
            this.processTypeDefinition();
            this.processMethods();
        }

        private void processTypeDefinition() {
            PsiAnnotation builderAnno = PsiImplUtil.getAnnotation((PsiModifierListOwner)this.myContainingClass, "groovy.transform.builder.Builder");
            if (!BuilderAnnotationContributor.isApplicable(builderAnno, DefaultBuilderStrategySupport.DEFAULT_STRATEGY_NAME)) {
                return;
            }
            boolean includeSuper = BuilderAnnotationContributor.isIncludeSuperProperties(builderAnno);
            LightPsiClassBuilder builderClass = this.createBuilderClass(builderAnno, (PsiVariable[])BuilderAnnotationContributor.getFields(this.myContext, includeSuper));
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, builderAnno));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        @NotNull
        private LightPsiClassBuilder createBuilderClass(@NotNull PsiAnnotation annotation, @NotNull PsiVariable[] setters) {
            if (annotation == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(1);
            }
            if (setters == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(2);
            }
            LightPsiClassBuilder lightPsiClassBuilder = this.createBuilderClass(annotation, setters, null);
            if (lightPsiClassBuilder == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(3);
            }
            return lightPsiClassBuilder;
        }

        @NotNull
        private LightPsiClassBuilder createBuilderClass(@NotNull PsiAnnotation annotation, @NotNull PsiVariable[] setters, @Nullable PsiType builtType) {
            if (annotation == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(4);
            }
            if (setters == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(5);
            }
            BuilderHelperLightPsiClass builderClass = new BuilderHelperLightPsiClass(this.myContainingClass, DefaultBuilderStrategySupport.getBuilderClassName(annotation, this.myContainingClass));
            for (PsiVariable field : setters) {
                LightMethodBuilder setter = DefaultBuilderStrategySupport.createFieldSetter((PsiClass)builderClass, field, annotation);
                builderClass.addMethod((PsiMethod)setter);
            }
            LightMethodBuilder buildMethod = DefaultBuilderStrategySupport.createBuildMethod(annotation, (PsiType)(builtType == null ? TypesUtil.createType(this.myContainingClass) : builtType));
            LightPsiClassBuilder lightPsiClassBuilder = builderClass.addMethod((PsiMethod)buildMethod);
            if (lightPsiClassBuilder == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(6);
            }
            return lightPsiClassBuilder;
        }

        @NotNull
        private LightMethodBuilder createBuilderMethod(@NotNull PsiClass builderClass, @NotNull PsiAnnotation annotation) {
            if (builderClass == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(7);
            }
            if (annotation == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(8);
            }
            LightMethodBuilder builderMethod = new LightMethodBuilder(this.myContext.getManager(), DefaultBuilderStrategyHandler.getBuilderMethodName(annotation));
            builderMethod.addModifier("static");
            builderMethod.setOriginInfo("via @Builder");
            builderMethod.setNavigationElement((PsiElement)annotation);
            builderMethod.setMethodReturnType((PsiType)TypesUtil.createType(builderClass));
            LightMethodBuilder lightMethodBuilder = builderMethod;
            if (lightMethodBuilder == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(9);
            }
            return lightMethodBuilder;
        }

        private void processMethods() {
            for (GrMethod method : this.myContext.getCodeClass().getCodeMethods()) {
                this.processMethod(method);
            }
        }

        private void processMethod(@NotNull GrMethod method) {
            PsiAnnotation annotation;
            if (method == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(10);
            }
            if (!BuilderAnnotationContributor.isApplicable(annotation = PsiImplUtil.getAnnotation(method, "groovy.transform.builder.Builder"), DefaultBuilderStrategySupport.DEFAULT_STRATEGY_NAME)) {
                return;
            }
            if (method.isConstructor()) {
                this.processConstructor(method, annotation);
            } else if (method.hasModifierProperty("static")) {
                this.processFactoryMethod(method, annotation);
            }
        }

        private void processConstructor(@NotNull GrMethod method, PsiAnnotation annotation) {
            if (method == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(11);
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(annotation, method.getParameters());
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, annotation));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        private void processFactoryMethod(@NotNull GrMethod method, PsiAnnotation annotation) {
            if (method == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(12);
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(annotation, method.getParameters(), method.getReturnType());
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, annotation));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        @NotNull
        private static String getBuilderMethodName(@NotNull PsiAnnotation annotation) {
            String builderMethodName;
            if (annotation == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(13);
            }
            String string = StringUtil.isEmpty((String)(builderMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"builderMethodName"))) ? "builder" : builderMethodName;
            if (string == null) {
                DefaultBuilderStrategyHandler.$$$reportNull$$$0(14);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 4: 
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "setters";
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builderClass";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBuilderClass";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBuilderMethod";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuilderMethodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createBuilderClass";
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 14: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createBuilderMethod";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "processMethod";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "processConstructor";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "processFactoryMethod";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getBuilderMethodName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

