/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.AnnotationArgConverter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightClassReferenceElement;

public class GrLightAnnotation
extends LightElement
implements GrAnnotation {
    private final GrLightAnnotationArgumentList myAnnotationArgList;
    private final String myQualifiedName;
    private final PsiAnnotationOwner myOwner;
    private final PsiElement myContext;
    private final GrLightClassReferenceElement myRef;

    public GrLightAnnotation(@NotNull PsiManager manager, @NotNull Language language, @NotNull String qualifiedName, @NotNull PsiModifierList owner) {
        if (manager == null) {
            GrLightAnnotation.$$$reportNull$$$0(0);
        }
        if (language == null) {
            GrLightAnnotation.$$$reportNull$$$0(1);
        }
        if (qualifiedName == null) {
            GrLightAnnotation.$$$reportNull$$$0(2);
        }
        if (owner == null) {
            GrLightAnnotation.$$$reportNull$$$0(3);
        }
        super(manager, language);
        this.myQualifiedName = qualifiedName;
        this.myOwner = owner;
        this.myContext = owner;
        this.myAnnotationArgList = new GrLightAnnotationArgumentList(manager, language);
        this.myRef = new GrLightClassReferenceElement(qualifiedName, qualifiedName, this);
    }

    public GrLightAnnotation(@NotNull PsiAnnotationOwner owner, @NotNull PsiElement context, @NotNull String qualifiedName, @NotNull Map<String, String> params) {
        if (owner == null) {
            GrLightAnnotation.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GrLightAnnotation.$$$reportNull$$$0(5);
        }
        if (qualifiedName == null) {
            GrLightAnnotation.$$$reportNull$$$0(6);
        }
        if (params == null) {
            GrLightAnnotation.$$$reportNull$$$0(7);
        }
        super(context.getManager(), context.getLanguage());
        this.myQualifiedName = qualifiedName;
        this.myOwner = owner;
        this.myContext = context;
        this.myAnnotationArgList = new GrLightAnnotationArgumentList(context.getManager(), context.getLanguage());
        this.myRef = new GrLightClassReferenceElement(qualifiedName, qualifiedName, this);
        params.forEach((key, value) -> this.addAttribute((String)key, (String)value));
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public PsiFile getContainingFile() {
        return this.myContext.getContainingFile();
    }

    @Override
    @NotNull
    public GrCodeReferenceElement getClassReference() {
        GrLightClassReferenceElement grLightClassReferenceElement = this.myRef;
        if (grLightClassReferenceElement == null) {
            GrLightAnnotation.$$$reportNull$$$0(8);
        }
        return grLightClassReferenceElement;
    }

    @Override
    @NotNull
    public String getShortName() {
        String string = StringUtil.getShortName((String)this.myQualifiedName);
        if (string == null) {
            GrLightAnnotation.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public GrAnnotationArgumentList getParameterList() {
        GrLightAnnotationArgumentList grLightAnnotationArgumentList = this.myAnnotationArgList;
        if (grLightAnnotationArgumentList == null) {
            GrLightAnnotation.$$$reportNull$$$0(10);
        }
        return grLightAnnotationArgumentList;
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrLightAnnotation.$$$reportNull$$$0(11);
        }
        visitor2.visitAnnotation(this);
    }

    @Override
    public void acceptChildren(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrLightAnnotation.$$$reportNull$$$0(12);
        }
    }

    public String toString() {
        return "light groovy annotation";
    }

    public String getText() {
        return "@" + this.myQualifiedName + this.myAnnotationArgList.getText();
    }

    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        GroovyResolveResult resolveResult = this.myRef.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        if (resolved instanceof PsiClass) {
            return new LightClassReference(this.getManager(), this.getClassReference().getText(), (PsiClass)resolved, resolveResult.getSubstitutor());
        }
        return null;
    }

    public PsiAnnotationMemberValue findAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, @Nullable T value) {
        throw new UnsupportedOperationException("light annotation does not support changes");
    }

    public PsiAnnotationOwner getOwner() {
        return this.myOwner;
    }

    public PsiMetaData getMetaData() {
        return null;
    }

    public void addAttribute(PsiNameValuePair pair) {
        if (pair instanceof GrAnnotationNameValuePair) {
            this.myAnnotationArgList.addAttribute((GrAnnotationNameValuePair)pair);
        } else {
            GrAnnotationMemberValue newValue = new AnnotationArgConverter().convert(pair.getValue());
            if (newValue == null) {
                return;
            }
            String name = pair.getName();
            this.addAttribute(name, newValue.getText());
        }
    }

    public void addAttribute(@Nullable String name, @NotNull String value) {
        if (value == null) {
            GrLightAnnotation.$$$reportNull$$$0(13);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        String annotationText = name != null ? "@A(" + name + "=" + value + ")" : "@A(" + value + ")";
        GrAnnotation annotation = factory.createAnnotationFromText(annotationText, this);
        this.myAnnotationArgList.addAttribute(annotation.getParameterList().getAttributes()[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassReference";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class GrLightAnnotationArgumentList
    extends LightElement
    implements GrAnnotationArgumentList {
        private List<GrAnnotationNameValuePair> myAttributes;
        private GrAnnotationNameValuePair[] myCachedAttributes;

        public PsiElement getContext() {
            return GrLightAnnotation.this;
        }

        private GrLightAnnotationArgumentList(@NotNull PsiManager manager, Language language) {
            if (manager == null) {
                GrLightAnnotationArgumentList.$$$reportNull$$$0(0);
            }
            if (language == null) {
                GrLightAnnotationArgumentList.$$$reportNull$$$0(1);
            }
            super(manager, language);
            this.myAttributes = null;
            this.myCachedAttributes = GrAnnotationNameValuePair.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public GrAnnotationNameValuePair[] getAttributes() {
            if (this.myCachedAttributes == null) {
                assert (this.myAttributes != null);
                this.myCachedAttributes = this.myAttributes.toArray(GrAnnotationNameValuePair.EMPTY_ARRAY);
            }
            if (this.myCachedAttributes == null) {
                GrLightAnnotationArgumentList.$$$reportNull$$$0(2);
            }
            return this.myCachedAttributes;
        }

        public void addAttribute(@NotNull GrAnnotationNameValuePair attribute) {
            if (attribute == null) {
                GrLightAnnotationArgumentList.$$$reportNull$$$0(3);
            }
            if (this.myAttributes == null) {
                this.myAttributes = ContainerUtilRt.newArrayList();
            }
            this.myAttributes.add(attribute);
            this.myCachedAttributes = null;
        }

        @Override
        public void accept(@NotNull GroovyElementVisitor visitor2) {
            if (visitor2 == null) {
                GrLightAnnotationArgumentList.$$$reportNull$$$0(4);
            }
            visitor2.visitAnnotationArgumentList(this);
        }

        @Override
        public void acceptChildren(@NotNull GroovyElementVisitor visitor2) {
            if (visitor2 == null) {
                GrLightAnnotationArgumentList.$$$reportNull$$$0(5);
            }
            if (this.myAttributes != null) {
                for (GrAnnotationNameValuePair attribute : this.myAttributes) {
                    attribute.accept(visitor2);
                }
            }
        }

        public String toString() {
            return "light annotation argument list";
        }

        public String getText() {
            if (this.myAttributes == null || this.myAttributes.isEmpty()) {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append('(');
            for (GrAnnotationNameValuePair attribute : this.myAttributes) {
                buffer.append(attribute.getText());
                buffer.append(',');
            }
            if (!this.myAttributes.isEmpty()) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            buffer.append(')');
            return buffer.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation$GrLightAnnotationArgumentList";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation$GrLightAnnotationArgumentList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addAttribute";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

