/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrCallExpressionTypeCalculator;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class DefaultCallExpressionTypeCalculator
extends GrCallExpressionTypeCalculator {
    private static final Logger LOG = Logger.getInstance(DefaultCallExpressionTypeCalculator.class);
    private static final Set<String> CLOSURE_METHODS = new HashSet();

    @Override
    public PsiType calculateReturnType(@NotNull GrMethodCall callExpression, GroovyResolveResult[] resolveResults) {
        GrExpression invoked;
        if (callExpression == null) {
            DefaultCallExpressionTypeCalculator.$$$reportNull$$$0(0);
        }
        if ((invoked = callExpression.getInvokedExpression()) instanceof GrReferenceExpression) {
            GrReferenceExpression refExpr = (GrReferenceExpression)invoked;
            PsiManager manager = callExpression.getManager();
            PsiType result2 = null;
            for (GroovyResolveResult resolveResult : resolveResults) {
                PsiType normalized;
                PsiType nonVoid;
                PsiType returnType = DefaultCallExpressionTypeCalculator.calculateReturnTypeInner(callExpression, refExpr, resolveResult);
                if (returnType == null) {
                    return null;
                }
                Object object = nonVoid = PsiType.VOID.equals((Object)returnType) && !PsiUtil.isCompileStatic(callExpression) ? PsiType.NULL : returnType;
                if (nonVoid instanceof GrLiteralClassType) {
                    normalized = nonVoid;
                } else {
                    boolean needsSubstitutor = DefaultCallExpressionTypeCalculator.hasGenerics(nonVoid);
                    PsiSubstitutor substitutor = needsSubstitutor ? resolveResult.getSubstitutor() : PsiSubstitutor.EMPTY;
                    normalized = TypesUtil.substituteAndNormalizeType(nonVoid, substitutor, resolveResult.getSpreadState(), callExpression);
                    LOG.assertTrue(normalized != null, (Object)("return type: " + returnType + "; substitutor: " + substitutor));
                }
                if (result2 == null || normalized.isAssignableFrom(result2)) {
                    result2 = normalized;
                    continue;
                }
                if (result2.isAssignableFrom(normalized)) continue;
                result2 = TypesUtil.getLeastUpperBound(result2, normalized, manager);
            }
            return result2;
        }
        return DefaultCallExpressionTypeCalculator.extractReturnTypeFromType(invoked.getType(), false, callExpression);
    }

    @Nullable
    private static PsiType calculateReturnTypeInner(GrMethodCall callExpression, GrReferenceExpression refExpr, GroovyResolveResult resolveResult) {
        PsiElement resolved = resolveResult.getElement();
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (resolveResult.isInvokedOnProperty()) {
                PsiType propertyType = PsiUtil.getSmartReturnType(method);
                return DefaultCallExpressionTypeCalculator.extractReturnTypeFromType(propertyType, true, callExpression);
            }
            PsiType closureReturnType2 = DefaultCallExpressionTypeCalculator.getClosureMethodsReturnType(callExpression, refExpr, method);
            if (closureReturnType2 != null) {
                return closureReturnType2;
            }
            PsiType smartReturnType = PsiUtil.getSmartReturnType(method);
            return smartReturnType;
        }
        if (resolved instanceof GrVariable) {
            PsiType refType = refExpr.getType();
            PsiType type = (refType = TypesUtil.boxPrimitiveType(refType, callExpression.getManager(), callExpression.getResolveScope())) == null ? ((GrVariable)resolved).getTypeGroovy() : refType;
            return DefaultCallExpressionTypeCalculator.extractReturnTypeFromType(type, false, callExpression);
        }
        return null;
    }

    @Nullable
    private static PsiType extractReturnTypeFromType(PsiType type, boolean returnTypeIfFail, GrMethodCall callExpression) {
        PsiType returnType;
        Object object = returnType = returnTypeIfFail ? type : null;
        if (type instanceof GrClosureType) {
            returnType = GrClosureSignatureUtil.getReturnType(((GrClosureType)type).getSignature(), callExpression);
        } else if (TypesUtil.isPsiClassTypeToClosure(type)) {
            assert (type instanceof PsiClassType);
            PsiType[] parameters = ((PsiClassType)type).getParameters();
            if (parameters.length == 1) {
                returnType = parameters[0];
            }
        } else if (type instanceof PsiClassType) {
            GrExpression invoked = callExpression.getInvokedExpression();
            GroovyResolveResult[] calls = ResolveUtil.getMethodCandidates(type, "call", (PsiElement)(invoked != null ? invoked : callExpression), PsiUtil.getArgumentTypes(invoked, false));
            returnType = null;
            PsiManager manager = callExpression.getManager();
            for (GroovyResolveResult call : calls) {
                PsiType substituted = ResolveUtil.extractReturnTypeFromCandidate(call, callExpression, PsiUtil.getArgumentTypes(invoked, true));
                returnType = TypesUtil.getLeastUpperBoundNullable(returnType, substituted, manager);
            }
        }
        return returnType;
    }

    @Nullable
    private static PsiType getClosureMethodsReturnType(GrMethodCall callExpression, GrReferenceExpression refExpr, PsiMethod resolved) {
        PsiClass clazz = resolved.getContainingClass();
        if (clazz == null || !"groovy.lang.Closure".equals(clazz.getQualifiedName())) {
            return null;
        }
        if (!CLOSURE_METHODS.contains(resolved.getName())) {
            return null;
        }
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiType qType = qualifier.getType();
        if (!(qType instanceof GrClosureType)) {
            return null;
        }
        if ("call".equals(resolved.getName())) {
            return GrClosureSignatureUtil.getReturnType(((GrClosureType)qType).getSignature(), callExpression);
        }
        if ("curry".equals(resolved.getName()) || "trampoline".equals(resolved.getName())) {
            return ((GrClosureType)qType).curry(PsiUtil.getArgumentTypes(refExpr, false), 0, callExpression);
        }
        if ("memoize".equals(resolved.getName())) {
            return qType;
        }
        if ("rcurry".equals(resolved.getName())) {
            return ((GrClosureType)qType).curry(PsiUtil.getArgumentTypes(refExpr, false), -1, callExpression);
        }
        if ("ncurry".equals(resolved.getName())) {
            Object[] argTypes;
            Object value;
            GrExpression first;
            GrArgumentList argList = callExpression.getArgumentList();
            GrExpression[] arguments = argList.getExpressionArguments();
            if (arguments.length > 0 && (first = arguments[0]) instanceof GrLiteral && (value = ((GrLiteral)first).getValue()) instanceof Integer && (argTypes = PsiUtil.getArgumentTypes(refExpr, false)) != null) {
                return ((GrClosureType)qType).curry((PsiType[])ArrayUtil.remove((Object[])argTypes, (int)0), (Integer)value, callExpression);
            }
            return qType;
        }
        return null;
    }

    private static boolean hasGenerics(@NotNull PsiType type) {
        if (type == null) {
            DefaultCallExpressionTypeCalculator.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"groovy.return.type.optimization")) {
            return true;
        }
        return type.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                if (classType.resolve() instanceof PsiTypeParameter) {
                    return true;
                }
                if (!classType.hasParameters()) {
                    return null;
                }
                for (PsiType parameter : classType.getParameters()) {
                    if (parameter.accept((PsiTypeVisitor)this) != Boolean.TRUE) continue;
                    return true;
                }
                return null;
            }

            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }

            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                return bound == null ? null : (Boolean)bound.accept((PsiTypeVisitor)this);
            }
        }) == Boolean.TRUE;
    }

    static {
        CLOSURE_METHODS.add("call");
        CLOSURE_METHODS.add("curry");
        CLOSURE_METHODS.add("ncurry");
        CLOSURE_METHODS.add("rcurry");
        CLOSURE_METHODS.add("memoize");
        CLOSURE_METHODS.add("trampoline");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/DefaultCallExpressionTypeCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateReturnType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasGenerics";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

