/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyDummyElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovyPsiElementFactoryImpl
extends GroovyPsiElementFactory {
    private static final Logger LOG = Logger.getInstance(GroovyPsiElementFactoryImpl.class);
    private final Project myProject;
    private final PsiManager myManager;

    public GroovyPsiElementFactoryImpl(Project project, PsiManager manager) {
        this.myProject = project;
        this.myManager = manager;
    }

    @Override
    @NotNull
    public PsiElement createReferenceNameFromText(@NotNull String refName) {
        GroovyFile file;
        GrTopStatement statement;
        if (refName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(0);
        }
        if (!((statement = (file = this.createGroovyFileChecked("a." + refName)).getTopStatements()[0]) instanceof GrReferenceExpression)) {
            throw new IncorrectOperationException("Incorrect reference name: " + refName);
        }
        PsiElement element = ((GrReferenceExpression)statement).getReferenceNameElement();
        if (element == null) {
            throw new IncorrectOperationException("Incorrect reference name: " + refName);
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement createDocMemberReferenceNameFromText(@NotNull String idText) {
        GrDocMemberReference reference;
        if (idText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((reference = this.createDocMemberReferenceFromText("Foo", idText)) != null, (Object)idText);
        GrDocTagValueToken grDocTagValueToken = reference.getReferenceNameElement();
        if (grDocTagValueToken == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(3);
        }
        return grDocTagValueToken;
    }

    @Override
    @NotNull
    public GrDocMemberReference createDocMemberReferenceFromText(@NotNull String className, @NotNull String text) {
        if (className == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(4);
        }
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(5);
        }
        GroovyFile file = this.createGroovyFileChecked("/** @see " + className + "#" + text + " */");
        PsiElement element = file.getFirstChild();
        assert (element instanceof GrDocComment);
        GrDocTag tag = (GrDocTag)PsiTreeUtil.getChildOfType((PsiElement)element, GrDocTag.class);
        assert (tag != null) : "Doc tag points to null";
        GrDocMemberReference grDocMemberReference = (GrDocMemberReference)PsiTreeUtil.getChildOfType((PsiElement)tag, GrDocMemberReference.class);
        if (grDocMemberReference == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(6);
        }
        return grDocMemberReference;
    }

    @Override
    @NotNull
    public GrDocReferenceElement createDocReferenceElementFromFQN(@NotNull String qName) {
        if (qName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(7);
        }
        GroovyFile file = this.createGroovyFileChecked("/** @see " + qName + " */");
        PsiElement element = file.getFirstChild();
        assert (element instanceof GrDocComment);
        GrDocTag tag = (GrDocTag)PsiTreeUtil.getChildOfType((PsiElement)element, GrDocTag.class);
        assert (tag != null) : "Doc tag points to null";
        GrDocReferenceElement grDocReferenceElement = (GrDocReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)tag, GrDocReferenceElement.class);
        if (grDocReferenceElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(8);
        }
        return grDocReferenceElement;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement createReferenceElementFromText(@NotNull String refName, PsiElement context) {
        if (refName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(9);
        }
        GrCodeReferenceElement grCodeReferenceElement = this.createElementFromText(refName, context, GroovyElementTypes.CODE_REFERENCE, GrCodeReferenceElement.class);
        if (grCodeReferenceElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(10);
        }
        return grCodeReferenceElement;
    }

    @Override
    @NotNull
    public GrReferenceExpression createReferenceExpressionFromText(@NotNull String idText) {
        GroovyFile file;
        GrTopStatement[] statements;
        if (idText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(11);
        }
        if ((statements = (file = this.createGroovyFileChecked(idText)).getTopStatements()).length != 1 || !(statements[0] instanceof GrReferenceExpression)) {
            throw new IncorrectOperationException(idText);
        }
        GrReferenceExpression grReferenceExpression = (GrReferenceExpression)statements[0];
        if (grReferenceExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(12);
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GrReferenceExpression createReferenceExpressionFromText(@NotNull String idText, PsiElement context) {
        GroovyFile file;
        GrTopStatement[] statements;
        if (idText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(13);
        }
        if ((statements = (file = this.createGroovyFileChecked(idText, false, context)).getTopStatements()).length != 1) {
            throw new IncorrectOperationException("refText: " + idText);
        }
        if (!(statements[0] instanceof GrReferenceExpression)) {
            throw new IncorrectOperationException("refText: " + idText);
        }
        GrReferenceExpression grReferenceExpression = (GrReferenceExpression)statements[0];
        if (grReferenceExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(14);
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GrReferenceExpression createReferenceElementForClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(15);
        }
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        GrReferenceExpression grReferenceExpression = this.createReferenceExpressionFromText(text);
        if (grReferenceExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(16);
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GrExpression createExpressionFromText(@NotNull String text, PsiElement context) {
        GroovyFile file;
        GrTopStatement[] topStatements;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(17);
        }
        if ((topStatements = (file = this.createGroovyFile(text, false, context)).getTopStatements()).length == 0 || !(topStatements[0] instanceof GrExpression)) {
            throw new IncorrectOperationException("incorrect expression = '" + text + "'");
        }
        GrExpression grExpression = (GrExpression)topStatements[0];
        if (grExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(18);
        }
        return grExpression;
    }

    @NotNull
    public GrCodeReferenceElement createReferenceElementByType(PsiClassType type) {
        GrReferenceElement reference;
        if (type instanceof GrClassReferenceType && (reference = ((GrClassReferenceType)type).getReference()) instanceof GrCodeReferenceElement) {
            GrCodeReferenceElement grCodeReferenceElement = (GrCodeReferenceElement)reference;
            if (grCodeReferenceElement == null) {
                GroovyPsiElementFactoryImpl.$$$reportNull$$$0(19);
            }
            return grCodeReferenceElement;
        }
        PsiClassType.ClassResolveResult resolveResult = type.resolveGenerics();
        PsiClass refClass = resolveResult.getElement();
        assert (refClass != null) : type;
        GrCodeReferenceElement grCodeReferenceElement = this.createCodeReferenceElementFromText(type.getCanonicalText());
        if (grCodeReferenceElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(20);
        }
        return grCodeReferenceElement;
    }

    @NotNull
    public PsiTypeParameterList createTypeParameterList() {
        PsiTypeParameterList psiTypeParameterList = this.createMethodFromText("def <> void foo(){}").getTypeParameterList();
        if (psiTypeParameterList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(21);
        }
        return psiTypeParameterList;
    }

    @NotNull
    public PsiTypeParameter createTypeParameter(String name, PsiClassType[] superTypes) {
        PsiTypeParameter psiTypeParameter;
        StringBuilder builder = new StringBuilder();
        builder.append("def <").append(name);
        if (superTypes.length > 1 || superTypes.length == 1 && !superTypes[0].equalsToText("java.lang.Object")) {
            builder.append(" extends ");
            for (PsiClassType type : superTypes) {
                if (type.equalsToText("java.lang.Object")) continue;
                builder.append(type.getCanonicalText()).append(',');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("> void foo(){}");
        try {
            psiTypeParameter = this.createMethodFromText(builder).getTypeParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("type parameter text: " + builder);
        }
        if (psiTypeParameter == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(22);
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createVariableDeclaration(@Nullable String[] modifiers, @Nullable GrExpression initializer, @Nullable PsiType type, String ... identifiers) {
        String initializerText;
        if (initializer != null) {
            if (initializer instanceof GrApplicationStatement && !GroovyConfigUtils.getInstance().isVersionAtLeast(initializer, "1.8", false)) {
                initializer = this.createMethodCallByAppCall((GrApplicationStatement)initializer);
            }
            assert (initializer != null);
            initializerText = initializer.getText();
        } else {
            initializerText = null;
        }
        GrVariableDeclaration grVariableDeclaration = this.createVariableDeclaration(modifiers, initializerText, type, identifiers);
        if (grVariableDeclaration == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(23);
        }
        return grVariableDeclaration;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createVariableDeclaration(@Nullable String[] modifiers, @Nullable String initializer, @Nullable PsiType type, String ... identifiers) {
        GrTopStatement[] topStatements;
        StringBuilder text = GroovyPsiElementFactoryImpl.writeModifiers(modifiers);
        if (type != null && type != PsiType.NULL) {
            PsiType unboxed = TypesUtil.unboxPrimitiveTypeWrapper(type);
            String typeText = GroovyPsiElementFactoryImpl.getTypeText(unboxed);
            text.append(typeText).append(" ");
        } else if (text.length() == 0) {
            text.insert(0, "def ");
        }
        if (identifiers.length > 1 && initializer != null) {
            text.append('(');
        }
        for (int i = 0; i < identifiers.length; ++i) {
            if (i > 0) {
                text.append(", ");
            }
            String identifier = identifiers[i];
            text.append(identifier);
        }
        if (identifiers.length > 1 && initializer != null) {
            text.append(')');
        }
        if (!StringUtil.isEmptyOrSpaces((String)initializer)) {
            text.append(" = ").append(initializer);
        }
        if ((topStatements = this.createGroovyFileChecked(text).getTopStatements()).length == 0 || !(topStatements[0] instanceof GrVariableDeclaration)) {
            topStatements = this.createGroovyFileChecked("def " + text).getTopStatements();
        }
        if (topStatements.length == 0 || !(topStatements[0] instanceof GrVariableDeclaration)) {
            throw new RuntimeException("Invalid arguments, text = " + text);
        }
        GrVariableDeclaration statement = (GrVariableDeclaration)topStatements[0];
        CodeEditUtil.markToReformatBefore((ASTNode)statement.getNode().findLeafElementAt(0), (boolean)true);
        GrVariableDeclaration grVariableDeclaration = statement;
        if (grVariableDeclaration == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(24);
        }
        return grVariableDeclaration;
    }

    @Override
    @NotNull
    public GrEnumConstant createEnumConstantFromText(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(25);
        }
        GroovyFile file = this.createGroovyFileChecked("enum E{" + text + "}");
        GrEnumTypeDefinition enumClass = (GrEnumTypeDefinition)file.getClasses()[0];
        GrEnumConstant grEnumConstant = enumClass.getEnumConstants()[0];
        if (grEnumConstant == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(26);
        }
        return grEnumConstant;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createFieldDeclaration(@NotNull String[] modifiers, @NotNull String identifier, @Nullable GrExpression initializer, @Nullable PsiType type) {
        if (modifiers == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(27);
        }
        if (identifier == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(28);
        }
        String varDeclaration = this.createVariableDeclaration(modifiers, initializer, type, identifier).getText();
        GroovyFile file = this.createGroovyFileChecked("class A { " + varDeclaration + "}");
        GrTypeDefinitionBody body = file.getTypeDefinitions()[0].getBody();
        LOG.assertTrue(body.getMemberDeclarations().length == 1 && body.getMemberDeclarations()[0] instanceof GrVariableDeclaration, (Object)("ident = <" + identifier + "> initializer = " + (initializer == null ? "_null_" : "<" + initializer.getText() + ">")));
        GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)body.getMemberDeclarations()[0];
        if (grVariableDeclaration == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(29);
        }
        return grVariableDeclaration;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createFieldDeclarationFromText(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(30);
        }
        GroovyFile file = this.createGroovyFileChecked("class X{\n" + text + "\n}");
        PsiClass psiClass = file.getClasses()[0];
        GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)psiClass.getFields()[0].getParent();
        if (grVariableDeclaration == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(31);
        }
        return grVariableDeclaration;
    }

    private static StringBuilder writeModifiers(String[] modifiers) {
        StringBuilder text = new StringBuilder();
        if (modifiers != null && modifiers.length != 0) {
            for (String modifier : modifiers) {
                text.append(modifier);
                text.append(" ");
            }
        }
        return text;
    }

    private static String getTypeText(PsiType type) {
        if (!(type instanceof PsiArrayType)) {
            String text;
            String canonical = type.getCanonicalText();
            String string = text = canonical != null ? canonical : type.getPresentableText();
            if ("null".equals(text)) {
                return "";
            }
            return text;
        }
        return GroovyPsiElementFactoryImpl.getTypeText(((PsiArrayType)type).getComponentType()) + "[]";
    }

    @Override
    @NotNull
    public GrTopStatement createTopElementFromText(@NotNull String text) {
        GroovyFile dummyFile;
        GrTopStatement[] topStatements;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(32);
        }
        if ((topStatements = (dummyFile = this.createGroovyFileChecked(text)).getTopStatements()).length != 1) {
            throw new IncorrectOperationException("text = '" + text + "'");
        }
        GrTopStatement grTopStatement = topStatements[0];
        if (grTopStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(33);
        }
        return grTopStatement;
    }

    @Override
    @NotNull
    public GrClosableBlock createClosureFromText(@NotNull String closureText, PsiElement context) throws IncorrectOperationException {
        if (closureText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(34);
        }
        GroovyFile psiFile = this.createGroovyFileChecked("def __hdsjfghk_sdhjfshglk_foo  = " + closureText, false, context);
        GrStatement st = psiFile.getStatements()[0];
        LOG.assertTrue(st instanceof GrVariableDeclaration, (Object)closureText);
        GrExpression initializer = ((GrVariableDeclaration)st).getVariables()[0].getInitializerGroovy();
        LOG.assertTrue(initializer instanceof GrClosableBlock, (Object)closureText);
        GrClosableBlock grClosableBlock = (GrClosableBlock)initializer;
        if (grClosableBlock == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(35);
        }
        return grClosableBlock;
    }

    private GroovyFileImpl createDummyFile(@NotNull CharSequence text, boolean physical) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(36);
        }
        String fileName = "DUMMY__1234567890_DUMMYYYYYY___." + GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension();
        long stamp = System.currentTimeMillis();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myProject);
        return (GroovyFileImpl)factory.createFileFromText(fileName, (FileType)GroovyFileType.GROOVY_FILE_TYPE, text, stamp, physical);
    }

    @Override
    @NotNull
    public GrParameter createParameter(@NotNull String name, @Nullable String typeText, @Nullable String initializer, @Nullable GroovyPsiElement context, String ... modifiers) throws IncorrectOperationException {
        GrParameter grParameter;
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(37);
        }
        try {
            StringBuilder fileText = new StringBuilder();
            fileText.append("def dsfsadfnbhfjks_weyripouh_huihnrecuio(");
            for (String modifier : modifiers) {
                fileText.append(modifier).append(' ');
            }
            if (StringUtil.isNotEmpty((String)typeText)) {
                fileText.append(typeText).append(' ');
            }
            fileText.append(name);
            if (initializer != null && !initializer.isEmpty()) {
                fileText.append(" = ").append(initializer);
            }
            fileText.append("){}");
            GroovyFile groovyFile = this.createGroovyFileChecked(fileText, false, context);
            ASTNode node = groovyFile.getFirstChild().getNode();
            grParameter = ((GrMethod)node.getPsi()).getParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("name = " + name + ", type = " + typeText + ", initializer = " + initializer);
        }
        if (grParameter == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(38);
        }
        return grParameter;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement createTypeOrPackageReference(@NotNull String qName) {
        GrCodeReferenceElement grCodeReferenceElement;
        if (qName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(39);
        }
        try {
            GroovyFile file = this.createGroovyFileChecked("def i = new " + qName + "()");
            GrStatement[] statements = file.getStatements();
            GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)statements[0];
            GrVariable var = variableDeclaration.getVariables()[0];
            GrExpression initializer = var.getInitializerGroovy();
            grCodeReferenceElement = ((GrNewExpression)initializer).getReferenceElement();
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("reference text=" + qName, (Throwable)e);
        }
        if (grCodeReferenceElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(40);
        }
        return grCodeReferenceElement;
    }

    @Override
    @NotNull
    public GrTypeDefinition createTypeDefinition(@NotNull String text) throws IncorrectOperationException {
        GroovyFile file;
        GrTypeDefinition[] classes2;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(41);
        }
        if ((classes2 = (file = this.createGroovyFileChecked(text)).getTypeDefinitions()).length != 1) {
            throw new IncorrectOperationException("Incorrect type definition text");
        }
        GrTypeDefinition grTypeDefinition = classes2[0];
        if (grTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(42);
        }
        return grTypeDefinition;
    }

    @Override
    @NotNull
    public GrTypeElement createTypeElement(@NotNull String typeText, @Nullable PsiElement context) throws IncorrectOperationException {
        if (typeText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(43);
        }
        GrTypeElement grTypeElement = this.createElementFromText(typeText, context, GroovyElementTypes.TYPE_ELEMENT, GrTypeElement.class);
        if (grTypeElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(44);
        }
        return grTypeElement;
    }

    @Override
    @NotNull
    public GrTypeElement createTypeElement(@NotNull PsiType type) throws IncorrectOperationException {
        String typeText;
        if (type == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(45);
        }
        if ((typeText = GroovyPsiElementFactoryImpl.getTypeText(type)) == null) {
            throw new IncorrectOperationException("Cannot create type element: cannot obtain text for type");
        }
        GrTypeElement grTypeElement = this.createTypeElement(typeText);
        if (grTypeElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(46);
        }
        return grTypeElement;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(47);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(48);
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public GrParenthesizedExpression createParenthesizedExpr(@NotNull GrExpression expression) {
        if (expression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(49);
        }
        GrParenthesizedExpression grParenthesizedExpression = (GrParenthesizedExpression)this.createExpressionFromText("(" + expression.getText() + ")");
        if (grParenthesizedExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(50);
        }
        return grParenthesizedExpression;
    }

    @Override
    @NotNull
    public PsiElement createStringLiteralForReference(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(51);
        }
        PsiElement psiElement = this.createLiteralFromValue(text).getFirstChild();
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(52);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement createModifierFromText(@NotNull String name) {
        GroovyFile file;
        GrTopStatement[] definitions;
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(53);
        }
        if ((definitions = (file = this.createGroovyFileChecked(name + " foo() {}")).getTopStatements()).length != 1) {
            throw new IncorrectOperationException(name);
        }
        PsiElement psiElement = definitions[0].getFirstChild().getFirstChild();
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(54);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public GrCodeBlock createMethodBodyFromText(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(55);
        }
        GroovyFile file = this.createGroovyFileChecked("def foo () {" + text + "}");
        GrMethod method = (GrMethod)file.getTopStatements()[0];
        GrOpenBlock grOpenBlock = method.getBlock();
        if (grOpenBlock == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(56);
        }
        return grOpenBlock;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createSimpleVariableDeclaration(@NotNull String name, @NotNull String typeText) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(57);
        }
        if (typeText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(58);
        }
        String classText = Character.isLowerCase(typeText.charAt(0)) ? "class A { def " + typeText + " " + name + "}" : "class A { " + typeText + " " + name + "}";
        GroovyFile file = this.createGroovyFileChecked(classText);
        GrTypeDefinitionBody body = file.getTypeDefinitions()[0].getBody();
        GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)body.getMemberDeclarations()[0];
        if (grVariableDeclaration == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(59);
        }
        return grVariableDeclaration;
    }

    @Override
    @NotNull
    public PsiElement createDotToken(@NotNull String newDot) {
        if (newDot == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(60);
        }
        PsiElement psiElement = this.createReferenceExpressionFromText("a" + newDot + "b").getDotToken();
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(61);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public GrMethod createConstructorFromText(@NotNull String constructorName, @Nullable String[] paramTypes, @NotNull String[] paramNames, @Nullable String body, @Nullable PsiElement context) {
        if (constructorName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(62);
        }
        if (paramNames == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(63);
        }
        CharSequence text = GroovyPsiElementFactoryImpl.generateMethodText(null, constructorName, null, paramTypes, paramNames, body, true);
        GrMethod grMethod = this.createConstructorFromText(constructorName, text, context);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(64);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrMethod createConstructorFromText(String constructorName, CharSequence constructorText, @Nullable PsiElement context) {
        GroovyFile file = this.createGroovyFileChecked("class " + constructorName + "{" + constructorText + "}", false, context);
        GrTypeDefinition definition = file.getTypeDefinitions()[0];
        if (definition == null) {
            throw new IncorrectOperationException("constructorName: " + constructorName + ", text: " + constructorText);
        }
        GrMethod[] methods = definition.getCodeMethods();
        if (methods.length != 1) {
            throw new IncorrectOperationException("constructorName: " + constructorName + ", text: " + constructorText);
        }
        GrMethod grMethod = methods[0];
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(65);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrMethod createMethodFromText(String methodText, @Nullable PsiElement context) {
        if (methodText == null) {
            throw new IncorrectOperationException("Method text not provided");
        }
        GroovyFile file = this.createGroovyFile(methodText, false, context);
        GrTopStatement[] definitions = file.getTopStatements();
        if (definitions.length != 1) {
            throw new IncorrectOperationException("Can't create method from text: '" + file.getText() + "'");
        }
        GrTopStatement definition = definitions[0];
        if (!(definition instanceof GrMethod)) {
            throw new IncorrectOperationException("Can't create method from text: '" + file.getText() + "'");
        }
        GrMethod grMethod = (GrMethod)definition;
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(66);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrAnnotation createAnnotationFromText(@NotNull @NonNls String annotationText, @Nullable PsiElement context) throws IncorrectOperationException {
        if (annotationText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(67);
        }
        GrAnnotation grAnnotation = this.createMethodFromText(annotationText + " void ___shdjklf_pqweirupncp_foo() {}", context).getModifierList().getRawAnnotations()[0];
        if (grAnnotation == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(68);
        }
        return grAnnotation;
    }

    @Override
    @NotNull
    public GrMethod createMethodFromSignature(@NotNull String name, @NotNull GrClosureSignature signature) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(69);
        }
        if (signature == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(70);
        }
        StringBuilder builder = new StringBuilder("public");
        PsiType returnType = signature.getReturnType();
        if (returnType != null && returnType != PsiType.NULL) {
            builder.append(' ');
            builder.append(returnType.getCanonicalText());
        }
        builder.append(' ').append(name).append('(');
        int i = 0;
        for (GrClosureParameter parameter : signature.getParameters()) {
            PsiType type = parameter.getType();
            if (type != null) {
                builder.append(type.getCanonicalText());
                builder.append(' ');
            }
            builder.append('p').append(++i);
            GrExpression initializer = parameter.getDefaultInitializer();
            if (initializer == null) continue;
            builder.append(" = ").append(initializer.getText());
            builder.append(", ");
        }
        if (signature.getParameterCount() > 0) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("){}");
        GrMethod grMethod = this.createMethodFromText(builder);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(71);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrAnnotation createAnnotationFromText(@NotNull String annoText) {
        if (annoText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(72);
        }
        GrAnnotation grAnnotation = this.createAnnotationFromText(annoText, null);
        if (grAnnotation == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(73);
        }
        return grAnnotation;
    }

    private GroovyFile createGroovyFileChecked(@NotNull CharSequence idText) {
        if (idText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(74);
        }
        return this.createGroovyFileChecked(idText, false, null);
    }

    private GroovyFile createGroovyFileChecked(@NotNull CharSequence idText, boolean isPhysical, @Nullable PsiElement context) {
        GroovyFileImpl file;
        if (idText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(75);
        }
        if (ErrorUtil.containsError(file = this.createDummyFile(idText, isPhysical))) {
            throw new IncorrectOperationException("cannot create file from text: " + idText);
        }
        file.setContext(context);
        return file;
    }

    @Override
    @NotNull
    public GroovyFile createGroovyFile(@NotNull CharSequence idText, boolean isPhysical, @Nullable PsiElement context) {
        if (idText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(76);
        }
        GroovyFileImpl file = this.createDummyFile(idText, isPhysical);
        file.setContext(context);
        GroovyFileImpl groovyFileImpl = file;
        if (groovyFileImpl == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(77);
        }
        return groovyFileImpl;
    }

    @Override
    @NotNull
    public PsiElement createWhiteSpace() {
        GroovyFileImpl dummyFile = this.createDummyFile(" ", false);
        PsiElement psiElement = dummyFile.getFirstChild();
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(78);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement createLineTerminator(int length) {
        String text;
        String string = text = length <= 1 ? "\n" : "";
        if (length > 1) {
            text = StringUtil.repeatSymbol((char)'\n', (int)length);
        }
        PsiElement psiElement = this.createLineTerminator(text);
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(79);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement createLineTerminator(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(80);
        }
        GroovyFile dummyFile = this.createGroovyFileChecked(text);
        PsiElement child = dummyFile.getFirstChild();
        assert (child != null);
        PsiElement psiElement = child;
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(81);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public GrArgumentList createExpressionArgumentList(GrExpression ... expressions) {
        StringBuilder text = new StringBuilder();
        text.append("ven (");
        for (GrExpression expression : expressions) {
            text.append(expression.getText()).append(", ");
        }
        if (expressions.length > 0) {
            text.delete(text.length() - 2, text.length());
        }
        text.append(')');
        GroovyFile file = this.createGroovyFileChecked(text);
        assert (file.getChildren()[0] != null && file.getChildren()[0] instanceof GrMethodCallExpression);
        GrArgumentList grArgumentList = ((GrMethodCallExpression)file.getChildren()[0]).getArgumentList();
        if (grArgumentList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(82);
        }
        return grArgumentList;
    }

    @Override
    @NotNull
    public GrNamedArgument createNamedArgument(@NotNull String name, @NotNull GrExpression expression) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(83);
        }
        if (expression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(84);
        }
        GroovyFile file = this.createGroovyFileChecked("foo (" + name + ":" + expression.getText() + ")");
        assert (file.getChildren()[0] != null);
        GrCall call = (GrCall)file.getChildren()[0];
        GrNamedArgument grNamedArgument = call.getArgumentList().getNamedArguments()[0];
        if (grNamedArgument == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(85);
        }
        return grNamedArgument;
    }

    @Override
    @NotNull
    public GrStatement createStatementFromText(@NotNull CharSequence text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(86);
        }
        GrStatement grStatement = this.createStatementFromText(text, null);
        if (grStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(87);
        }
        return grStatement;
    }

    @Override
    @NotNull
    public GrStatement createStatementFromText(@NotNull CharSequence text, @Nullable PsiElement context) {
        GroovyFile file;
        GrTopStatement[] statements;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(88);
        }
        if ((statements = (file = this.createGroovyFileChecked(text, false, context)).getTopStatements()).length != 1) {
            throw new IncorrectOperationException("count = " + statements.length + ", " + text);
        }
        if (!(statements[0] instanceof GrStatement)) {
            throw new IncorrectOperationException("type = " + statements[0].getClass().getName() + ", " + text);
        }
        GrStatement grStatement = (GrStatement)statements[0];
        if (grStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(89);
        }
        return grStatement;
    }

    @Override
    @NotNull
    public GrBlockStatement createBlockStatement(GrStatement ... statements) {
        StringBuilder text = new StringBuilder();
        text.append("while (true) { \n");
        for (GrStatement statement : statements) {
            text.append(statement.getText()).append("\n");
        }
        text.append("}");
        GroovyFile file = this.createGroovyFileChecked(text);
        LOG.assertTrue(file.getChildren()[0] != null && file.getChildren()[0] instanceof GrWhileStatement, (Object)text);
        GrBlockStatement grBlockStatement = (GrBlockStatement)((GrWhileStatement)file.getChildren()[0]).getBody();
        if (grBlockStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(90);
        }
        return grBlockStatement;
    }

    @Override
    @NotNull
    public GrMethodCallExpression createMethodCallByAppCall(@NotNull GrApplicationStatement callExpr) {
        if (callExpr == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(91);
        }
        StringBuilder text = new StringBuilder();
        text.append(callExpr.getInvokedExpression().getText());
        text.append("(");
        GrCommandArgumentList argumentList = callExpr.getArgumentList();
        if (argumentList != null) {
            text.append(argumentList.getText());
        }
        text.append(")");
        GroovyFile file = this.createGroovyFileChecked(text);
        assert (file.getChildren()[0] != null && file.getChildren()[0] instanceof GrMethodCallExpression);
        GrMethodCallExpression grMethodCallExpression = (GrMethodCallExpression)file.getChildren()[0];
        if (grMethodCallExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(92);
        }
        return grMethodCallExpression;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement createCodeReferenceElementFromClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(93);
        }
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("cannot create code reference element for anonymous class " + aClass.getText());
        }
        GrCodeReferenceElement grCodeReferenceElement = this.createCodeReferenceElementFromText(aClass.getQualifiedName());
        if (grCodeReferenceElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(94);
        }
        return grCodeReferenceElement;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement createCodeReferenceElementFromText(@NotNull String text) {
        GroovyFile file;
        PsiClass[] classes2;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(95);
        }
        if ((classes2 = (file = this.createGroovyFileChecked("class X extends " + text + "{}")).getClasses()).length != 1) {
            throw new IncorrectOperationException("cannot create code reference element for class" + text);
        }
        GrExtendsClause extendsClause = ((GrTypeDefinition)classes2[0]).getExtendsClause();
        if (extendsClause == null) {
            throw new IncorrectOperationException("cannot create code reference element for class" + text);
        }
        GrCodeReferenceElement[] refElements = extendsClause.getReferenceElementsGroovy();
        if (refElements.length != 1) {
            throw new IncorrectOperationException("cannot create code reference element for class" + text);
        }
        GrCodeReferenceElement grCodeReferenceElement = refElements[0];
        if (grCodeReferenceElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(96);
        }
        return grCodeReferenceElement;
    }

    @Override
    @NotNull
    public GrReferenceExpression createThisExpression(@Nullable PsiClass psiClass) {
        String qname;
        String text = psiClass == null ? "this" : (StringUtil.isEmpty((String)(qname = psiClass.getQualifiedName())) ? "this" : qname + ".this");
        GrReferenceExpression grReferenceExpression = this.createReferenceExpressionFromText(text, (PsiElement)psiClass);
        if (grReferenceExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(97);
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GrBlockStatement createBlockStatementFromText(@NotNull String text, @Nullable PsiElement context) {
        GroovyFile file;
        GrStatement[] statements;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(98);
        }
        LOG.assertTrue((statements = (file = this.createGroovyFileChecked("if(true)" + text, false, context)).getStatements()).length == 1 && statements[0] instanceof GrIfStatement, (Object)text);
        GrStatement branch = ((GrIfStatement)statements[0]).getThenBranch();
        LOG.assertTrue(branch instanceof GrBlockStatement);
        GrBlockStatement grBlockStatement = (GrBlockStatement)branch;
        if (grBlockStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(99);
        }
        return grBlockStatement;
    }

    @Override
    @NotNull
    public GrModifierList createModifierList(@NotNull CharSequence text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(100);
        }
        GrMethod method = this.createMethodFromText(text + " void foo()");
        GrModifierList grModifierList = method.getModifierList();
        if (grModifierList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(101);
        }
        return grModifierList;
    }

    @Override
    @NotNull
    public GrCaseSection createSwitchSection(@NotNull String text) {
        GrStatement statement;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(102);
        }
        if (!((statement = this.createStatementFromText("switch (a) {\n" + text + "\n}")) instanceof GrSwitchStatement)) {
            throw new IncorrectOperationException("Cannot create switch section from text: " + text);
        }
        GrCaseSection[] sections = ((GrSwitchStatement)statement).getCaseSections();
        if (sections.length != 1) {
            throw new IncorrectOperationException("Cannot create switch section from text: " + text);
        }
        GrCaseSection grCaseSection = sections[0];
        if (grCaseSection == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(103);
        }
        return grCaseSection;
    }

    @Override
    @NotNull
    public GrImportStatement createImportStatementFromText(@NotNull String qName, boolean isStatic, boolean isOnDemand, String alias) {
        if (qName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(104);
        }
        GrImportStatement grImportStatement = this.createImportStatement(qName, isStatic, isOnDemand, alias, null);
        if (grImportStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(105);
        }
        return grImportStatement;
    }

    @Override
    @NotNull
    public GrImportStatement createImportStatementFromText(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(106);
        }
        GroovyFile dummyFile = this.createGroovyFileChecked(text);
        GrImportStatement grImportStatement = (GrImportStatement)dummyFile.getFirstChild();
        if (grImportStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(107);
        }
        return grImportStatement;
    }

    @Override
    @NotNull
    public GrImportStatement createImportStatement(@NotNull String qname, boolean isStatic, boolean isOnDemand, String alias, PsiElement context) {
        if (qname == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(108);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("import ");
        if (isStatic) {
            builder.append("static ");
        }
        builder.append(qname);
        if (isOnDemand) {
            builder.append(".*");
        }
        if (StringUtil.isNotEmpty((String)alias)) {
            builder.append(" as ").append(alias);
        }
        GroovyFile dummyFile = this.createGroovyFileChecked(builder, false, context);
        GrImportStatement grImportStatement = (GrImportStatement)dummyFile.getFirstChild();
        if (grImportStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(109);
        }
        return grImportStatement;
    }

    private static CharSequence generateMethodText(@Nullable String modifier, @NotNull String name, @Nullable String type, @NotNull String[] paramTypes, @NotNull String[] paramNames, @Nullable String body, boolean isConstructor) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(110);
        }
        if (paramTypes == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(111);
        }
        if (paramNames == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(112);
        }
        StringBuilder builder = new StringBuilder();
        if (modifier != null) {
            builder.append(modifier);
            builder.append(" ");
        }
        if (!isConstructor) {
            builder.append("def ");
        }
        if (type != null) {
            builder.append(type);
            builder.append(" ");
        }
        builder.append(name);
        builder.append("(");
        for (int i = 0; i < paramNames.length; ++i) {
            String paramType;
            String string = paramType = paramTypes == null ? null : paramTypes[i];
            if (i > 0) {
                builder.append(", ");
            }
            if (paramType != null) {
                builder.append(paramType);
                builder.append(" ");
            }
            builder.append(paramNames[i]);
        }
        builder.append(")");
        if (body != null) {
            builder.append(body);
        } else {
            builder.append("{");
            builder.append("}");
        }
        return builder;
    }

    @Override
    @NotNull
    public GrMethod createMethodFromText(@NotNull String modifier, @NotNull String name, @Nullable String type, @NotNull String[] paramTypes, PsiElement context) {
        if (modifier == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(113);
        }
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(114);
        }
        if (paramTypes == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(115);
        }
        ArrayList<PsiType> res = new ArrayList<PsiType>();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
        for (String paramType : paramTypes) {
            PsiType psiType;
            try {
                psiType = factory.createTypeElement(paramType).getType();
            }
            catch (IncorrectOperationException e) {
                psiType = TypesUtil.getJavaLangObject(context);
            }
            res.add(psiType);
        }
        String[] paramNames = GroovyNamesUtil.getMethodArgumentsNames(this.myProject, res.toArray(PsiType.createArray((int)res.size())));
        CharSequence text = GroovyPsiElementFactoryImpl.generateMethodText(modifier, name, type, paramTypes, paramNames, null, false);
        GrMethod grMethod = this.createMethodFromText(text.toString(), context);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(116);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrDocComment createDocCommentFromText(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(117);
        }
        GrDocComment grDocComment = (GrDocComment)this.createGroovyFileChecked(text).getFirstChild();
        if (grDocComment == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(118);
        }
        return grDocComment;
    }

    @Override
    @NotNull
    public GrConstructorInvocation createConstructorInvocation(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(119);
        }
        GrConstructorInvocation grConstructorInvocation = this.createConstructorInvocation(text, null);
        if (grConstructorInvocation == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(120);
        }
        return grConstructorInvocation;
    }

    @Override
    @NotNull
    public GrConstructorInvocation createConstructorInvocation(@NotNull String text, @Nullable PsiElement context) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(121);
        }
        GroovyFile file = this.createGroovyFileChecked("class Foo{ def Foo(){" + text + "}}", false, context);
        GrConstructorInvocation grConstructorInvocation = PsiImplUtil.getChainingConstructorInvocation((GrMethod)file.getClasses()[0].getConstructors()[0]);
        if (grConstructorInvocation == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(122);
        }
        return grConstructorInvocation;
    }

    @Override
    @NotNull
    public PsiReferenceList createThrownList(@NotNull PsiClassType[] exceptionTypes) {
        if (exceptionTypes == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(123);
        }
        if (exceptionTypes.length == 0) {
            PsiReferenceList psiReferenceList = this.createMethodFromText("def foo(){}", null).getThrowsList();
            if (psiReferenceList == null) {
                GroovyPsiElementFactoryImpl.$$$reportNull$$$0(124);
            }
            return psiReferenceList;
        }
        String[] types = new String[exceptionTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = exceptionTypes[i].getCanonicalText();
        }
        String end = StringUtil.join((String[])types, (String)",");
        PsiReferenceList psiReferenceList = this.createMethodFromText("def foo() throws " + end + "{}", null).getThrowsList();
        if (psiReferenceList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(125);
        }
        return psiReferenceList;
    }

    @Override
    @NotNull
    public GrCatchClause createCatchClause(@NotNull PsiClassType type, @NotNull String parameterName) {
        if (type == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(126);
        }
        if (parameterName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(127);
        }
        StringBuilder buffer = new StringBuilder("try{} catch(");
        if (type == null) {
            buffer.append("Throwable ");
        } else {
            buffer.append(type.getCanonicalText()).append(" ");
        }
        buffer.append(parameterName).append("){\n}");
        GrTryCatchStatement statement = (GrTryCatchStatement)this.createStatementFromText(buffer);
        GrCatchClause grCatchClause = statement.getCatchClauses()[0];
        if (grCatchClause == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(128);
        }
        return grCatchClause;
    }

    @Override
    @NotNull
    public GrArgumentList createArgumentList() {
        GrArgumentList grArgumentList = ((GrCall)((Object)this.createExpressionFromText("foo()"))).getArgumentList();
        if (grArgumentList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(129);
        }
        return grArgumentList;
    }

    @Override
    @NotNull
    public GrArgumentList createArgumentListFromText(@NotNull String argListText) {
        GrArgumentList grArgumentList;
        if (argListText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(130);
        }
        try {
            grArgumentList = ((GrCall)((Object)this.createExpressionFromText("foo " + argListText))).getArgumentList();
        }
        catch (IncorrectOperationException e) {
            LOG.debug(argListText);
            throw e;
        }
        if (grArgumentList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(131);
        }
        return grArgumentList;
    }

    @Override
    @NotNull
    public GrExtendsClause createExtendsClause() {
        GrTypeDefinition typeDefinition = this.createTypeDefinition("class A extends B {}");
        GrExtendsClause clause = typeDefinition.getExtendsClause();
        clause.getReferenceElementsGroovy()[0].delete();
        GrExtendsClause grExtendsClause = clause;
        if (grExtendsClause == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(132);
        }
        return grExtendsClause;
    }

    @Override
    @NotNull
    public GrImplementsClause createImplementsClause() {
        GrTypeDefinition typeDefinition = this.createTypeDefinition("class A implements B {}");
        GrImplementsClause clause = typeDefinition.getImplementsClause();
        clause.getReferenceElementsGroovy()[0].delete();
        GrImplementsClause grImplementsClause = clause;
        if (grImplementsClause == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(133);
        }
        return grImplementsClause;
    }

    @Override
    @NotNull
    public GrLiteral createLiteralFromValue(@Nullable Object value) {
        if (value instanceof String) {
            StringBuilder buffer = GrStringUtil.getLiteralTextByValue((String)value);
            GrExpression expr = this.createExpressionFromText(buffer);
            LOG.assertTrue(expr instanceof GrLiteral, (Object)("value = " + value));
            GrLiteral grLiteral = (GrLiteral)expr;
            if (grLiteral == null) {
                GroovyPsiElementFactoryImpl.$$$reportNull$$$0(134);
            }
            return grLiteral;
        }
        if (value == null) {
            GrLiteral grLiteral = (GrLiteral)this.createExpressionFromText("null");
            if (grLiteral == null) {
                GroovyPsiElementFactoryImpl.$$$reportNull$$$0(135);
            }
            return grLiteral;
        }
        if (value instanceof Boolean) {
            GrLiteral grLiteral = (GrLiteral)this.createExpressionFromText(value.toString());
            if (grLiteral == null) {
                GroovyPsiElementFactoryImpl.$$$reportNull$$$0(136);
            }
            return grLiteral;
        }
        throw new IncorrectOperationException("Can not create literal from type: " + value.getClass().getName());
    }

    @NotNull
    public PsiClass createClass(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(137);
        }
        GrTypeDefinition grTypeDefinition = this.createTypeDefinition("class " + name + "{}");
        if (grTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(138);
        }
        return grTypeDefinition;
    }

    @NotNull
    public PsiClass createInterface(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(139);
        }
        GrTypeDefinition grTypeDefinition = this.createTypeDefinition("interface " + name + "{}");
        if (grTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(140);
        }
        return grTypeDefinition;
    }

    @NotNull
    public PsiClass createEnum(@NotNull @NonNls String name) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(141);
        }
        GrTypeDefinition grTypeDefinition = this.createTypeDefinition("enum " + name + "{}");
        if (grTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(142);
        }
        return grTypeDefinition;
    }

    @Override
    @NotNull
    public GrField createField(@NotNull @NonNls String name, @NotNull PsiType type) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(143);
        }
        if (type == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(144);
        }
        GrVariableDeclaration fieldDeclaration = this.createFieldDeclaration(ArrayUtil.EMPTY_STRING_ARRAY, name, null, type);
        GrField grField = (GrField)fieldDeclaration.getVariables()[0];
        if (grField == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(145);
        }
        return grField;
    }

    @Override
    @NotNull
    public GrTraitTypeDefinition createTrait(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(146);
        }
        GrTraitTypeDefinition grTraitTypeDefinition = (GrTraitTypeDefinition)this.createTypeDefinition("trait " + name + "{}");
        if (grTraitTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(147);
        }
        return grTraitTypeDefinition;
    }

    @Override
    @NotNull
    public GrMethod createMethod(@NotNull @NonNls String name, @Nullable PsiType returnType) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(148);
        }
        GrMethod grMethod = this.createMethod(name, returnType, null);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(149);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrMethod createMethod(@NotNull @NonNls String name, PsiType returnType, PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(150);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("def <T>");
        if (returnType != null) {
            builder.append(returnType.getCanonicalText());
        }
        builder.append(' ');
        if (GroovyNamesUtil.isIdentifier(name)) {
            builder.append(name);
        } else {
            builder.append('\"');
            builder.append(GrStringUtil.escapeSymbolsForGString(name, true, false));
            builder.append('\"');
        }
        builder.append("(){}");
        GrMethod method = this.createMethodFromText(builder.toString(), context);
        PsiTypeParameterList typeParameterList = method.getTypeParameterList();
        assert (typeParameterList != null);
        typeParameterList.getFirstChild().delete();
        typeParameterList.getFirstChild().delete();
        typeParameterList.getFirstChild().delete();
        if (returnType != null) {
            method.getModifierList().setModifierProperty("def", false);
        }
        GrMethod grMethod = method;
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(151);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrMethod createConstructor() {
        GrMethod grMethod = this.createConstructorFromText("Foo", "Foo(){}", null);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(152);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrClassInitializer createClassInitializer() throws IncorrectOperationException {
        GrTypeDefinition typeDefinition = this.createTypeDefinition("class X {{}}");
        GrClassInitializer grClassInitializer = typeDefinition.getInitializers()[0];
        if (grClassInitializer == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(153);
        }
        return grClassInitializer;
    }

    @Override
    @NotNull
    public GrParameter createParameter(@NotNull @NonNls String name, @Nullable PsiType type) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(154);
        }
        GrParameter grParameter = this.createParameter(name, type == null ? null : type.getCanonicalText(), null, null, new String[0]);
        if (grParameter == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(155);
        }
        return grParameter;
    }

    @NotNull
    public GrParameter createParameter(@NotNull @NonNls String name, @Nullable PsiType type, PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(156);
        }
        GrParameter grParameter = this.createParameter(name, type == null ? null : type.getCanonicalText(), null, context instanceof GroovyPsiElement ? (GroovyPsiElement)context : null, new String[0]);
        if (grParameter == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(157);
        }
        return grParameter;
    }

    @NotNull
    public PsiParameterList createParameterList(@NotNull @NonNls String[] names, @NotNull PsiType[] types) throws IncorrectOperationException {
        if (names == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(158);
        }
        if (types == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(159);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("def foo(");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            PsiType type = types[i];
            if (type != null) {
                builder.append(type.getCanonicalText());
                builder.append(' ');
            }
            builder.append(name);
            builder.append(',');
        }
        if (names.length > 0) {
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("){}");
        GrMethod method = this.createMethodFromText(builder);
        GrParameterList grParameterList = method.getParameterList();
        if (grParameterList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(160);
        }
        return grParameterList;
    }

    @NotNull
    public PsiClass createAnnotationType(@NotNull @NonNls String name) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(161);
        }
        GrTypeDefinition grTypeDefinition = this.createTypeDefinition("@interface " + name + "{}");
        if (grTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(162);
        }
        return grTypeDefinition;
    }

    @NotNull
    public PsiMethod createConstructor(@NotNull @NonNls String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(163);
        }
        GrMethod grMethod = this.createConstructorFromText(name, name + "(){}", null);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(164);
        }
        return grMethod;
    }

    public PsiMethod createConstructor(@NotNull @NonNls String name, PsiElement context) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(165);
        }
        return this.createConstructorFromText(name, name + "(){}", context);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor) {
        if (resolve2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(166);
        }
        if (substitutor == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(167);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(resolve2, substitutor);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(168);
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor, @NotNull LanguageLevel languageLevel) {
        if (resolve2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(169);
        }
        if (substitutor == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(170);
        }
        if (languageLevel == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(171);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(resolve2, substitutor, languageLevel);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(172);
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor, @NotNull LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations2) {
        if (resolve2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(173);
        }
        if (substitutor == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(174);
        }
        if (languageLevel == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(175);
        }
        if (annotations2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(176);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(resolve2, substitutor, languageLevel, annotations2);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(177);
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType parameters) {
        if (aClass == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(178);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass, parameters);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(179);
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType ... parameters) {
        if (aClass == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(180);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass, parameters);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(181);
        }
        return psiClassType;
    }

    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(182);
        }
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory((Project)this.myProject).createRawSubstitutor(owner);
        if (psiSubstitutor == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(183);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor createSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> map2) {
        if (map2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(184);
        }
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory((Project)this.myProject).createSubstitutor(map2);
        if (psiSubstitutor == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(185);
        }
        return psiSubstitutor;
    }

    public PsiPrimitiveType createPrimitiveType(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(186);
        }
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createPrimitiveType(text);
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull @NonNls String qName) {
        if (qName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(187);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(qName);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(188);
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull @NonNls String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(189);
        }
        if (resolveScope == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(190);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(qName, resolveScope);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(191);
        }
        return psiClassType;
    }

    public boolean isValidClassName(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(192);
        }
        return GroovyNamesUtil.isIdentifier(name);
    }

    public boolean isValidMethodName(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(193);
        }
        return true;
    }

    public boolean isValidParameterName(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(194);
        }
        return GroovyNamesUtil.isIdentifier(name);
    }

    public boolean isValidFieldName(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(195);
        }
        return GroovyNamesUtil.isIdentifier(name);
    }

    public boolean isValidLocalVariableName(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(196);
        }
        return GroovyNamesUtil.isIdentifier(name);
    }

    @NotNull
    private <T> T createElementFromText(@NotNull String text, @Nullable PsiElement context, @NotNull GroovyElementType elementType, @NotNull Class<T> elementClass) {
        GroovyDummyElement dummyElement;
        DummyHolder holder;
        PsiElement element;
        Object result2;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(197);
        }
        if (elementType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(198);
        }
        if (elementClass == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(199);
        }
        if ((result2 = ObjectUtils.tryCast((Object)(element = (holder = new DummyHolder(this.myManager, (TreeElement)(dummyElement = new GroovyDummyElement(elementType, text)), context)).getFirstChild()), elementClass)) == null) {
            throw new IncorrectOperationException("Cannot create '" + elementClass.getName() + "' from text '" + text + "'");
        }
        Object object = result2;
        if (object == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(200);
        }
        return (T)object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 85: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 125: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 145: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 162: 
            case 164: 
            case 168: 
            case 172: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 188: 
            case 191: 
            case 200: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 85: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 125: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 145: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 162: 
            case 164: 
            case 168: 
            case 172: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 188: 
            case 191: 
            case 200: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 85: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 125: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 145: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 162: 
            case 164: 
            case 168: 
            case 172: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 188: 
            case 191: 
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 74: 
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 5: 
            case 17: 
            case 25: 
            case 30: 
            case 32: 
            case 36: 
            case 41: 
            case 51: 
            case 55: 
            case 80: 
            case 86: 
            case 88: 
            case 95: 
            case 98: 
            case 100: 
            case 102: 
            case 106: 
            case 117: 
            case 119: 
            case 121: 
            case 186: 
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 39: 
            case 104: 
            case 187: 
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 15: 
            case 47: 
            case 93: 
            case 178: 
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureText";
                break;
            }
            case 37: 
            case 53: 
            case 57: 
            case 69: 
            case 83: 
            case 110: 
            case 114: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 148: 
            case 150: 
            case 154: 
            case 156: 
            case 161: 
            case 163: 
            case 165: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 43: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 45: 
            case 126: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 49: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDot";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorName";
                break;
            }
            case 63: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramNames";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationText";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoText";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
            case 111: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramTypes";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionTypes";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argListText";
                break;
            }
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 166: 
            case 169: 
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 167: 
            case 170: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 171: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceNameFromText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocMemberReferenceNameFromText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocMemberReferenceFromText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocReferenceElementFromFQN";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceElementFromText";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceExpressionFromText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceElementForClass";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionFromText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceElementByType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameterList";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameter";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableDeclaration";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnumConstantFromText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldDeclaration";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldDeclarationFromText";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopElementFromText";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createClosureFromText";
                break;
            }
            case 38: 
            case 155: 
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameter";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeOrPackageReference";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeDefinition";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeElement";
                break;
            }
            case 48: 
            case 168: 
            case 172: 
            case 177: 
            case 179: 
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createParenthesizedExpr";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringLiteralForReference";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createModifierFromText";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodBodyFromText";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleVariableDeclaration";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createDotToken";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorFromText";
                break;
            }
            case 66: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodFromText";
                break;
            }
            case 68: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationFromText";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodFromSignature";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroovyFile";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "createWhiteSpace";
                break;
            }
            case 79: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineTerminator";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionArgumentList";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedArgument";
                break;
            }
            case 87: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatementFromText";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockStatement";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodCallByAppCall";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeReferenceElementFromClass";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeReferenceElementFromText";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "createThisExpression";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockStatementFromText";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "createModifierList";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "createSwitchSection";
                break;
            }
            case 105: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStatementFromText";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStatement";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocCommentFromText";
                break;
            }
            case 120: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorInvocation";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "createThrownList";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "createCatchClause";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentList";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentListFromText";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtendsClause";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplementsClause";
                break;
            }
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralFromValue";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "createClass";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterface";
                break;
            }
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnum";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "createField";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrait";
                break;
            }
            case 149: 
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethod";
                break;
            }
            case 152: 
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructor";
                break;
            }
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassInitializer";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterList";
                break;
            }
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationType";
                break;
            }
            case 183: {
                objectArray = objectArray2;
                objectArray2[1] = "createRawSubstitutor";
                break;
            }
            case 185: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubstitutor";
                break;
            }
            case 188: 
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeByFQClassName";
                break;
            }
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceNameFromText";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 85: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 125: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 145: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 162: 
            case 164: 
            case 168: 
            case 172: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 188: 
            case 191: 
            case 200: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDocMemberReferenceNameFromText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDocMemberReferenceFromText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDocReferenceElementFromFQN";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceElementFromText";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceExpressionFromText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceElementForClass";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionFromText";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createEnumConstantFromText";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createFieldDeclaration";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createFieldDeclarationFromText";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createTopElementFromText";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createClosureFromText";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createDummyFile";
                break;
            }
            case 37: 
            case 154: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createTypeOrPackageReference";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createTypeDefinition";
                break;
            }
            case 43: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createTypeElement";
                break;
            }
            case 47: 
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 171: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 178: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createParenthesizedExpr";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createStringLiteralForReference";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createModifierFromText";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createMethodBodyFromText";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleVariableDeclaration";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createDotToken";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorFromText";
                break;
            }
            case 67: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationFromText";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createMethodFromSignature";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createGroovyFileChecked";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createGroovyFile";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createLineTerminator";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "createNamedArgument";
                break;
            }
            case 86: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "createStatementFromText";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "createMethodCallByAppCall";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "createCodeReferenceElementFromClass";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "createCodeReferenceElementFromText";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "createBlockStatementFromText";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createModifierList";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "createSwitchSection";
                break;
            }
            case 104: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "createImportStatementFromText";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "createImportStatement";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodText";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "createMethodFromText";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "createDocCommentFromText";
                break;
            }
            case 119: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorInvocation";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "createThrownList";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "createCatchClause";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentListFromText";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "createClass";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "createInterface";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "createEnum";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "createField";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "createTrait";
                break;
            }
            case 148: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "createMethod";
                break;
            }
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "createParameterList";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationType";
                break;
            }
            case 163: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "createConstructor";
                break;
            }
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "createRawSubstitutor";
                break;
            }
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "createSubstitutor";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "createPrimitiveType";
                break;
            }
            case 187: 
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByFQClassName";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "isValidClassName";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "isValidMethodName";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "isValidParameterName";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "isValidFieldName";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "isValidLocalVariableName";
                break;
            }
            case 197: 
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "createElementFromText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 85: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 125: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 145: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 162: 
            case 164: 
            case 168: 
            case 172: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 188: 
            case 191: 
            case 200: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

