/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public abstract class GrTupleType
extends GrLiteralClassType {
    private final VolatileNotNullLazyValue<PsiType[]> myParameters;
    private final VolatileNotNullLazyValue<PsiType[]> myComponents;

    public GrTupleType(@NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade) {
        if (scope == null) {
            GrTupleType.$$$reportNull$$$0(0);
        }
        if (facade == null) {
            GrTupleType.$$$reportNull$$$0(1);
        }
        this(scope, facade, LanguageLevel.JDK_1_5);
    }

    public GrTupleType(@NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull LanguageLevel level) {
        if (scope == null) {
            GrTupleType.$$$reportNull$$$0(2);
        }
        if (facade == null) {
            GrTupleType.$$$reportNull$$$0(3);
        }
        if (level == null) {
            GrTupleType.$$$reportNull$$$0(4);
        }
        super(level, scope, facade);
        this.myParameters = new VolatileNotNullLazyValue<PsiType[]>(){

            @NotNull
            protected PsiType[] compute() {
                PsiType[] types = GrTupleType.this.getComponentTypes();
                if (types.length == 0) {
                    if (PsiType.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return PsiType.EMPTY_ARRAY;
                }
                PsiType leastUpperBound = GrTupleType.this.getLeastUpperBound(types);
                if (leastUpperBound == PsiType.NULL) {
                    if (PsiClassType.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return PsiClassType.EMPTY_ARRAY;
                }
                PsiType[] psiTypeArray = new PsiType[]{leastUpperBound};
                if (psiTypeArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiTypeArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType$1", "compute"));
            }
        };
        this.myComponents = new VolatileNotNullLazyValue<PsiType[]>(){

            @NotNull
            protected PsiType[] compute() {
                PsiType[] psiTypeArray = GrTupleType.this.inferComponents();
                if (psiTypeArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return psiTypeArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType$2", "compute"));
            }
        };
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        if ("java.util.List" == null) {
            GrTupleType.$$$reportNull$$$0(5);
        }
        return "java.util.List";
    }

    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = (PsiType[])this.myParameters.getValue();
        if (psiTypeArray == null) {
            GrTupleType.$$$reportNull$$$0(6);
        }
        return psiTypeArray;
    }

    @NotNull
    public String getInternalCanonicalText() {
        PsiType[] types = this.getComponentTypes();
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < types.length; ++i) {
            if (i >= 2) {
                builder.append(",...");
                break;
            }
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(GrTupleType.getInternalCanonicalText(types[i]));
        }
        builder.append("]");
        String string = builder.toString();
        if (string == null) {
            GrTupleType.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrTupleType) {
            PsiType[] componentTypes = this.getComponentTypes();
            PsiType[] otherComponents = ((GrTupleType)((Object)obj)).getComponentTypes();
            for (int i = 0; i < Math.min(componentTypes.length, otherComponents.length); ++i) {
                if (Comparing.equal((Object)componentTypes[i], (Object)otherComponents[i])) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            GrTupleType.$$$reportNull$$$0(8);
        }
        if (type instanceof GrTupleType) {
            PsiType[] otherComponents = ((GrTupleType)type).getComponentTypes();
            PsiType[] componentTypes = this.getComponentTypes();
            for (int i = 0; i < Math.min(componentTypes.length, otherComponents.length); ++i) {
                PsiType componentType = componentTypes[i];
                PsiType otherComponent = otherComponents[i];
                if (!(otherComponent == null ? componentType != null && !TypesUtil.isClassType(componentType, "java.lang.Object") : componentType != null && !componentType.isAssignableFrom(otherComponent))) continue;
                return false;
            }
            return true;
        }
        return super.isAssignableFrom(type);
    }

    @NotNull
    public PsiType[] getComponentTypes() {
        PsiType[] psiTypeArray = (PsiType[])this.myComponents.getValue();
        if (psiTypeArray == null) {
            GrTupleType.$$$reportNull$$$0(9);
        }
        return psiTypeArray;
    }

    @NotNull
    protected abstract PsiType[] inferComponents();

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            GrTupleType.$$$reportNull$$$0(10);
        }
        GrImmediateTupleType grImmediateTupleType = new GrImmediateTupleType(this.getComponentTypes(), this.myFacade, this.getResolveScope());
        if (grImmediateTupleType == null) {
            GrTupleType.$$$reportNull$$$0(11);
        }
        return grImmediateTupleType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaClassName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFrom";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

