/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class ScriptTypeFilter
implements ContextFilter {
    private final String myScriptType;

    public ScriptTypeFilter(String scriptType) {
        this.myScriptType = scriptType;
    }

    @Override
    public boolean isApplicable(GroovyClassDescriptor descriptor2, ProcessingContext ctx) {
        PsiFile file = descriptor2.getPlaceFile();
        if (file instanceof GroovyFile && ((GroovyFile)file).isScript()) {
            return this.myScriptType.contains(ScriptTypeFilter.getScriptTypeId((GroovyFile)file));
        }
        return false;
    }

    private static String getScriptTypeId(@NotNull GroovyFile script) {
        if (script == null) {
            ScriptTypeFilter.$$$reportNull$$$0(0);
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])GroovyScriptTypeDetector.EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile(script)) continue;
            return detector.getScriptType().getId();
        }
        return "default";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/plugins/groovy/dsl/toplevel/ScriptTypeFilter", "getScriptTypeId"));
    }
}

