/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.unusedDef;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectProcedure;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionBase;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsSemilattice;

public class UnusedDefInspection
extends GroovyLocalInspectionBase {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.codeInspection.unusedDef.UnusedDefInspection");

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("unused.assignment", new Object[0]);
        if (string == null) {
            UnusedDefInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void check(@NotNull GrControlFlowOwner owner, final @NotNull ProblemsHolder problemsHolder) {
        ReachingDefinitionsSemilattice lattice;
        ReachingDefinitionsDfaInstance dfaInstance;
        Instruction[] flow;
        DFAEngine<DefinitionMap> engine;
        List<DefinitionMap> dfaResult;
        if (owner == null) {
            UnusedDefInspection.$$$reportNull$$$0(1);
        }
        if (problemsHolder == null) {
            UnusedDefInspection.$$$reportNull$$$0(2);
        }
        if ((dfaResult = (engine = new DFAEngine<DefinitionMap>(flow = owner.getControlFlow(), dfaInstance = new ReachingDefinitionsDfaInstance(flow), lattice = new ReachingDefinitionsSemilattice())).performDFAWithTimeout()) == null) {
            return;
        }
        TIntHashSet unusedDefs = new TIntHashSet();
        for (Instruction instruction : flow) {
            if (!(instruction instanceof ReadWriteVariableInstruction) || !((ReadWriteVariableInstruction)instruction).isWrite()) continue;
            unusedDefs.add(instruction.num());
        }
        for (int i = 0; i < dfaResult.size(); ++i) {
            ReadWriteVariableInstruction varInst;
            Instruction instruction = flow[i];
            if (!(instruction instanceof ReadWriteVariableInstruction) || (varInst = (ReadWriteVariableInstruction)instruction).isWrite()) continue;
            String varName = varInst.getVariableName();
            DefinitionMap e = dfaResult.get(i);
            e.forEachValue((TObjectProcedure<TIntHashSet>)((TObjectProcedure)reaching -> {
                reaching.forEach(defNum -> {
                    String defName = ((ReadWriteVariableInstruction)flow[defNum]).getVariableName();
                    if (varName.equals(defName)) {
                        unusedDefs.remove(defNum);
                    }
                    return true;
                });
                return true;
            }));
        }
        final HashSet checked = ContainerUtil.newHashSet();
        unusedDefs.forEach(num -> {
            if (problemsHolder == null) {
                UnusedDefInspection.$$$reportNull$$$0(3);
            }
            ReadWriteVariableInstruction instruction = (ReadWriteVariableInstruction)flow[num];
            PsiElement element = instruction.getElement();
            UnusedDefInspection.process(element, checked, problemsHolder, GroovyInspectionBundle.message("unused.assignment.tooltip", new Object[0]));
            return true;
        });
        owner.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitVariable(@NotNull GrVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (checked.contains(variable) || variable.getInitializerGroovy() != null) {
                    return;
                }
                if (ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope()).findFirst() == null) {
                    UnusedDefInspection.process(variable, checked, problemsHolder, GroovyInspectionBundle.message("unused.variable", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/plugins/groovy/codeInspection/unusedDef/UnusedDefInspection$1", "visitVariable"));
            }
        });
    }

    private static void process(@Nullable PsiElement element, Set<PsiElement> checked, ProblemsHolder problemsHolder, String message) {
        if (element == null) {
            return;
        }
        if (!checked.add(element)) {
            return;
        }
        if (UnusedDefInspection.isLocalAssignment(element) && UnusedDefInspection.isUsedInTopLevelFlowOnly(element) && !UnusedDefInspection.isIncOrDec(element)) {
            PsiElement toHighlight = UnusedDefInspection.getHighlightElement(element);
            problemsHolder.registerProblem(toHighlight, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
        }
    }

    private static PsiElement getHighlightElement(PsiElement element) {
        PsiElement toHighlight = null;
        if (element instanceof GrReferenceExpression) {
            PsiElement parent = element.getParent();
            if (parent instanceof GrAssignmentExpression) {
                toHighlight = ((GrAssignmentExpression)parent).getLValue();
            }
            if (parent instanceof GrUnaryExpression && ((GrUnaryExpression)parent).isPostfix()) {
                toHighlight = parent;
            }
        } else if (element instanceof GrVariable) {
            toHighlight = ((GrVariable)element).getNameIdentifierGroovy();
        }
        if (toHighlight == null) {
            toHighlight = element;
        }
        return toHighlight;
    }

    private static boolean isIncOrDec(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrUnaryExpression)) {
            return false;
        }
        IElementType type = ((GrUnaryExpression)parent).getOperationTokenType();
        return type == GroovyTokenTypes.mINC || type == GroovyTokenTypes.mDEC;
    }

    private static boolean isUsedInTopLevelFlowOnly(PsiElement element) {
        PsiElement resolved;
        GrVariable var = null;
        if (element instanceof GrVariable) {
            var = (GrVariable)element;
        } else if (element instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)element).resolve()) instanceof GrVariable) {
            var = (GrVariable)resolved;
        }
        if (var != null) {
            GrControlFlowOwner scope = ControlFlowUtils.findControlFlowOwner(var);
            if (scope == null) {
                PsiFile file = var.getContainingFile();
                if (file == null) {
                    LOG.error("no file??? var of type" + var.getClass().getCanonicalName());
                    return false;
                }
                TextRange range = var.getTextRange();
                LOG.error("var: " + var.getName() + ", offset:" + (range != null ? range.getStartOffset() : -1));
                return false;
            }
            return ReferencesSearch.search((PsiElement)var, (SearchScope)var.getUseScope()).forEach(ref -> ControlFlowUtils.findControlFlowOwner(ref.getElement()) == scope);
        }
        return true;
    }

    private static boolean isLocalAssignment(PsiElement element) {
        if (element instanceof GrVariable) {
            return UnusedDefInspection.isLocalVariable((GrVariable)element, false);
        }
        if (element instanceof GrReferenceExpression) {
            PsiElement resolved = ((GrReferenceExpression)element).resolve();
            return resolved instanceof GrVariable && UnusedDefInspection.isLocalVariable((GrVariable)resolved, true);
        }
        return false;
    }

    private static boolean isLocalVariable(GrVariable var, boolean parametersAllowed) {
        return !(var instanceof GrField) && (!(var instanceof GrParameter) || parametersAllowed);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/unusedDef/UnusedDefInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/unusedDef/UnusedDefInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$check$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

