/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;

public class GroovyInfiniteLoopStatementInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Infinite loop statement" == null) {
            GroovyInfiniteLoopStatementInspection.$$$reportNull$$$0(0);
        }
        return "Infinite loop statement";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "<code>#ref</code> statement cannot complete without throwing an exception #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyInfiniteLoopStatementInspection.$$$reportNull$$$0(1);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyInfiniteLoopStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitWhileStatement(@NotNull GrWhileStatement whileStatement) {
            if (whileStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitWhileStatement(whileStatement);
            if (ControlFlowUtils.statementMayCompleteNormally(whileStatement)) {
                return;
            }
            if (ControlFlowUtils.statementContainsReturn(whileStatement)) {
                return;
            }
            this.registerStatementError(whileStatement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyInfiniteLoopStatementInspection$Visitor", "visitWhileStatement"));
        }
    }
}

