/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.rdtext.impl;

import com.jetbrains.rider.framework.IRdDynamic;
import com.jetbrains.rider.framework.base.RdBindableBase;
import com.jetbrains.rider.framework.base.RdDelegateBase;
import com.jetbrains.rider.framework.base.RdReactiveBase;
import com.jetbrains.rider.framework.impl.RdProperty;
import com.jetbrains.rider.rdtext.ITextBuffer;
import com.jetbrains.rider.rdtext.TextBufferVersion;
import com.jetbrains.rider.rdtext.impl.RdTextBuffer;
import com.jetbrains.rider.rdtext.impl.intrinsics.RdAssertion;
import com.jetbrains.rider.rdtext.impl.intrinsics.RdChangeOrigin;
import com.jetbrains.rider.rdtext.impl.intrinsics.RdTextBufferChange;
import com.jetbrains.rider.rdtext.impl.intrinsics.RdTextBufferState;
import com.jetbrains.rider.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rider.rdtext.intrinsics.RdTextChangeKind;
import com.jetbrains.rider.rdtext.intrinsics.RdTextChangeKt;
import com.jetbrains.rider.util.LogLevel;
import com.jetbrains.rider.util.Logger;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.IOptProperty;
import com.jetbrains.rider.util.reactive.IOptPropertyView;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.IScheduler;
import com.jetbrains.rider.util.reactive.ISignal;
import com.jetbrains.rider.util.reactive.ISource;
import com.jetbrains.rider.util.reactive.OptProperty;
import com.jetbrains.rider.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rider.util.reactive.Signal;
import com.jetbrains.rider.util.reactive.SourceExKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020!0%H\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0016J \u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020(H\u0016J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\nH\u0016J\b\u00100\u001a\u00020!H\u0002J\u0010\u00101\u001a\u00020!2\u0006\u00102\u001a\u00020\u0014H\u0014J\u0010\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020(H\u0016J\u0010\u00105\u001a\u00020!2\u0006\u0010/\u001a\u00020\u0014H\u0014J\b\u00106\u001a\u00020(H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0017R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/jetbrains/rider/rdtext/impl/RdTextBuffer;", "Lcom/jetbrains/rider/framework/base/RdDelegateBase;", "Lcom/jetbrains/rider/rdtext/impl/intrinsics/RdTextBufferState;", "Lcom/jetbrains/rider/rdtext/ITextBuffer;", "delegate", "isMaster", "", "(Lcom/jetbrains/rider/rdtext/impl/intrinsics/RdTextBufferState;Z)V", "_historyChanged", "Lcom/jetbrains/rider/util/reactive/ISignal;", "Lcom/jetbrains/rider/rdtext/intrinsics/RdTextChange;", "<set-?>", "Lcom/jetbrains/rider/rdtext/TextBufferVersion;", "bufferVersion", "getBufferVersion", "()Lcom/jetbrains/rider/rdtext/TextBufferVersion;", "setBufferVersion", "(Lcom/jetbrains/rider/rdtext/TextBufferVersion;)V", "changesToConfirmOrRollback", "", "Lcom/jetbrains/rider/rdtext/impl/intrinsics/RdTextBufferChange;", "changing", "getChanging", "()Z", "historyChanged", "Lcom/jetbrains/rider/util/reactive/ISource;", "getHistoryChanged", "()Lcom/jetbrains/rider/util/reactive/ISource;", "localOrigin", "Lcom/jetbrains/rider/rdtext/impl/intrinsics/RdChangeOrigin;", "textChanged", "Lcom/jetbrains/rider/util/reactive/IOptProperty;", "advise", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "handler", "Lkotlin/Function1;", "assertState", "allText", "", "bind", "lf", "parent", "Lcom/jetbrains/rider/framework/IRdDynamic;", "name", "fire", "value", "incrementBufferVersion", "receiveChange", "textBufferChange", "reset", "text", "sendChange", "toString", "rd-text"})
public class RdTextBuffer
extends RdDelegateBase<RdTextBufferState>
implements ITextBuffer {
    private final List<RdTextBufferChange> changesToConfirmOrRollback;
    private final IOptProperty<RdTextChange> textChanged;
    private final ISignal<RdTextChange> _historyChanged;
    @NotNull
    private TextBufferVersion bufferVersion;
    private final RdChangeOrigin localOrigin;
    private final boolean isMaster;

    @Override
    @NotNull
    public ISource<RdTextChange> getHistoryChanged() {
        return (ISource)this._historyChanged;
    }

    @Override
    @NotNull
    public final TextBufferVersion getBufferVersion() {
        return this.bufferVersion;
    }

    private final void setBufferVersion(TextBufferVersion textBufferVersion) {
        this.bufferVersion = textBufferVersion;
    }

    public boolean getChanging() {
        return ((RdTextBufferState)this.getDelegatedBy()).getChanges().getChanging();
    }

    public void bind(@NotNull Lifetime lf, @NotNull IRdDynamic parent, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)lf, (String)"lf");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super.bind(lf, parent, name);
        SourceExKt.adviseNotNull((ISource)((ISource)((RdTextBufferState)this.getDelegatedBy()).getChanges()), (Lifetime)lf, (Function1)((Function1)new Function1<RdTextBufferChange, Unit>(this){
            final /* synthetic */ RdTextBuffer this$0;

            public final void invoke(@NotNull RdTextBufferChange it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (it.getOrigin() != RdTextBuffer.access$getLocalOrigin$p(this.this$0)) {
                    this.this$0.receiveChange(it);
                }
            }
            {
                this.this$0 = rdTextBuffer;
                super(1);
            }
        }));
        PropertyCombinatorsKt.compose((IOptPropertyView)((IOptPropertyView)((RdTextBufferState)this.getDelegatedBy()).getAssertedSlaveText()), (IOptPropertyView)((IOptPropertyView)((RdTextBufferState)this.getDelegatedBy()).getAssertedMasterText()), (Function2)bind.2.INSTANCE).advise(lf, (Function1)bind.3.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    protected void receiveChange(@NotNull RdTextBufferChange textBufferChange) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)textBufferChange, (String)"textBufferChange");
        TextBufferVersion newVersion = textBufferChange.getVersion();
        RdChangeOrigin remoteOrigin = textBufferChange.getOrigin();
        RdTextChange change = textBufferChange.getChange();
        boolean bl2 = bl = remoteOrigin != this.localOrigin;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (change.getKind() == RdTextChangeKind.Reset) {
            this.changesToConfirmOrRollback.clear();
        } else if (this.isMaster) {
            if (newVersion.getMaster() != this.bufferVersion.getMaster()) {
                void $receiver$iv$iv;
                Logger $receiver$iv;
                Logger logger = $receiver$iv = (Logger)RdReactiveBase.Companion.getLogReceived();
                LogLevel level$iv$iv = LogLevel.Warn;
                if ($receiver$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    void var11_14 = $receiver$iv$iv;
                    String string = "Rejecting the change '" + change + '\'';
                    var11_14.log(logLevel, (Object)string, null);
                }
                return;
            }
        } else if (newVersion.getSlave() != this.bufferVersion.getSlave()) {
            RdTextBufferChange ch;
            Iterator iterator = CollectionsKt.reversed((Iterable)this.changesToConfirmOrRollback).iterator();
            while (iterator.hasNext() && (ch = (RdTextBufferChange)iterator.next()).getVersion().getSlave() > newVersion.getSlave()) {
                RdTextChange reversedChange = RdTextChangeKt.reverse(ch.getChange());
                this._historyChanged.fire((Object)reversedChange);
                this.textChanged.set((Object)reversedChange);
            }
            this.changesToConfirmOrRollback.clear();
        } else {
            this.changesToConfirmOrRollback.clear();
        }
        this.bufferVersion = newVersion;
        this._historyChanged.fire((Object)change);
        this.textChanged.set((Object)change);
    }

    private final void incrementBufferVersion() {
        this.bufferVersion = this.isMaster ? this.bufferVersion.incrementMaster() : this.bufferVersion.incrementSlave();
    }

    public void fire(@NotNull RdTextChange value) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        boolean bl2 = bl = ((RdTextBufferState)this.getDelegatedBy()).isBound() || Intrinsics.areEqual((Object)this.bufferVersion, (Object)TextBufferVersion.Companion.getINIT_VERSION());
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (((RdTextBufferState)this.getDelegatedBy()).isBound()) {
            IScheduler.DefaultImpls.assertThread$default((IScheduler)this.getProtocol().getScheduler(), null, (int)1, null);
        }
        this.incrementBufferVersion();
        RdTextBufferChange bufferChange = new RdTextBufferChange(this.bufferVersion, this.localOrigin, value);
        if (value.getKind() == RdTextChangeKind.Reset) {
            this.changesToConfirmOrRollback.clear();
        } else if (!this.isMaster) {
            this.changesToConfirmOrRollback.add(bufferChange);
        }
        this._historyChanged.fire((Object)value);
        this.sendChange(bufferChange);
    }

    protected void sendChange(@NotNull RdTextBufferChange value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        ((RdTextBufferState)this.getDelegatedBy()).getChanges().set((Object)value);
    }

    @Override
    public void reset(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.fire(new RdTextChange(RdTextChangeKind.Reset, 0, "", text, text.length()));
    }

    public void advise(@NotNull Lifetime lifetime, @NotNull Function1<? super RdTextChange, Unit> handler) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        boolean bl = ((RdTextBufferState)this.getDelegatedBy()).isBound();
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        IScheduler.DefaultImpls.assertThread$default((IScheduler)this.getProtocol().getScheduler(), null, (int)1, null);
        this.textChanged.advise(lifetime, handler);
    }

    @Override
    public void assertState(@NotNull String allText) {
        Intrinsics.checkParameterIsNotNull((Object)allText, (String)"allText");
        RdAssertion assertion = new RdAssertion(this.bufferVersion.getMaster(), this.bufferVersion.getSlave(), allText);
        IOptProperty<RdAssertion> assertedTextProp = this.isMaster ? ((RdTextBufferState)this.getDelegatedBy()).getAssertedMasterText() : ((RdTextBufferState)this.getDelegatedBy()).getAssertedSlaveText();
        assertedTextProp.set((Object)assertion);
    }

    @NotNull
    public String toString() {
        return "Text Buffer: (" + this.getRdid() + ')';
    }

    @Override
    public final boolean isMaster() {
        return this.isMaster;
    }

    public RdTextBuffer(@NotNull RdTextBufferState delegate, boolean isMaster) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)((Object)delegate), (String)"delegate");
        super((RdBindableBase)delegate);
        this.isMaster = isMaster;
        RdTextBuffer rdTextBuffer = this;
        rdTextBuffer.changesToConfirmOrRollback = list = (List)new ArrayList();
        this.textChanged = (IOptProperty)new OptProperty();
        this._historyChanged = (ISignal)new Signal();
        this.bufferVersion = TextBufferVersion.Companion.getINIT_VERSION();
        this.localOrigin = this.isMaster ? RdChangeOrigin.Master : RdChangeOrigin.Slave;
        IProperty<RdTextBufferChange> iProperty = ((RdTextBufferState)this.getDelegatedBy()).getChanges();
        if (iProperty == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.framework.impl.RdProperty<*>");
        }
        ((RdProperty)iProperty).slave();
    }

    public /* synthetic */ RdTextBuffer(RdTextBufferState rdTextBufferState, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(rdTextBufferState, bl);
    }

    @NotNull
    public static final /* synthetic */ RdChangeOrigin access$getLocalOrigin$p(RdTextBuffer $this) {
        return $this.localOrigin;
    }
}

