/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl;

import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveDispatcherServlet;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMapping;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMappingsModel;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveDispatcherServletImpl;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveRequestMappingImpl;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveRequestMappingPredicateParser;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveRequestMappingsModelImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveRequestMappingsParser {
    private static final String CONTEXTS_KEY = "contexts";
    private static final String MAPPINGS_KEY = "mappings";
    private static final String DISPATCHER_SERVLETS_KEY = "dispatcherServlets";
    private static final String HANDLER_ATTRIBUTE = "handler";
    private static final String PREDICATE_ATTRIBUTE = "predicate";
    private static final String SERVLETS_KEY = "servlets";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String BEAN_ATTRIBUTE = "bean";
    private static final String METHOD_ATTRIBUTE = "method";

    @NotNull
    public LiveRequestMappingsModel parse(Map<?, ?> mappings) {
        if (mappings == null) {
            LiveRequestMappingsModelImpl liveRequestMappingsModelImpl = new LiveRequestMappingsModelImpl(Collections.emptyList());
            if (liveRequestMappingsModelImpl == null) {
                LiveRequestMappingsParser.$$$reportNull$$$0(0);
            }
            return liveRequestMappingsModelImpl;
        }
        Object contexts = mappings.get(CONTEXTS_KEY);
        if (contexts instanceof Map && mappings.size() == 1) {
            LiveRequestMappingsModel liveRequestMappingsModel = LiveRequestMappingsParser.parseSB20((Map)contexts);
            if (liveRequestMappingsModel == null) {
                LiveRequestMappingsParser.$$$reportNull$$$0(1);
            }
            return liveRequestMappingsModel;
        }
        ArrayList liveMappings = new ArrayList();
        mappings.forEach((key, details) -> {
            if (key instanceof String && details instanceof Map) {
                liveMappings.addAll(LiveRequestMappingsParser.parseEntry((String)key, (Map)details));
            }
        });
        LiveRequestMappingsModelImpl liveRequestMappingsModelImpl = new LiveRequestMappingsModelImpl(liveMappings);
        if (liveRequestMappingsModelImpl == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(2);
        }
        return liveRequestMappingsModelImpl;
    }

    @NotNull
    private static List<LiveRequestMapping> parseEntry(@NotNull String mappingKey, @NotNull Map<?, ?> detailsMap) {
        Object beanValue;
        if (mappingKey == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(3);
        }
        if (detailsMap == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(4);
        }
        String bean = (beanValue = detailsMap.get(BEAN_ATTRIBUTE)) == null ? null : beanValue.toString();
        Object methodValue = detailsMap.get(METHOD_ATTRIBUTE);
        String method = methodValue == null ? null : methodValue.toString();
        List<LiveRequestMapping> list = LiveRequestMappingsParser.getMappings(mappingKey, bean, method, LiveDispatcherServletImpl.DEFAULT);
        if (list == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static List<LiveRequestMapping> getMappings(@NotNull String mappingKey, @Nullable String bean, @Nullable String method, @NotNull LiveDispatcherServlet dispatcherServlet) {
        if (mappingKey == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(6);
        }
        if (dispatcherServlet == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(7);
        }
        List<String> paths = LiveRequestMappingPredicateParser.getParser(mappingKey).getPaths(mappingKey);
        List list = ContainerUtil.map(paths, path -> {
            if (mappingKey == null) {
                LiveRequestMappingsParser.$$$reportNull$$$0(14);
            }
            if (dispatcherServlet == null) {
                LiveRequestMappingsParser.$$$reportNull$$$0(15);
            }
            return new LiveRequestMappingImpl(mappingKey, (String)path, bean, method, dispatcherServlet);
        });
        if (list == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static LiveRequestMappingsModel parseSB20(@NotNull Map<?, ?> contexts) {
        if (contexts == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(9);
        }
        ArrayList liveMappings = new ArrayList();
        contexts.forEach((contextKey, contextDetails) -> {
            Object dispatcherServlets;
            if (!(contextKey instanceof String) || !(contextDetails instanceof Map)) {
                return;
            }
            Object mappingsObject = ((Map)contextDetails).get(MAPPINGS_KEY);
            if (!(mappingsObject instanceof Map)) {
                return;
            }
            Map mappings = (Map)mappingsObject;
            HashMap liveDispatcherServlets = new HashMap();
            Object servlets = mappings.get(SERVLETS_KEY);
            if (servlets instanceof List) {
                ((List)servlets).forEach(servletObject -> {
                    if (!(servletObject instanceof Map)) {
                        return;
                    }
                    Map servlet = (Map)servletObject;
                    Object name = servlet.get(NAME_ATTRIBUTE);
                    if (name == null) {
                        return;
                    }
                    Object servletMappingsObject = servlet.get(MAPPINGS_KEY);
                    if (servletMappingsObject instanceof List) {
                        List servletMappings = ((List)servletMappingsObject).stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toCollection(ContainerUtil::newSmartList));
                        liveDispatcherServlets.put(name.toString(), new LiveDispatcherServletImpl(name.toString(), servletMappings));
                    }
                });
            }
            if (!((dispatcherServlets = mappings.get(DISPATCHER_SERVLETS_KEY)) instanceof Map)) {
                return;
            }
            ((Map)dispatcherServlets).forEach((servletKey, servletDetails) -> {
                if (!(servletKey instanceof String) || !(servletDetails instanceof List)) {
                    return;
                }
                String name = (String)servletKey;
                LiveDispatcherServlet liveDispatcherServlet = (LiveDispatcherServlet)liveDispatcherServlets.get(name);
                if (liveDispatcherServlet == null) {
                    liveDispatcherServlet = new LiveDispatcherServletImpl(name, Collections.emptyList());
                    liveDispatcherServlets.put(name, liveDispatcherServlet);
                }
                LiveDispatcherServlet dispatcherServlet = liveDispatcherServlet;
                ((List)servletDetails).forEach(mapping -> {
                    if (!(mapping instanceof Map)) {
                        return;
                    }
                    liveMappings.addAll(LiveRequestMappingsParser.parseSB20Entry((Map)mapping, dispatcherServlet));
                });
            });
        });
        return new LiveRequestMappingsModelImpl(liveMappings);
    }

    @NotNull
    private static List<LiveRequestMapping> parseSB20Entry(@NotNull Map<?, ?> detailsMap, @NotNull LiveDispatcherServlet dispatcherServlet) {
        Object predicateValue;
        if (detailsMap == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(10);
        }
        if (dispatcherServlet == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(11);
        }
        if ((predicateValue = detailsMap.get(PREDICATE_ATTRIBUTE)) == null) {
            List<LiveRequestMapping> list = Collections.emptyList();
            if (list == null) {
                LiveRequestMappingsParser.$$$reportNull$$$0(12);
            }
            return list;
        }
        String mappingKey = predicateValue.toString();
        Object handlerValue = detailsMap.get(HANDLER_ATTRIBUTE);
        String handler = handlerValue != null ? handlerValue.toString() : null;
        String method = handler != null && !handler.contains("[") ? handler : null;
        List<LiveRequestMapping> list = LiveRequestMappingsParser.getMappings(mappingKey, null, method, dispatcherServlet);
        if (list == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingsParser";
                break;
            }
            case 3: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingKey";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsMap";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatcherServlet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = CONTEXTS_KEY;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingsParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEntry";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappings";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSB20Entry";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseEntry";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMappings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseSB20";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseSB20Entry";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMappings$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

