/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings.gutter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.internal.statistic.service.fus.collectors.FUSProjectUsageTrigger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMapping;
import com.intellij.spring.boot.mvc.statistics.SpringBootMvcUsageTriggerCollector;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationUrlUtil;
import com.intellij.spring.web.mvc.request.NavigatorHttpRequest;
import com.intellij.spring.web.mvc.request.RequestNavigator;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import icons.SpringApiIcons;
import icons.SpringBootApiIcons;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class LiveRequestMappingsNavigationHandler
implements GutterIconNavigationHandler<PsiElement> {
    private final List<MethodNavigationItem> myItems;

    public LiveRequestMappingsNavigationHandler(List<MethodNavigationItem> items) {
        this.myItems = items;
    }

    String getLiveMarkerInfoTooltipText() {
        if (this.myItems.size() == 1) {
            MethodNavigationItem item = this.myItems.get(0);
            if (item.mappings.size() == 1) {
                return LiveRequestMappingsNavigationHandler.getMappingUrl(item.applicationUrl, item.servletPath, item.mappings.get(0)) + " [" + item.info.getRunProfile().getName() + "]";
            }
            return item.info.getRunProfile().getName();
        }
        return "Runtime Request Mappings";
    }

    public void navigate(MouseEvent e, PsiElement element) {
        if (this.myItems.isEmpty()) {
            return;
        }
        if (this.myItems.size() == 1) {
            MethodNavigationItem item = this.myItems.get(0);
            if (item.mappings.size() == 1) {
                RequestNavigatorPopupStep navigatorsStep = LiveRequestMappingsNavigationHandler.navigateToMapping(item, item.mappings.get(0));
                if (navigatorsStep != null) {
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)navigatorsStep).show(new RelativePoint(e));
                }
            } else {
                LiveRequestMappingsNavigationHandler.showPopup(e, (ListPopup)LiveRequestMappingsNavigationHandler.createMappingsPopup(null, item), item.project);
            }
        } else {
            LiveRequestMappingsNavigationHandler.showPopup(e, LiveRequestMappingsNavigationHandler.createApplicationsPopup(this.myItems), this.myItems.get((int)0).project);
        }
    }

    private static void showPopup(MouseEvent e, ListPopup popup, Project project) {
        NavigationUtil.hidePopupIfDumbModeStarts((JBPopup)popup, (Project)project);
        popup.show(new RelativePoint(e));
    }

    @NotNull
    private static ListPopup createApplicationsPopup(List<MethodNavigationItem> items) {
        ListPopupImpl listPopupImpl = new ListPopupImpl((ListPopupStep)new ApplicationsPopupStep(items)){

            protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
                if (!(step instanceof ListPopupStep)) {
                    throw new IllegalArgumentException("Step: " + step.getClass().toString());
                }
                if (!(parentValue instanceof MethodNavigationItem)) {
                    throw new IllegalArgumentException("Parent value: " + step.getClass().toString());
                }
                return LiveRequestMappingsNavigationHandler.createMappingsPopup(parent, (MethodNavigationItem)parentValue);
            }
        };
        if (listPopupImpl == null) {
            LiveRequestMappingsNavigationHandler.$$$reportNull$$$0(0);
        }
        return listPopupImpl;
    }

    @NotNull
    private static ListPopupImpl createMappingsPopup(WizardPopup parent, final MethodNavigationItem item) {
        final MappingsPopupStep step = new MappingsPopupStep(item);
        ListPopupImpl listPopupImpl = new ListPopupImpl(parent, (ListPopupStep)step, item){

            protected ListCellRenderer getListElementRenderer() {
                return new LiveRequestMappingPopupRenderer(this, step, item.applicationUrl, item.servletPath);
            }
        };
        if (listPopupImpl == null) {
            LiveRequestMappingsNavigationHandler.$$$reportNull$$$0(1);
        }
        return listPopupImpl;
    }

    private static RequestNavigatorPopupStep navigateToMapping(MethodNavigationItem item, LiveRequestMapping mapping) {
        NavigatorHttpRequest request = LiveRequestMappingsNavigationHandler.createRequest(item.applicationUrl, item.servletPath, mapping);
        List<RequestNavigator> navigators = Arrays.stream(RequestNavigator.EP_NAME.getExtensions()).filter(navigator -> navigator.accept(request)).collect(Collectors.toList());
        if (navigators.isEmpty()) {
            return null;
        }
        if (navigators.size() == 1) {
            ((RequestNavigator)navigators.get(0)).navigate(item.project, request, item.info.getRunProfile().getName());
            LiveRequestMappingsNavigationHandler.triggerUsage(item.project, navigators.get(0), item.place);
            return null;
        }
        return new RequestNavigatorPopupStep(item, request, navigators);
    }

    public static NavigatorHttpRequest createRequest(String applicationUrl, String servletPath, LiveRequestMapping mapping) {
        String url = LiveRequestMappingsNavigationHandler.getMappingUrl(applicationUrl, servletPath, mapping);
        List<String> requestMethods = mapping.getRequestMethods();
        String requestMethod = requestMethods.isEmpty() ? "" : (requestMethods.contains("GET") ? "GET" : requestMethods.get(0));
        List headers = (List)mapping.getHeaders().stream().filter(header -> !((String)header.first).startsWith("!")).collect(Collectors.toCollection(SmartList::new));
        mapping.getProduces().stream().filter(value -> !value.startsWith("!")).findFirst().ifPresent(value -> headers.add(Pair.create((Object)"Accept", (Object)value)));
        mapping.getConsumes().stream().filter(value -> !value.startsWith("!")).findFirst().ifPresent(value -> headers.add(Pair.create((Object)"Content-Type", (Object)value)));
        List params = (List)mapping.getParams().stream().filter(param -> !((String)param.first).startsWith("!")).collect(Collectors.toCollection(SmartList::new));
        return new NavigatorHttpRequest(url, requestMethod, headers, params);
    }

    public static String getMappingUrl(String applicationUrl, String servletPath, LiveRequestMapping mapping) {
        String servletMappingPath = mapping.getDispatcherServlet().getServletMappingPath();
        if (servletMappingPath != null) {
            servletPath = servletMappingPath;
        }
        return SpringBootApplicationUrlUtil.getInstance().getMappingUrl(applicationUrl, servletPath, mapping.getPath());
    }

    private static void triggerUsage(Project project, RequestNavigator navigator, String place) {
        FUSProjectUsageTrigger.getInstance((Project)project).trigger(SpringBootMvcUsageTriggerCollector.class, navigator.getId() + ".from" + place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/gutter/LiveRequestMappingsNavigationHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createApplicationsPopup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createMappingsPopup";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class MethodNavigationItem {
        final Project project;
        final SpringBootApplicationInfo info;
        final String applicationUrl;
        final String servletPath;
        final List<LiveRequestMapping> mappings;
        final String place;

        public MethodNavigationItem(Project project, SpringBootApplicationInfo info, String applicationUrl, String servletPath, List<LiveRequestMapping> mappings, String place) {
            this.project = project;
            this.info = info;
            this.applicationUrl = applicationUrl;
            this.servletPath = servletPath;
            this.mappings = mappings;
            this.place = place;
        }
    }

    private static class LiveRequestMappingPopupRenderer
    extends PopupListElementRenderer<LiveRequestMapping> {
        private final MappingsPopupStep myPopupStep;
        private final String myApplicationUrl;
        private final String myServletPath;
        private SimpleColoredComponent myLabel;

        LiveRequestMappingPopupRenderer(ListPopupImpl popup, MappingsPopupStep popupStep, String applicationUrl, String servletPath) {
            super(popup);
            this.myPopupStep = popupStep;
            this.myApplicationUrl = applicationUrl;
            this.myServletPath = servletPath;
        }

        protected JComponent createItemComponent() {
            this.createLabel();
            this.myLabel = new SimpleColoredComponent();
            this.myLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)1));
            return this.layoutComponent((JComponent)this.myLabel);
        }

        protected void customizeComponent(JList<? extends LiveRequestMapping> list, LiveRequestMapping value, boolean isSelected) {
            super.customizeComponent(list, (Object)value, isSelected);
            this.myLabel.clear();
            boolean isSelectable = this.myPopupStep.isSelectable(value);
            this.myLabel.setEnabled(isSelectable);
            this.myLabel.setIcon(SpringApiIcons.RequestMapping);
            this.myLabel.append(LiveRequestMappingsNavigationHandler.getMappingUrl(this.myApplicationUrl, this.myServletPath, value), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            List<String> requestMethods = value.getRequestMethods();
            if (!requestMethods.isEmpty()) {
                this.myLabel.append(" [" + StringUtil.join(requestMethods, (String)"|") + "]", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }
    }

    private static class RequestNavigatorPopupStep
    extends BaseListPopupStep<RequestNavigator> {
        private final MethodNavigationItem myItem;
        private final NavigatorHttpRequest myRequest;

        RequestNavigatorPopupStep(MethodNavigationItem item, NavigatorHttpRequest request, List<RequestNavigator> navigators) {
            super(null, navigators);
            this.myItem = item;
            this.myRequest = request;
        }

        public Icon getIconFor(RequestNavigator navigator) {
            return navigator.getIcon();
        }

        @NotNull
        public String getTextFor(RequestNavigator navigator) {
            String string = navigator.getDisplayText();
            if (string == null) {
                RequestNavigatorPopupStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public PopupStep onChosen(RequestNavigator navigator, boolean finalChoice) {
            navigator.navigate(this.myItem.project, this.myRequest, this.myItem.info.getRunProfile().getName());
            LiveRequestMappingsNavigationHandler.triggerUsage(this.myItem.project, navigator, this.myItem.place);
            return FINAL_CHOICE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/mvc/lifecycle/mappings/gutter/LiveRequestMappingsNavigationHandler$RequestNavigatorPopupStep", "getTextFor"));
        }
    }

    private static class MappingsPopupStep
    extends BaseListPopupStep<LiveRequestMapping> {
        private final MethodNavigationItem myItem;

        MappingsPopupStep(MethodNavigationItem item) {
            super(item.info.getRunProfile().getName(), item.mappings);
            this.myItem = item;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean hasSubstep(LiveRequestMapping mapping) {
            NavigatorHttpRequest request = LiveRequestMappingsNavigationHandler.createRequest(this.myItem.applicationUrl, this.myItem.servletPath, mapping);
            return Arrays.stream(RequestNavigator.EP_NAME.getExtensions()).filter(navigator -> navigator.accept(request)).count() > 1L;
        }

        public boolean isSelectable(LiveRequestMapping mapping) {
            NavigatorHttpRequest request = LiveRequestMappingsNavigationHandler.createRequest(this.myItem.applicationUrl, this.myItem.servletPath, mapping);
            return Arrays.stream(RequestNavigator.EP_NAME.getExtensions()).anyMatch(navigator -> navigator.accept(request));
        }

        public PopupStep onChosen(LiveRequestMapping mapping, boolean finalChoice) {
            return LiveRequestMappingsNavigationHandler.navigateToMapping(this.myItem, mapping);
        }
    }

    private static class ApplicationsPopupStep
    extends BaseListPopupStep<MethodNavigationItem> {
        ApplicationsPopupStep(List<MethodNavigationItem> items) {
            super("Runtime Request Mappings", items);
        }

        @NotNull
        public String getTextFor(MethodNavigationItem item) {
            String string = item.info.getRunProfile().getName();
            if (string == null) {
                ApplicationsPopupStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean hasSubstep(MethodNavigationItem item) {
            return true;
        }

        public Icon getIconFor(MethodNavigationItem item) {
            return SpringBootApiIcons.SpringBoot;
        }

        public PopupStep onChosen(MethodNavigationItem item, boolean finalChoice) {
            return new MappingsPopupStep(item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/mvc/lifecycle/mappings/gutter/LiveRequestMappingsNavigationHandler$ApplicationsPopupStep", "getTextFor"));
        }
    }
}

