/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import cucumber.api.HookTestStep;
import cucumber.api.PickleStepTestStep;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvm2SMFormatter;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatterUtil;

public class CucumberJvm3SMFormatter
extends CucumberJvm2SMFormatter {
    protected String getEventUri(TestCaseStarted event) {
        return event.testCase.getUri();
    }

    protected int getEventLine(TestCaseStarted event) {
        return event.testCase.getLine();
    }

    protected String getEventName(TestCaseStarted event) {
        return event.testCase.getName();
    }

    protected String getScenarioName(TestCaseStarted testCaseStarted) {
        return CucumberJvm3SMFormatter.getScenarioName(testCaseStarted.testCase);
    }

    protected String getScenarioName(TestCaseFinished testCaseFinished) {
        return CucumberJvm3SMFormatter.getScenarioName(testCaseFinished.testCase);
    }

    protected String getStepLocation(TestStepStarted testStepStarted) {
        return CucumberJvm3SMFormatter.getStepLocation(testStepStarted.testStep);
    }

    protected String getStepLocation(TestStepFinished testStepFinished) {
        return CucumberJvm3SMFormatter.getStepLocation(testStepFinished.testStep);
    }

    protected String getStepName(TestStepStarted testStepStarted) {
        return CucumberJvm3SMFormatter.getStepName(testStepStarted.testStep);
    }

    protected String getStepName(TestStepFinished testStepFinished) {
        return CucumberJvm3SMFormatter.getStepName(testStepFinished.testStep);
    }

    private static String getScenarioName(TestCase testCase) {
        return CucumberJvmSMFormatterUtil.escape((String)("Scenario: " + testCase.getName()));
    }

    private static String getStepLocation(TestStep step) {
        if (step instanceof HookTestStep) {
            try {
                Field definitionMatchField = step.getClass().getSuperclass().getDeclaredField("stepDefinitionMatch");
                definitionMatchField.setAccessible(true);
                Object definitionMatchFieldValue = definitionMatchField.get(step);
                Field hookDefinitionField = definitionMatchFieldValue.getClass().getDeclaredField("hookDefinition");
                hookDefinitionField.setAccessible(true);
                Object hookDefinitionFieldValue = hookDefinitionField.get(definitionMatchFieldValue);
                Field methodField = hookDefinitionFieldValue.getClass().getDeclaredField("method");
                methodField.setAccessible(true);
                Object methodFieldValue = methodField.get(hookDefinitionFieldValue);
                if (methodFieldValue instanceof Method) {
                    Method method = (Method)methodFieldValue;
                    return String.format("java:test://%s/%s", method.getDeclaringClass().getName(), method.getName());
                }
            }
            catch (Exception definitionMatchField) {
                // empty catch block
            }
            return "";
        }
        PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)step;
        return "file://" + pickleStepTestStep.getStepLocation() + ":" + pickleStepTestStep.getStepLine();
    }

    private static String getStepName(TestStep step) {
        String stepName = step instanceof HookTestStep ? "Hook: " + ((HookTestStep)step).getHookType().toString() : ((PickleStepTestStep)step).getPickleStep().getText();
        return CucumberJvmSMFormatterUtil.escape((String)stepName);
    }
}

