/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;

public class JavaFxColorRgbInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JavaFxColorRgbInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JavaFxColorRgbInspection.$$$reportNull$$$0(1);
        }
        if (!JavaFxFileTypeFactory.isFxml(session.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JavaFxColorRgbInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                PsiClass psiClass;
                super.visitXmlAttribute(attribute);
                String attributeValue = attribute.getValue();
                if (attributeValue == null) {
                    return;
                }
                XmlAttributeDescriptor descriptor = attribute.getDescriptor();
                if (descriptor instanceof JavaFxPropertyAttributeDescriptor && (psiClass = ((JavaFxPropertyAttributeDescriptor)descriptor).getPsiClass()) != null && "javafx.scene.paint.Color".equals(psiClass.getQualifiedName())) {
                    XmlAttributeValue valueElement = attribute.getValueElement();
                    XmlAttributeValue location = valueElement != null ? valueElement : attribute;
                    this.validateColorComponent(psiClass, attribute.getName(), attributeValue, (PsiElement)location);
                }
            }

            public void visitXmlTag(XmlTag tag) {
                PsiClass psiClass;
                super.visitXmlTag(tag);
                if (tag.getSubTags().length != 0) {
                    return;
                }
                XmlElementDescriptor descriptor = tag.getDescriptor();
                if (descriptor instanceof JavaFxPropertyTagDescriptor && (psiClass = ((JavaFxPropertyTagDescriptor)descriptor).getPsiClass()) != null && "javafx.scene.paint.Color".equals(psiClass.getQualifiedName())) {
                    XmlTagValue valueElement = tag.getValue();
                    XmlText[] textElements = valueElement.getTextElements();
                    XmlTag location = textElements.length == 1 ? textElements[0] : tag;
                    this.validateColorComponent(psiClass, tag.getName(), valueElement.getTrimmedText(), (PsiElement)location);
                }
            }

            private void validateColorComponent(@NotNull PsiClass psiClass, @NotNull String propertyName, @NotNull String propertyValue, @NotNull PsiElement location) {
                PsiMember declaration;
                String boxedQName;
                if (psiClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (propertyName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (propertyValue == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (location == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ("java.lang.Float".equals(boxedQName = JavaFxPsiUtil.getBoxedPropertyType(psiClass, declaration = JavaFxPsiUtil.getWritableProperties(psiClass).get(propertyName))) || "java.lang.Double".equals(boxedQName)) {
                    try {
                        double value = Double.parseDouble(propertyValue);
                        if (value < 0.0 || value > 1.0) {
                            holder.registerProblem(location, "Color component has to be a number between 0.0 and 1.0, inclusively", new LocalQuickFix[0]);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "psiClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "propertyName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "propertyValue";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "location";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection$1";
                objectArray[2] = "validateColorComponent";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (xmlElementVisitor == null) {
            JavaFxColorRgbInspection.$$$reportNull$$$0(3);
        }
        return xmlElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

