/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Assume;

public class IdeaTestUtil
extends PlatformTestUtil {
    private static final String MOCK_JDK_DIR_NAME_PREFIX = "mockJDK-";

    public static void printDetectedPerformanceTimings() {
        System.out.println(Timings.getStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withLevel(Module module, LanguageLevel level, Runnable r) {
        LanguageLevelProjectExtension projectExt = LanguageLevelProjectExtension.getInstance((Project)module.getProject());
        LanguageLevel projectLevel = projectExt.getLanguageLevel();
        LanguageLevel moduleLevel = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        try {
            projectExt.setLanguageLevel(level);
            IdeaTestUtil.setModuleLanguageLevel(module, level);
            r.run();
        }
        finally {
            IdeaTestUtil.setModuleLanguageLevel(module, moduleLevel);
            projectExt.setLanguageLevel(projectLevel);
        }
    }

    public static void setModuleLanguageLevel(Module module, LanguageLevel level) {
        LanguageLevelModuleExtensionImpl modifiable = (LanguageLevelModuleExtensionImpl)LanguageLevelModuleExtensionImpl.getInstance((Module)module).getModifiableModel(true);
        modifiable.setLanguageLevel(level);
        modifiable.commit();
    }

    public static void setModuleLanguageLevel(Module module, LanguageLevel level, Disposable parentDisposable) {
        LanguageLevel prev = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        IdeaTestUtil.setModuleLanguageLevel(module, level);
        Disposer.register((Disposable)parentDisposable, () -> IdeaTestUtil.setModuleLanguageLevel(module, prev));
    }

    public static Sdk getMockJdk(JavaVersion version) {
        int mockJdk = version.feature >= 9 ? 9 : (version.feature >= 7 ? version.feature : (version.feature >= 5 ? 7 : 4));
        String path = IdeaTestUtil.getPathForJdkNamed("mockJDK-1." + mockJdk).getPath();
        return IdeaTestUtil.createMockJdk("java " + version, path);
    }

    @NotNull
    private static Sdk createMockJdk(@NotNull String name, String path) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(0);
        }
        Sdk sdk = ((JavaSdkImpl)JavaSdk.getInstance()).createMockJdk(name, path, false);
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(1);
        }
        return sdk;
    }

    public static Sdk getMockJdk14() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)4));
    }

    public static Sdk getMockJdk17() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)7));
    }

    public static Sdk getMockJdk17(@NotNull String name) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(2);
        }
        return IdeaTestUtil.createMockJdk(name, IdeaTestUtil.getMockJdk17Path().getPath());
    }

    public static Sdk getMockJdk18() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)8));
    }

    public static Sdk getMockJdk9() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)9));
    }

    public static File getMockJdk14Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.4");
    }

    public static File getMockJdk17Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.7");
    }

    public static File getMockJdk18Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.8");
    }

    public static File getMockJdk9Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.9");
    }

    public static String getMockJdkVersion(String path) {
        String name = PathUtil.getFileName((String)path);
        if (name.startsWith(MOCK_JDK_DIR_NAME_PREFIX)) {
            return "java " + StringUtil.trimStart((String)name, (String)MOCK_JDK_DIR_NAME_PREFIX);
        }
        return null;
    }

    private static File getPathForJdkNamed(String name) {
        File mockJdkCEPath = new File(PathManager.getHomePath(), "java/" + name);
        return mockJdkCEPath.exists() ? mockJdkCEPath : new File(PathManager.getHomePath(), "community/java/" + name);
    }

    public static Sdk getWebMockJdk17() {
        Sdk jdk = IdeaTestUtil.getMockJdk17();
        jdk = IdeaTestUtil.addWebJarsTo(jdk);
        return jdk;
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addWebJarsTo(@NotNull Sdk jdk) {
        if (jdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(3);
        }
        try {
            jdk = (Sdk)jdk.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/jsp-api.jar"), OrderRootType.CLASSES);
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/servlet-api.jar"), OrderRootType.CLASSES);
        sdkModificator.commitChanges();
        Sdk sdk = jdk;
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(4);
        }
        return sdk;
    }

    private static VirtualFile findJar(String name) {
        String path = PathManager.getHomePath() + '/' + name;
        VirtualFile file = VfsTestUtil.findFileByCaseSensitivePath((String)path);
        VirtualFile jar = JarFileSystem.getInstance().getJarRootForLocalFile(file);
        assert (jar != null) : "no .jar for: " + path;
        return jar;
    }

    public static void setTestVersion(@NotNull JavaSdkVersion testVersion, @NotNull Module module, @NotNull Disposable parentDisposable) {
        if (testVersion == null) {
            IdeaTestUtil.$$$reportNull$$$0(5);
        }
        if (module == null) {
            IdeaTestUtil.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            IdeaTestUtil.$$$reportNull$$$0(7);
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        Assert.assertNotNull((Object)sdk);
        String oldVersionString = sdk.getVersionString();
        ((SdkModificator)sdk).setVersionString(testVersion.getDescription());
        Assert.assertSame((Object)testVersion, (Object)JavaSdk.getInstance().getVersion(sdk));
        Disposer.register((Disposable)parentDisposable, () -> ((SdkModificator)sdk).setVersionString(oldVersionString));
    }

    @NotNull
    public static String requireRealJdkHome() {
        String javaHome = SystemProperties.getJavaHome();
        List paths = ContainerUtil.packNullables((Object[])new String[]{javaHome, new File(javaHome).getParent(), System.getenv("JDK_16_x64"), System.getenv("JDK_16")});
        for (String path : paths) {
            if (!JdkUtil.checkForJdk((String)path)) continue;
            String string = path;
            if (string == null) {
                IdeaTestUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        Assume.assumeTrue((String)("Cannot find JDK, checked paths: " + paths), (boolean)false);
        if (null == null) {
            IdeaTestUtil.$$$reportNull$$$0(9);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/IdeaTestUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testVersion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/IdeaTestUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createMockJdk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addWebJarsTo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "requireRealJdkHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createMockJdk";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMockJdk17";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addWebJarsTo";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTestVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

