/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.jam.JamAttributeElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LanguageAnnotationSupport;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationSupport;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.ref.AnnotationAttributeChildLink;
import com.intellij.util.xml.MutableGenericValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;

public class JamStringAttributeElement<T>
extends JamAttributeElement<T>
implements MutableGenericValue<T> {
    private final JamConverter<T> myConverter;

    public JamStringAttributeElement(@NotNull PsiElementRef<? extends PsiAnnotation> parent, String attributeName, JamConverter<T> converter) {
        if (parent == null) {
            JamStringAttributeElement.$$$reportNull$$$0(0);
        }
        super(attributeName, parent);
        this.myConverter = converter;
    }

    public JamStringAttributeElement(@NotNull PsiAnnotationMemberValue exactValue, JamConverter<T> converter) {
        if (exactValue == null) {
            JamStringAttributeElement.$$$reportNull$$$0(1);
        }
        super(exactValue);
        this.myConverter = converter;
    }

    @Override
    public String getStringValue() {
        PsiAnnotationMemberValue value = this.getPsiElement();
        if (value == null) {
            return null;
        }
        return JamCommonUtil.getObjectValue(value, String.class);
    }

    @Nullable
    public PsiLiteral getPsiLiteral() {
        PsiAnnotationMemberValue value = this.getPsiElement();
        return value instanceof PsiLiteral ? (PsiLiteral)value : null;
    }

    @Override
    public T getValue() {
        return this.myConverter.fromString(this.getStringValue(), this);
    }

    public JamConverter<T> getConverter() {
        return this.myConverter;
    }

    @Override
    public void setStringValue(@Nullable String value) {
        PsiAnnotationMemberValue existing = this.getPsiElement();
        if (value == null && existing == null) {
            return;
        }
        if (value != null && existing != null) {
            PsiLanguageInjectionHost injectionHost;
            ULiteralExpression literalExpression = (ULiteralExpression)UastContextKt.toUElement((PsiElement)existing, ULiteralExpression.class);
            PsiLanguageInjectionHost psiLanguageInjectionHost = injectionHost = literalExpression != null ? UastLiteralUtils.getSourceInjectionHost((UExpression)literalExpression) : null;
            if (injectionHost != null) {
                ElementManipulator manipulator = ElementManipulators.getNotNullManipulator((PsiElement)injectionHost);
                manipulator.handleContentChange((PsiElement)injectionHost, value);
                return;
            }
        }
        PsiAnnotation annotation = (PsiAnnotation)this.getParentAnnotationElement().ensurePsiElementExists();
        PsiAnnotationSupport support = (PsiAnnotationSupport)LanguageAnnotationSupport.INSTANCE.forLanguage(annotation.getLanguage());
        assert (support != null);
        PsiLiteral valueElement = value == null ? null : support.createLiteralValue(value, (PsiElement)annotation);
        AnnotationAttributeChildLink attributeLink = this.getAttributeLink();
        if (attributeLink != null) {
            annotation.setDeclaredAttributeValue(attributeLink.getAttributeName(), (PsiAnnotationMemberValue)valueElement);
        } else if (valueElement != null) {
            existing.replace((PsiElement)valueElement);
        } else {
            PsiElement parent = existing.getParent();
            (parent instanceof PsiNameValuePair ? parent : existing).delete();
        }
    }

    @Override
    public void setValue(T value) {
        String s = this.myConverter.toString(value, this);
        this.setStringValue(s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "exactValue";
                break;
            }
        }
        objectArray[1] = "com/intellij/jam/JamStringAttributeElement";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

