/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.maven;

import com.intellij.flex.maven.GeneratorServer;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.repository.WorkspaceRepository;

class WorkspaceReaderImpl
implements WorkspaceReader {
    private static final String POM_EXTENSION = "pom";
    private final WorkspaceRepository repository = new WorkspaceRepository("ide", WorkspaceReaderImpl.class);
    private final HashMap<ArtifactKey, ArtifactData> map;
    private final GeneratorServer generatorServer;

    public WorkspaceReaderImpl(DataInputStream in, GeneratorServer generatorServer) throws IOException {
        this.generatorServer = generatorServer;
        int mapSize = in.readUnsignedShort();
        this.map = new HashMap(mapSize);
        ObjectInputStream objectInputStream = new ObjectInputStream(in);
        try {
            for (int i = 0; i < mapSize; ++i) {
                ArtifactKey key = new ArtifactKey((String)objectInputStream.readObject(), (String)objectInputStream.readObject(), (String)objectInputStream.readObject());
                this.map.put(key, new ArtifactData(key, (String)objectInputStream.readObject()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    public File findArtifact(Artifact artifact) {
        ArtifactData data = this.map.get(new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        if (data == null) {
            return null;
        }
        if (data.file == null) {
            data.file = new File(data.filePath);
        }
        String ext = artifact.getExtension();
        boolean isResourceBundle = false;
        boolean isLinkReport = false;
        if (!"sources".equals(artifact.getClassifier()) && (ext.equals("swc") || ext.equals("swf") || ext.equals("air") || (isResourceBundle = ext.equals("rb.swc")) || (isLinkReport = ext.equals("xml") && "link-report".equals(artifact.getClassifier())))) {
            if (data.outputFile == null) {
                try {
                    this.generatorServer.resolveOutputs(data);
                }
                catch (Exception e) {
                    this.generatorServer.getLogger().warn("Error while resolve output file for " + artifact.toString(), (Throwable)e);
                    return null;
                }
            }
            if (artifact.getClassifier() != null) {
                if (isResourceBundle) {
                    return new File(data.localeOutputFilepathPattern.replace("{_locale_}", artifact.getClassifier()));
                }
                if (isLinkReport) {
                    return data.linkReport;
                }
            }
            return data.outputFile;
        }
        if (!(ext.equals(POM_EXTENSION) || ext.equals("jar") || ext.equals("css") || ext.isEmpty())) {
            this.generatorServer.getLogger().warn("Found artifact must be flash artifact (swc or swf), css or jar: " + artifact);
        }
        return data.file;
    }

    public List<String> findVersions(Artifact artifact) {
        ArtifactData data = this.map.get(new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        if (data == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(artifact.getVersion());
    }

    static class ArtifactData {
        public final ArtifactKey key;
        private final String filePath;
        File file;
        File outputFile;
        String localeOutputFilepathPattern;
        File linkReport;

        private ArtifactData(ArtifactKey key, String filePath) {
            this.filePath = filePath;
            this.key = key;
        }
    }

    private static class ArtifactKey {
        private final String groupId;
        private final String artifactId;
        private final String version;

        private ArtifactKey(String groupId, String artifactId, String version) {
            this.groupId = ArtifactKey.emptify(groupId);
            this.artifactId = ArtifactKey.emptify(artifactId);
            this.version = ArtifactKey.emptify(version);
        }

        private static String emptify(String str) {
            return str == null ? "" : str;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ArtifactKey) {
                ArtifactKey other = (ArtifactKey)o;
                return this.groupId.equals(other.groupId) && this.artifactId.equals(other.artifactId) && this.version.equals(other.version);
            }
            return false;
        }

        public int hashCode() {
            return 31 * (31 * this.groupId.hashCode() + this.artifactId.hashCode()) + this.version.hashCode();
        }
    }
}

