/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.maven;

import com.intellij.flex.maven.AdditionalSourceRootUtil;
import com.intellij.flex.maven.FlexConfigGenerator;
import com.intellij.flex.maven.Flexmojos;
import com.intellij.flex.maven.Maven;
import com.intellij.flex.maven.ThreadSafeMavenSession;
import com.intellij.flex.maven.WorkspaceReaderImpl;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.maven.DefaultMaven;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.ThreadConfigurationService;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.impl.LocalRepositoryProvider;
import org.sonatype.aether.impl.internal.DefaultLocalRepositoryProvider;
import org.sonatype.aether.impl.internal.DefaultRepositorySystem;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.sonatype.aether.util.DefaultRepositorySystemSession;

public class GeneratorServer {
    private final DefaultPlexusContainer plexusContainer;
    private final MavenSession session;
    private final DataInputStream in;
    private final MavenPluginManager mavenPluginManager;
    private final File generatorOutputDirectory;
    private final Logger logger;
    private final Maven maven;

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        new GeneratorServer(args);
        long duration = System.currentTimeMillis() - start;
        System.out.print("\n[fcg] generating took " + duration + " ms: " + duration / 60000L + " min " + duration % 60000L / 1000L + "sec");
    }

    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeneratorServer(String[] args) throws ComponentLookupException, IOException, MavenExecutionRequestPopulationException, SettingsBuildingException, PlexusContainerException, InterruptedException, InvalidRepositoryException {
        this.generatorOutputDirectory = new File(args[4]);
        this.generatorOutputDirectory.mkdirs();
        this.in = new DataInputStream(new BufferedInputStream(System.in));
        this.plexusContainer = GeneratorServer.createPlexusContainer();
        this.logger = this.plexusContainer.getLoggerManager().getLoggerForComponent(null);
        this.mavenPluginManager = (MavenPluginManager)this.plexusContainer.lookup(MavenPluginManager.class);
        this.session = this.createSession(this.createExecutionRequest(args));
        this.maven = new Maven((PlexusContainer)this.plexusContainer, this.session);
        final ArrayList<String> generators = new ArrayList<String>(2);
        final URL generatorJarPath = new File(this.in.readUTF()).toURI().toURL();
        generators.add(this.in.readUTF());
        int projectsCount = this.in.readUnsignedShort();
        ExecutorService executorService = ((ThreadConfigurationService)this.plexusContainer.lookup(ThreadConfigurationService.class)).getExecutorService("1", true, projectsCount);
        try {
            for (int i = 0; i < projectsCount; ++i) {
                final String pathname = this.in.readUTF();
                final String projectId = Integer.toString(i);
                executorService.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            MavenProject project = GeneratorServer.this.maven.readProject(new File(pathname), GeneratorServer.this.logger);
                            if (project == null) {
                                return;
                            }
                            String configFilePath = GeneratorServer.this.generate(project, generators, generatorJarPath);
                            PrintStream printStream = System.out;
                            synchronized (printStream) {
                                System.out.append("\n[fcg] generated: ").append(projectId).append(':').append(configFilePath);
                                for (String sourceRoot : project.getCompileSourceRoots()) {
                                    System.out.append('|').append(sourceRoot);
                                }
                                System.out.append("[/fcg]").flush();
                            }
                        }
                        catch (Throwable e) {
                            GeneratorServer.this.getLogger().error("Cannot generate flex config for " + pathname, e);
                        }
                    }
                });
            }
        }
        finally {
            executorService.shutdown();
            executorService.awaitTermination(10L, TimeUnit.MINUTES);
        }
    }

    private void populateBuildNumberPluginFields(MavenProject project, Plugin plugin) throws Exception {
        MojoExecution mojoExecution = this.maven.createMojoExecution(plugin, "create", project);
        ((BuildPluginManager)this.plexusContainer.lookup(BuildPluginManager.class)).executeMojo(this.session, mojoExecution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String generate(MavenProject project, List<String> generators, URL generatorJarPath) throws Exception {
        this.session.setCurrentProject(project);
        MojoExecution flexmojosMojoExecution = null;
        boolean flexmojosGeneratorFound = false;
        boolean buildHelperFound = false;
        boolean buildNumberFound = false;
        for (Plugin plugin : project.getBuildPlugins()) {
            String pluginGroupId = plugin.getGroupId();
            if (pluginGroupId.equals("org.sonatype.flexmojos") || pluginGroupId.equals("net.flexmojos.oss")) {
                if (flexmojosMojoExecution == null && plugin.getArtifactId().equals("flexmojos-maven-plugin")) {
                    flexmojosMojoExecution = this.maven.createMojoExecution(plugin, GeneratorServer.getCompileGoalName(project), project);
                    for (Dependency dependency : plugin.getDependencies()) {
                        if (!dependency.getArtifactId().equals("flexmojos-threadlocaltoolkit-wrapper")) continue;
                        AdditionalSourceRootUtil.addResourcesAsCompileSourceRoots(project);
                        break;
                    }
                } else if (!flexmojosGeneratorFound && plugin.getArtifactId().equals("flexmojos-generator-mojo")) {
                    AdditionalSourceRootUtil.addByGeneratorMojo(this.maven.createMojoExecution(plugin, "generate", project), this.session, project, this.getLogger());
                    flexmojosGeneratorFound = true;
                }
            } else if (!buildHelperFound && plugin.getArtifactId().equals("build-helper-maven-plugin") && pluginGroupId.equals("org.codehaus.mojo")) {
                AdditionalSourceRootUtil.addByBuildHelper(this.maven.createMojoExecution(plugin, "add-source", project), this.session, project, this.getLogger());
                buildHelperFound = true;
            } else if (!buildNumberFound && plugin.getArtifactId().equals("buildnumber-maven-plugin") && pluginGroupId.equals("org.codehaus.mojo")) {
                this.populateBuildNumberPluginFields(project, plugin);
                buildNumberFound = true;
            }
            if (flexmojosMojoExecution == null || !flexmojosGeneratorFound || !buildHelperFound || !buildNumberFound) continue;
            break;
        }
        AdditionalSourceRootUtil.addByUnknownGeneratorMojo(project);
        assert (flexmojosMojoExecution != null);
        ClassRealm flexmojosPluginRealm = this.maven.getPluginRealm(flexmojosMojoExecution);
        flexmojosPluginRealm.addURL(generatorJarPath);
        Mojo mojo = (Mojo)this.mavenPluginManager.getConfiguredMojo(Mojo.class, this.session, flexmojosMojoExecution);
        Class configuratorClass = flexmojosPluginRealm.loadClass(generators.get(0));
        FlexConfigGenerator configurator = (FlexConfigGenerator)configuratorClass.getConstructor(MavenSession.class, File.class).newInstance(this.session, this.generatorOutputDirectory);
        configurator.preGenerate(project, Flexmojos.getClassifier(mojo));
        if ("swc".equals(project.getPackaging())) {
            configurator.generate(mojo);
        } else {
            configurator.generate(mojo, Flexmojos.getSourceFileForSwf(mojo));
        }
        String string = configurator.postGenerate(project);
        this.plexusContainer.release((Object)mojo);
        this.session.setCurrentProject(null);
        if (flexmojosMojoExecution != null) {
            this.maven.releaseMojoExecution(flexmojosMojoExecution);
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    this.plexusContainer.release((Object)mojo);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    this.session.setCurrentProject(null);
                    if (flexmojosMojoExecution != null) {
                        this.maven.releaseMojoExecution(flexmojosMojoExecution);
                    }
                    throw throwable2;
                }
            }
        }
    }

    private static String getCompileGoalName(MavenProject project) {
        return "swc".equals(project.getPackaging()) ? "compile-swc" : "compile-swf";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveOutputs(WorkspaceReaderImpl.ArtifactData data) throws Exception {
        MojoExecution flexmojosMojoExecution;
        MavenProject oldProject;
        block12: {
            MavenProject project = this.maven.readProject(data.file, this.logger);
            if (project == null) {
                this.getLogger().warn("Cannot read project while resolve output file for " + data.toString());
                return;
            }
            oldProject = this.session.getCurrentProject();
            flexmojosMojoExecution = null;
            try {
                this.session.setCurrentProject(project);
                for (Plugin plugin : project.getBuildPlugins()) {
                    String pluginGroupId = plugin.getGroupId();
                    if (!pluginGroupId.equals("org.sonatype.flexmojos") && !pluginGroupId.equals("net.flexmojos.oss") || !plugin.getArtifactId().equals("flexmojos-maven-plugin")) continue;
                    flexmojosMojoExecution = this.maven.createMojoExecution(plugin, GeneratorServer.getCompileGoalName(project), project);
                    break;
                }
                if (flexmojosMojoExecution != null) break block12;
            }
            catch (Throwable throwable) {
                this.session.setCurrentProject(oldProject);
                if (flexmojosMojoExecution != null) {
                    this.maven.releaseMojoExecution(flexmojosMojoExecution);
                }
                throw throwable;
            }
            this.session.setCurrentProject(oldProject);
            if (flexmojosMojoExecution != null) {
                this.maven.releaseMojoExecution(flexmojosMojoExecution);
            }
            return;
        }
        this.maven.getPluginRealm(flexmojosMojoExecution);
        Mojo mojo = (Mojo)this.mavenPluginManager.getConfiguredMojo(Mojo.class, this.session, flexmojosMojoExecution);
        try {
            data.outputFile = new File(Flexmojos.getOutput(mojo));
            String[] localesRuntime = (String[])Flexmojos.invokePublicMethod(mojo, "getLocalesRuntime");
            data.linkReport = Flexmojos.getLinkReport(mojo);
            if (localesRuntime != null && localesRuntime.length > 0) {
                Class<?> superclass = mojo.getClass().getSuperclass();
                Mojo localeMojo = (Mojo)Flexmojos.invokePublicMethod(mojo, "clone");
                Method m = superclass.getDeclaredMethod("configureResourceBundle", String.class, superclass);
                m.setAccessible(true);
                String firstLocale = localesRuntime[0];
                m.invoke((Object)mojo, firstLocale, localeMojo);
                ((Map)Flexmojos.invokePublicMethod(localeMojo, "getCache")).put("getProjectType", "rb.swc");
                data.localeOutputFilepathPattern = Flexmojos.getOutput(localeMojo).replace(firstLocale, "{_locale_}");
            }
        }
        finally {
            this.plexusContainer.release((Object)mojo);
        }
        this.session.setCurrentProject(oldProject);
        if (flexmojosMojoExecution != null) {
            this.maven.releaseMojoExecution(flexmojosMojoExecution);
        }
    }

    private MavenSession createSession(MavenExecutionRequest request) throws ComponentLookupException {
        ThreadSafeMavenSession session = new ThreadSafeMavenSession((PlexusContainer)this.plexusContainer, this.createRepositorySession(request), request, (MavenExecutionResult)new DefaultMavenExecutionResult());
        ((LegacySupport)this.plexusContainer.lookup(LegacySupport.class)).setSession((MavenSession)session);
        return session;
    }

    private RepositorySystemSession createRepositorySession(MavenExecutionRequest request) throws ComponentLookupException {
        DefaultRepositorySystemSession session = (DefaultRepositorySystemSession)((DefaultMaven)this.plexusContainer.lookup(org.apache.maven.Maven.class)).newRepositorySession(request);
        if (!request.isUpdateSnapshots()) {
            session.setUpdatePolicy("never");
        }
        return session;
    }

    private MavenExecutionRequest createExecutionRequest(String[] args) throws ComponentLookupException, SettingsBuildingException, MavenExecutionRequestPopulationException, IOException, InvalidRepositoryException {
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request.setGlobalSettingsFile(new File(args[0]));
        if (!args[1].equals(" ")) {
            request.setUserSettingsFile(new File(args[1]));
        }
        request.setLocalRepository(((org.apache.maven.repository.RepositorySystem)this.plexusContainer.lookup(org.apache.maven.repository.RepositorySystem.class)).createLocalRepository(new File(args[2])));
        Properties systemProperties = new Properties();
        EnvironmentUtils.addEnvVars((Properties)systemProperties);
        systemProperties.putAll((Map<?, ?>)System.getProperties());
        request.setSystemProperties(systemProperties);
        request.setOffline(args[3].equals("t")).setUpdateSnapshots(false).setCacheNotFound(true).setCacheTransferError(true);
        ((MavenExecutionRequestPopulator)this.plexusContainer.lookup(MavenExecutionRequestPopulator.class)).populateFromSettings((MavenExecutionRequest)request, this.createSettings((MavenExecutionRequest)request));
        List activeProfiles = request.getActiveProfiles();
        int profilesLength = this.in.readShort();
        if (profilesLength > 0) {
            while (profilesLength-- > 0) {
                activeProfiles.add(this.in.readUTF());
            }
        }
        request.setWorkspaceReader((WorkspaceReader)new WorkspaceReaderImpl(this.in, this));
        return request;
    }

    private Settings createSettings(MavenExecutionRequest mavenExecutionRequest) throws ComponentLookupException, SettingsBuildingException {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setSystemProperties(request.getSystemProperties());
        request.setGlobalSettingsFile(mavenExecutionRequest.getGlobalSettingsFile());
        request.setUserSettingsFile(mavenExecutionRequest.getUserSettingsFile());
        Settings settings = ((SettingsBuilder)this.plexusContainer.lookup(SettingsBuilder.class)).build((SettingsBuildingRequest)request).getEffectiveSettings();
        settings.setLocalRepository(mavenExecutionRequest.getLocalRepositoryPath().getPath());
        return settings;
    }

    private static DefaultPlexusContainer createPlexusContainer() throws PlexusContainerException, ComponentLookupException {
        DefaultPlexusContainer container = new DefaultPlexusContainer(new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader())).setName("maven").setAutoWiring(true));
        List<Object> factoryList = Collections.singletonList(container.lookup(LocalRepositoryManagerFactory.class, "simple"));
        String mavenVersion = ((RuntimeInformation)container.lookup(RuntimeInformation.class)).getMavenVersion();
        if (mavenVersion.length() >= 5 && mavenVersion.charAt(2) == '0' && mavenVersion.charAt(4) < '4') {
            DefaultRepositorySystem repositorySystem = (DefaultRepositorySystem)container.lookup(RepositorySystem.class);
            try {
                repositorySystem.getClass().getMethod("setLocalRepositoryManagerFactories", List.class).invoke((Object)repositorySystem, factoryList);
            }
            catch (Exception e) {
                container.getLoggerManager().getLoggerForComponent(null).warn("", (Throwable)e);
            }
        } else {
            ((DefaultLocalRepositoryProvider)container.lookup(LocalRepositoryProvider.class)).setLocalRepositoryManagerFactories(factoryList);
        }
        return container;
    }
}

