/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class RpcNetworkConnectionsModel
implements NetworkConnectionsModel {
    @NotNull
    private final ProfilerServiceGrpc.ProfilerServiceBlockingStub myProfilerService;
    @NotNull
    private final NetworkServiceGrpc.NetworkServiceBlockingStub myNetworkService;
    @NotNull
    private final Common.Session mySession;

    public RpcNetworkConnectionsModel(@NotNull ProfilerServiceGrpc.ProfilerServiceBlockingStub profilerService, @NotNull NetworkServiceGrpc.NetworkServiceBlockingStub networkService, @NotNull Common.Session session) {
        if (profilerService == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(0);
        }
        if (networkService == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(1);
        }
        if (session == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(2);
        }
        this.myProfilerService = profilerService;
        this.myNetworkService = networkService;
        this.mySession = session;
    }

    @Override
    @NotNull
    public List<HttpData> getData(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(3);
        }
        NetworkProfiler.HttpRangeRequest request = NetworkProfiler.HttpRangeRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax())).build();
        NetworkProfiler.HttpRangeResponse response = this.myNetworkService.getHttpRange(request);
        ArrayList<HttpData> httpDataList = new ArrayList<HttpData>(response.getDataList().size());
        for (NetworkProfiler.HttpConnectionData connection : response.getDataList()) {
            long startTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getStartTimestamp());
            long uploadedTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getUploadedTimestamp());
            long downloadingTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getDownloadingTimestamp());
            long endTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getEndTimestamp());
            HttpData.Builder httpBuilder = new HttpData.Builder(connection.getConnId(), startTimeUs, uploadedTimeUs, downloadingTimeUs, endTimeUs, this.requestAccessingThreads(connection.getConnId()));
            this.requestHttpRequest(connection.getConnId(), httpBuilder);
            if (connection.getUploadedTimestamp() != 0L) {
                this.requestHttpRequestBody(connection.getConnId(), httpBuilder);
            }
            if (connection.getEndTimestamp() != 0L) {
                this.requestHttpResponse(connection.getConnId(), httpBuilder);
                this.requestHttpResponseBody(connection.getConnId(), httpBuilder);
            }
            httpDataList.add(httpBuilder.build());
        }
        ArrayList<HttpData> arrayList = httpDataList;
        if (arrayList == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private void requestHttpRequest(long connectionId, @NotNull HttpData.Builder builder) {
        void httpBuilder;
        if (builder == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(5);
        }
        NetworkProfiler.HttpDetailsResponse.Request result = this.getDetails(connectionId, NetworkProfiler.HttpDetailsRequest.Type.REQUEST).getRequest();
        httpBuilder.setUrl(result.getUrl());
        httpBuilder.setMethod(result.getMethod());
        httpBuilder.setTraceId(result.getTraceId());
        httpBuilder.setRequestFields(result.getFields());
    }

    /*
     * WARNING - void declaration
     */
    private void requestHttpRequestBody(long connectionId, @NotNull HttpData.Builder builder) {
        void httpBuilder;
        if (builder == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(6);
        }
        NetworkProfiler.HttpDetailsResponse result = this.getDetails(connectionId, NetworkProfiler.HttpDetailsRequest.Type.REQUEST_BODY);
        httpBuilder.setRequestPayloadId(result.getRequestBody().getPayloadId());
    }

    /*
     * WARNING - void declaration
     */
    private void requestHttpResponseBody(long connectionId, @NotNull HttpData.Builder builder) {
        void httpBuilder;
        if (builder == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(7);
        }
        NetworkProfiler.HttpDetailsResponse response = this.getDetails(connectionId, NetworkProfiler.HttpDetailsRequest.Type.RESPONSE_BODY);
        String payloadId = response.getResponseBody().getPayloadId();
        httpBuilder.setResponsePayloadId(payloadId);
        httpBuilder.setResponsePayloadSize(response.getResponseBody().getPayloadSize());
    }

    @Override
    @NotNull
    public ByteString requestBytes(@NotNull String id) {
        if (id == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)id)) {
            ByteString byteString = ByteString.EMPTY;
            if (byteString == null) {
                RpcNetworkConnectionsModel.$$$reportNull$$$0(9);
            }
            return byteString;
        }
        Profiler.BytesRequest request = Profiler.BytesRequest.newBuilder().setId(id).setSession(this.mySession).build();
        Profiler.BytesResponse response = this.myProfilerService.getBytes(request);
        ByteString byteString = response.getContents();
        if (byteString == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(10);
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    private void requestHttpResponse(long connectionId, @NotNull HttpData.Builder builder) {
        void httpBuilder;
        if (builder == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(11);
        }
        NetworkProfiler.HttpDetailsResponse response = this.getDetails(connectionId, NetworkProfiler.HttpDetailsRequest.Type.RESPONSE);
        httpBuilder.setResponseFields(response.getResponse().getFields());
    }

    private List<HttpData.JavaThread> requestAccessingThreads(long connectionId) {
        NetworkProfiler.HttpDetailsResponse response = this.getDetails(connectionId, NetworkProfiler.HttpDetailsRequest.Type.ACCESSING_THREADS);
        return response.getAccessingThreads().getThreadList().stream().map(proto -> new HttpData.JavaThread(proto.getId(), proto.getName())).collect(Collectors.toList());
    }

    private NetworkProfiler.HttpDetailsResponse getDetails(long connectionId, NetworkProfiler.HttpDetailsRequest.Type type) {
        return this.myNetworkService.getHttpDetails(NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(connectionId).setSession(this.mySession).setType(type).build());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "networkService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/RpcNetworkConnectionsModel";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/RpcNetworkConnectionsModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "requestBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requestHttpRequest";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "requestHttpRequestBody";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "requestHttpResponseBody";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "requestBytes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "requestHttpResponse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

