/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.SimpleEventType;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerMonitorTooltipView;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.event.EventSimpleEventTooltip;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventSimpleEventTooltipView
extends ProfilerMonitorTooltipView<EventMonitor> {
    private static final int HOVER_OVER_WIDTH_PX = 16;
    @VisibleForTesting
    protected JLabel myStartTimeLabel;
    @VisibleForTesting
    protected JLabel myDurationLabel;
    protected JComponent myComponent;

    public EventSimpleEventTooltipView(StageView parent, @NotNull EventSimpleEventTooltip tooltip) {
        if (tooltip == null) {
            EventSimpleEventTooltipView.$$$reportNull$$$0(0);
        }
        super(tooltip.getMonitor());
        this.myComponent = parent.getComponent();
        ((EventMonitor)((Object)this.getMonitor())).getProfilers().getTimeline().getDataRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::timeChanged);
    }

    @Override
    public void dispose() {
        super.dispose();
        ((EventMonitor)((Object)this.getMonitor())).getProfilers().getTimeline().getDataRange().removeDependencies((AspectObserver)this);
    }

    @Override
    protected void timeChanged() {
        ProfilerTimeline timeline = ((EventMonitor)((Object)this.getMonitor())).getProfilers().getTimeline();
        Range dataRange = timeline.getDataRange();
        Range range = timeline.getTooltipRange();
        if (!range.isEmpty()) {
            this.showSimpleEventInfo(timeline, dataRange, range);
        } else {
            this.myHeadingLabel.setText("");
        }
        this.updateMaximumLabelDimensions();
    }

    private void clearTooltipInfo() {
        super.timeChanged();
        this.myStartTimeLabel.setText("");
        this.myDurationLabel.setText("");
    }

    private void showSimpleEventInfo(ProfilerTimeline timeline, Range dataRange, Range range) {
        EventAction event = this.getEventAt(range.getMin());
        if (event != null) {
            double endTime = event.getEndUs() == 0L ? dataRange.getMax() : (double)event.getEndUs();
            this.setTimelineText(timeline.getDataRange(), event.getStartUs(), endTime);
            String label = "";
            if (event.getType() == SimpleEventType.KEYBOARD) {
                label = "Key Event - Press";
            } else if (event.getType() == SimpleEventType.TOUCH) {
                label = "Touch Event - Press";
            } else if (event.getType() == SimpleEventType.ROTATION) {
                label = "Rotation Event";
            }
            this.myHeadingLabel.setText(label);
        } else {
            this.clearTooltipInfo();
        }
    }

    private void setTimelineText(Range dataRange, double startTime, double endTime) {
        String startTimeString = TimeAxisFormatter.DEFAULT.getFormattedString(dataRange.getLength(), startTime - dataRange.getMin(), true);
        String durationString = TimeAxisFormatter.DEFAULT.getFormattedString(dataRange.getLength(), endTime - startTime, true);
        this.myStartTimeLabel.setText(String.format("Start: %s", startTimeString));
        this.myDurationLabel.setText(String.format("Duration: %s", durationString));
    }

    @Nullable
    private EventAction getEventAt(double time) {
        double timePerPixel = ((EventMonitor)((Object)this.getMonitor())).getProfilers().getTimeline().getViewRange().getLength() / (double)this.myComponent.getWidth();
        long hoverWidthAsTime = (long)timePerPixel * 16L;
        List activitySeries = ((EventMonitor)((Object)this.getMonitor())).getSimpleEvents().getRangedSeries().getSeries();
        for (SeriesData series : activitySeries) {
            if (!(((EventAction)series.value).getEndUs() - ((EventAction)series.value).getStartUs() <= hoverWidthAsTime / 2L || ((EventAction)series.value).getType() == SimpleEventType.KEYBOARD ? (double)(((EventAction)series.value).getStartUs() - hoverWidthAsTime / 2L) <= time && (double)(((EventAction)series.value).getStartUs() + hoverWidthAsTime / 2L) >= time : (double)((EventAction)series.value).getStartUs() <= time && ((double)((EventAction)series.value).getEndUs() > time || ((EventAction)series.value).getEndUs() == 0L))) continue;
            return (EventAction)series.value;
        }
        return null;
    }

    @Override
    @NotNull
    public JComponent createTooltip() {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("*"));
        panel.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        this.myStartTimeLabel = new JLabel();
        this.myStartTimeLabel.setForeground(Color.GRAY);
        this.myStartTimeLabel.setFont(this.myFont);
        this.myDurationLabel = new JLabel();
        this.myDurationLabel.setForeground(Color.GRAY);
        this.myDurationLabel.setFont(this.myFont);
        panel.add((Component)this.myDurationLabel, new TabularLayout.Constraint(0, 0));
        panel.add((Component)this.myStartTimeLabel, new TabularLayout.Constraint(1, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            EventSimpleEventTooltipView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/event/EventSimpleEventTooltipView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/event/EventSimpleEventTooltipView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

