/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.FpsTimer;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StopwatchTimer;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.energy.EnergyProfiler;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.event.EventProfiler;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.network.NetworkProfiler;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.grpc.StatusRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioProfilers
extends AspectModel<ProfilerAspect>
implements Updatable {
    public static final int INVALID_PROCESS_ID = -1;
    public static final int PROFILERS_UPDATE_RATE = 60;
    private final ProfilerClient myClient;
    private final ProfilerTimeline myTimeline;
    private final List<StudioProfiler> myProfilers;
    @NotNull
    private final IdeProfilerServices myIdeServices;
    private Map<Common.Device, List<Common.Process>> myProcesses;
    @Nullable
    private Common.Process myProcess;
    private Profiler.AgentStatusResponse.Status myAgentStatus;
    @Nullable
    private String myPreferredProcessName;
    private Common.Device myDevice;
    @NotNull
    private Common.Session mySessionData;
    @NotNull
    private Stage myStage;
    private Updater myUpdater;
    private AxisComponentModel myViewAxis;
    private long myRefreshDevices;
    private boolean myConnected;

    public StudioProfilers(ProfilerClient client, @NotNull IdeProfilerServices ideServices) {
        if (ideServices == null) {
            StudioProfilers.$$$reportNull$$$0(0);
        }
        this(client, ideServices, (StopwatchTimer)new FpsTimer(60));
    }

    @VisibleForTesting
    public StudioProfilers(ProfilerClient client, @NotNull IdeProfilerServices ideServices, @NotNull StopwatchTimer timer) {
        if (ideServices == null) {
            StudioProfilers.$$$reportNull$$$0(1);
        }
        if (timer == null) {
            StudioProfilers.$$$reportNull$$$0(2);
        }
        this.myClient = client;
        this.myIdeServices = ideServices;
        this.myPreferredProcessName = null;
        this.myStage = new NullMonitorStage(this);
        this.myStage.enter();
        this.myUpdater = new Updater(timer);
        ImmutableList.Builder profilersBuilder = new ImmutableList.Builder();
        profilersBuilder.add((Object)new EventProfiler(this));
        profilersBuilder.add((Object)new CpuProfiler(this));
        profilersBuilder.add((Object)new MemoryProfiler(this));
        profilersBuilder.add((Object)new NetworkProfiler(this));
        if (this.myIdeServices.getFeatureConfig().isEnergyProfilerEnabled()) {
            profilersBuilder.add((Object)new EnergyProfiler(this));
        }
        this.myProfilers = profilersBuilder.build();
        this.myTimeline = new ProfilerTimeline();
        this.myTimeline.getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> {
            if (!this.myTimeline.getSelectionRange().isEmpty()) {
                this.myTimeline.setStreaming(false);
            }
        });
        this.myProcesses = Maps.newHashMap();
        this.myConnected = false;
        this.myDevice = null;
        this.myProcess = null;
        this.mySessionData = Common.Session.getDefaultInstance();
        this.myViewAxis = new AxisComponentModel(this.myTimeline.getViewRange(), (BaseAxisFormatter)TimeAxisFormatter.DEFAULT);
        this.myViewAxis.setGlobalRange(this.myTimeline.getDataRange());
        this.myUpdater.register((Updatable)this.myTimeline);
        this.myUpdater.register((Updatable)this.myViewAxis);
        this.myUpdater.register((Updatable)this);
    }

    public boolean isStopped() {
        return !this.myUpdater.isRunning();
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.myUpdater.stop();
        this.setDevice(null);
        this.changed(ProfilerAspect.STAGE);
    }

    public List<Common.Device> getDevices() {
        return Lists.newArrayList(this.myProcesses.keySet());
    }

    public void setPreferredProcessName(@Nullable String name) {
        this.myPreferredProcessName = name;
        this.setProcess(null);
    }

    public void update(long elapsedNs) {
        this.myRefreshDevices += elapsedNs;
        if (this.myRefreshDevices < TimeUnit.SECONDS.toNanos(1L)) {
            return;
        }
        this.myRefreshDevices = 0L;
        try {
            Profiler.AgentStatusResponse.Status agentStatus;
            Profiler.GetDevicesResponse response = this.myClient.getProfilerClient().getDevices(Profiler.GetDevicesRequest.getDefaultInstance());
            if (!this.myConnected) {
                this.changed(ProfilerAspect.CONNECTION);
            }
            this.myConnected = true;
            HashSet devices = new HashSet(response.getDeviceList());
            HashMap<Common.Device, List<Common.Process>> newProcesses = new HashMap<Common.Device, List<Common.Process>>();
            for (Common.Device device : devices) {
                Profiler.GetProcessesRequest request = Profiler.GetProcessesRequest.newBuilder().setDeviceId(device.getDeviceId()).build();
                Profiler.GetProcessesResponse processes = this.myClient.getProfilerClient().getProcesses(request);
                int lastProcessId = this.myProcess == null ? 0 : this.myProcess.getPid();
                List processList = processes.getProcessList().stream().filter(process -> process.getState() == Common.Process.State.ALIVE || process.getPid() == lastProcessId).collect(Collectors.toList());
                newProcesses.put(device, processList);
            }
            if (!newProcesses.equals(this.myProcesses)) {
                this.myProcesses = newProcesses;
                this.setDevice(this.findPreferredDevice());
                this.setProcess(null);
                this.changed(ProfilerAspect.DEVICES);
                this.changed(ProfilerAspect.PROCESSES);
            }
            if (this.myProcess != null && this.myAgentStatus != (agentStatus = this.getAgentStatus())) {
                this.myAgentStatus = agentStatus;
                this.changed(ProfilerAspect.AGENT);
                if (this.isProcessAlive() && this.myAgentStatus == Profiler.AgentStatusResponse.Status.ATTACHED) {
                    this.getIdeServices().getFeatureTracker().trackAdvancedProfilingStarted();
                }
            }
        }
        catch (StatusRuntimeException e) {
            this.myConnected = false;
            this.changed(ProfilerAspect.CONNECTION);
            System.err.println("Cannot find profiler service, retrying...");
        }
    }

    @Nullable
    private Common.Device findPreferredDevice() {
        if (this.myDevice != null && this.myDevice.getState().equals((Object)Common.Device.State.ONLINE) && this.deviceHasAliveProcesses(this.myDevice)) {
            return this.myDevice;
        }
        Set<Common.Device> devices = this.myProcesses.keySet();
        Set onlineDevices = devices.stream().filter(device -> device.getState().equals((Object)Common.Device.State.ONLINE)).collect(Collectors.toSet());
        if (!onlineDevices.isEmpty()) {
            Common.Device anyOnlineDevice = (Common.Device)onlineDevices.iterator().next();
            return onlineDevices.stream().filter(this::deviceHasAliveProcesses).findAny().orElse(anyOnlineDevice);
        }
        Common.Device anyDevice = devices.isEmpty() ? null : devices.iterator().next();
        return this.myDevice == null ? anyDevice : devices.stream().filter(device -> device.getSerial().equals(this.myDevice.getSerial())).findAny().orElse(anyDevice);
    }

    private boolean deviceHasAliveProcesses(@NotNull Common.Device device) {
        List<Common.Process> deviceProcesses;
        if (device == null) {
            StudioProfilers.$$$reportNull$$$0(3);
        }
        if ((deviceProcesses = this.myProcesses.get(device)) == null) {
            return false;
        }
        for (Common.Process process : deviceProcesses) {
            if (!process.getState().equals((Object)Common.Process.State.ALIVE)) continue;
            return true;
        }
        return false;
    }

    public void setDevice(Common.Device device) {
        if (!Objects.equals(device, this.myDevice)) {
            if (this.myDevice != null && this.myProcess != null && this.myDevice.getDeviceId() == this.myProcess.getDeviceId() && this.myDevice.getState() == Common.Device.State.ONLINE && this.myProcess.getState() == Common.Process.State.ALIVE) {
                this.endSession();
            }
            this.mySessionData = Common.Session.getDefaultInstance();
            this.myDevice = device;
            this.changed(ProfilerAspect.DEVICES);
            this.setProcess(null);
        }
    }

    public void setMonitoringStage() {
        this.setStage(new StudioMonitorStage(this));
    }

    public void setProcess(@Nullable Common.Process process) {
        block9: {
            block11: {
                block10: {
                    List<Common.Process> processes = this.myProcesses.get(this.myDevice);
                    if (process == null || processes == null || !processes.contains(process)) {
                        process = this.getPreferredProcess(processes);
                    } else {
                        this.myPreferredProcessName = null;
                    }
                    if (Objects.equals(process, this.myProcess)) break block9;
                    if (this.myDevice != null && this.myProcess != null && this.myDevice.getState() == Common.Device.State.ONLINE && this.myDevice.getDeviceId() == this.myProcess.getDeviceId() && this.myProcess.getState() == Common.Process.State.ALIVE) {
                        this.endSession();
                    }
                    this.myProcess = process;
                    this.changed(ProfilerAspect.PROCESSES);
                    this.myAgentStatus = this.getAgentStatus();
                    if (this.myDevice == null || this.myProcess == null || this.myDevice.getState() != Common.Device.State.ONLINE || this.myProcess.getState() != Common.Process.State.ALIVE) break block10;
                    this.beginSession();
                    Profiler.TimeResponse response = this.myClient.getProfilerClient().getCurrentTime(Profiler.TimeRequest.newBuilder().setDeviceId(this.myDevice.getDeviceId()).build());
                    long sessionRunTime = response.getTimestampNs() - this.mySessionData.getStartTimestamp();
                    this.myTimeline.reset(this.mySessionData.getStartTimestamp(), sessionRunTime);
                    if (this.myDevice.getFeatureLevel() >= 26 && this.myIdeServices.getFeatureConfig().isJvmtiAgentEnabled()) {
                        this.myClient.getProfilerClient().attachAgent(Profiler.AgentAttachRequest.newBuilder().setSession(this.getSession()).setProcessId(this.myProcess.getPid()).setAgentLibFileName(String.format("libperfa_%s.so", this.myProcess.getAbiCpuArch())).build());
                    }
                    this.myIdeServices.getFeatureTracker().trackProfilingStarted();
                    if (this.myAgentStatus != Profiler.AgentStatusResponse.Status.ATTACHED) break block11;
                    this.getIdeServices().getFeatureTracker().trackAdvancedProfilingStarted();
                    break block11;
                }
                this.myTimeline.setIsPaused(true);
                if (this.myDevice != null && this.myProcess != null) {
                    Profiler.GetSessionsResponse sessionsResponse = this.myClient.getProfilerClient().getSessions(Profiler.GetSessionsRequest.getDefaultInstance());
                    for (int i = sessionsResponse.getSessionsCount() - 1; i >= 0; --i) {
                        Common.Session session = sessionsResponse.getSessions(i);
                        if (session.getDeviceId() != this.myDevice.getDeviceId() || session.getPid() != this.myProcess.getPid()) continue;
                        this.mySessionData = session;
                        break;
                    }
                }
            }
            if (this.myProcess == null) {
                this.setStage(new NullMonitorStage(this));
            } else if (this.myProcess.getState() == Common.Process.State.ALIVE) {
                this.setStage(new StudioMonitorStage(this));
            }
            this.changed(ProfilerAspect.AGENT);
        }
    }

    private void beginSession() {
        assert (this.myDevice != null && this.myProcess != null);
        Profiler.BeginSessionResponse response = this.myClient.getProfilerClient().beginSession(Profiler.BeginSessionRequest.newBuilder().setDeviceId(this.myDevice.getDeviceId()).setProcessId(this.myProcess.getPid()).build());
        this.mySessionData = response.getSession();
        this.myProfilers.forEach(profiler -> profiler.startProfiling(this.mySessionData, this.myProcess));
    }

    private void endSession() {
        Profiler.EndSessionResponse response = this.myClient.getProfilerClient().endSession(Profiler.EndSessionRequest.newBuilder().setDeviceId(this.myDevice.getDeviceId()).setSessionId(this.mySessionData.getSessionId()).build());
        this.myProfilers.forEach(profiler -> profiler.stopProfiling(response.getSession(), this.myProcess));
        this.mySessionData = Common.Session.getDefaultInstance();
    }

    @Nullable
    private Common.Process getPreferredProcess(List<Common.Process> processes) {
        if (processes == null || processes.isEmpty()) {
            return null;
        }
        if (this.myPreferredProcessName != null) {
            for (Common.Process process : processes) {
                if (!process.getName().equals(this.myPreferredProcessName) || process.getState() != Common.Process.State.ALIVE) continue;
                return process;
            }
        }
        if (this.myProcess != null) {
            for (Common.Process process : processes) {
                if (!StudioProfilers.isSameProcess(this.myProcess, process)) continue;
                return process;
            }
        }
        return processes.get(0);
    }

    @NotNull
    private Profiler.AgentStatusResponse.Status getAgentStatus() {
        if (this.myDevice == null || this.myProcess == null) {
            Profiler.AgentStatusResponse.Status status = Profiler.AgentStatusResponse.getDefaultInstance().getStatus();
            if (status == null) {
                StudioProfilers.$$$reportNull$$$0(4);
            }
            return status;
        }
        Profiler.AgentStatusRequest statusRequest = Profiler.AgentStatusRequest.newBuilder().setProcessId(this.myProcess.getPid()).setDeviceId(this.myDevice.getDeviceId()).build();
        Profiler.AgentStatusResponse.Status status = this.myClient.getProfilerClient().getAgentStatus(statusRequest).getStatus();
        if (status == null) {
            StudioProfilers.$$$reportNull$$$0(5);
        }
        return status;
    }

    private static boolean isSameProcess(@Nullable Common.Process process1, @Nullable Common.Process process2) {
        return process1 != null && process2 != null && process1.getPid() == process2.getPid() && process1.getName().equals(process2.getName());
    }

    public List<Common.Process> getProcesses() {
        List<Common.Process> processes = this.myProcesses.get(this.myDevice);
        return processes == null ? ImmutableList.of() : processes;
    }

    @NotNull
    public Stage getStage() {
        Stage stage = this.myStage;
        if (stage == null) {
            StudioProfilers.$$$reportNull$$$0(6);
        }
        return stage;
    }

    public ProfilerClient getClient() {
        return this.myClient;
    }

    public int getProcessId() {
        return this.myProcess != null ? this.myProcess.getPid() : -1;
    }

    @NotNull
    public Common.Session getSession() {
        Common.Session session = this.mySessionData;
        if (session == null) {
            StudioProfilers.$$$reportNull$$$0(7);
        }
        return session;
    }

    public void setStage(@NotNull Stage stage) {
        if (stage == null) {
            StudioProfilers.$$$reportNull$$$0(8);
        }
        this.myStage.exit();
        this.getTimeline().getSelectionRange().clear();
        this.myStage = stage;
        this.myStage.enter();
        this.changed(ProfilerAspect.STAGE);
    }

    @NotNull
    public ProfilerTimeline getTimeline() {
        ProfilerTimeline profilerTimeline = this.myTimeline;
        if (profilerTimeline == null) {
            StudioProfilers.$$$reportNull$$$0(9);
        }
        return profilerTimeline;
    }

    public Common.Device getDevice() {
        return this.myDevice;
    }

    public Common.Process getProcess() {
        return this.myProcess;
    }

    public boolean isProcessAlive() {
        return this.myProcess != null && this.myProcess.getState() == Common.Process.State.ALIVE;
    }

    public boolean isLiveAllocationEnabled() {
        return this.getIdeServices().getFeatureConfig().isLiveAllocationsEnabled() && this.getDevice() != null && this.getDevice().getFeatureLevel() >= 26 && this.isAgentAttached();
    }

    public boolean isAgentAttached() {
        return this.myAgentStatus == Profiler.AgentStatusResponse.Status.ATTACHED;
    }

    public List<StudioProfiler> getProfilers() {
        return this.myProfilers;
    }

    public ProfilerMode getMode() {
        return this.myStage.getProfilerMode();
    }

    public void modeChanged() {
        this.changed(ProfilerAspect.MODE);
    }

    @NotNull
    public IdeProfilerServices getIdeServices() {
        IdeProfilerServices ideProfilerServices = this.myIdeServices;
        if (ideProfilerServices == null) {
            StudioProfilers.$$$reportNull$$$0(10);
        }
        return ideProfilerServices;
    }

    public Updater getUpdater() {
        return this.myUpdater;
    }

    public AxisComponentModel getViewAxis() {
        return this.myViewAxis;
    }

    public List<Class<? extends Stage>> getDirectStages() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add(CpuProfilerStage.class);
        listBuilder.add(MemoryProfilerStage.class);
        listBuilder.add(NetworkProfilerStage.class);
        if (this.getIdeServices().getFeatureConfig().isEnergyProfilerEnabled()) {
            listBuilder.add(EnergyProfilerStage.class);
        }
        return listBuilder.build();
    }

    @NotNull
    public Class<? extends Stage> getStageClass() {
        Class<?> clazz = ((Object)((Object)this.myStage)).getClass();
        if (clazz == null) {
            StudioProfilers.$$$reportNull$$$0(11);
        }
        return clazz;
    }

    public void setNewStage(Class<? extends Stage> clazz) {
        try {
            Constructor<? extends Stage> constructor = clazz.getConstructor(StudioProfilers.class);
            Stage stage = constructor.newInstance(new Object[]{this});
            this.setStage(stage);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideServices";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/StudioProfilers";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/StudioProfilers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentStatus";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeline";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeServices";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStageClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deviceHasAliveProcesses";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setStage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

