/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.update;

import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationDescriptor;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdateContext;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdatePolicy;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class UpdateResourcesPolicy
extends SpringBootApplicationUpdatePolicy {
    private static final String ID = "UpdateResources";
    private static final String NAME = "Update resources";
    private static final String DESCRIPTION = "<nobr>Compiles all modified and dependent resource files.</nobr>";

    public UpdateResourcesPolicy() {
        super(ID, NAME, DESCRIPTION);
    }

    public void runUpdate(@NotNull SpringBootApplicationUpdateContext context) {
        if (context == null) {
            UpdateResourcesPolicy.$$$reportNull$$$0(0);
        }
        Set<Module> modules = context.getDescriptors().stream().map(SpringBootApplicationDescriptor::getModule).collect(Collectors.toSet());
        ModuleCompileScope compileScope = new ModuleCompileScope(context.getProject(), modules.toArray(Module.EMPTY_ARRAY), true);
        CompileScopeUtil.setResourcesScopeForExternalBuild((CompileScope)compileScope, modules.stream().map(Module::getName).collect(Collectors.toList()));
        HotSwapUI.getInstance((Project)context.getProject()).dontPerformHotswapAfterThisCompilation();
        if (context.isOnFrameDeactivation()) {
            CompileDriver.setCompilationStartedAutomatically((CompileScope)compileScope);
        }
        CompilerManager.getInstance((Project)context.getProject()).make((CompileScope)compileScope, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/run/update/UpdateResourcesPolicy", "runUpdate"));
    }
}

