/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.health.tab;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class HealthTreeStructure
extends SimpleTreeStructure {
    static final String STATUS_UP = "UP";
    static final String STATUS_DOWN = "DOWN";
    static final String STATUS_OUT_OF_SERVICE = "OUT_OF_SERVICE";
    static final String STATUS_UNKNOWN = "UNKNOWN";
    static final String APPLICATION_NODE_NAME = "application";
    static final String STATUS_KEY = "status";
    static final String DETAILS_KEY = "details";
    @NotNull
    private final SimpleNode myRootNode;
    private StatusNode myApplicationStatusNode;

    HealthTreeStructure(Project project) {
        this.myRootNode = new SimpleNode(project){

            @NotNull
            public SimpleNode[] getChildren() {
                if (HealthTreeStructure.this.myApplicationStatusNode == null) {
                    if (NO_CHILDREN == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return NO_CHILDREN;
                }
                SimpleNode[] simpleNodeArray = new SimpleNode[]{HealthTreeStructure.this.myApplicationStatusNode};
                if (simpleNodeArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return simpleNodeArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/health/tab/HealthTreeStructure$1", "getChildren"));
            }
        };
    }

    @NotNull
    public Object getRootElement() {
        SimpleNode simpleNode = this.myRootNode;
        if (simpleNode == null) {
            HealthTreeStructure.$$$reportNull$$$0(0);
        }
        return simpleNode;
    }

    public boolean isToBuildChildrenInBackground(@NotNull Object element) {
        if (element == null) {
            HealthTreeStructure.$$$reportNull$$$0(1);
        }
        return true;
    }

    void setHealth(Map health) {
        if (health == null) {
            this.myApplicationStatusNode = null;
            return;
        }
        if (health.size() == 2) {
            Map details;
            Object applicationHealthIndicator = health.get(APPLICATION_NODE_NAME);
            if (applicationHealthIndicator instanceof Map) {
                this.myApplicationStatusNode = this.getDisabledIndicatorsApplicationStatusNode((Map)applicationHealthIndicator);
                return;
            }
            Object healthDetails = health.get(DETAILS_KEY);
            if (healthDetails instanceof Map && (details = (Map)healthDetails).size() == 1 && (applicationHealthIndicator = details.get(APPLICATION_NODE_NAME)) instanceof Map) {
                this.myApplicationStatusNode = this.getDisabledIndicatorsApplicationStatusNode((Map)applicationHealthIndicator);
                return;
            }
        }
        this.myApplicationStatusNode = new StatusNode(this.myRootNode.getProject(), this.myRootNode, APPLICATION_NODE_NAME, health);
    }

    private StatusNode getDisabledIndicatorsApplicationStatusNode(Map<?, ?> applicationHealthIndicator) {
        return new StatusNode(this.myRootNode.getProject(), this.myRootNode, APPLICATION_NODE_NAME, applicationHealthIndicator, SpringBootRunBundle.message("spring.boot.application.endpoints.health.indicators.disabled", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/health/tab/HealthTreeStructure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/health/tab/HealthTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isToBuildChildrenInBackground";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DetailsNode
    extends SimpleNode {
        DetailsNode(Project project, SimpleNode parent, String key, Object value) {
            super(project, (NodeDescriptor)parent);
            this.myName = key;
            PresentationData presentationData = this.getTemplatePresentation();
            presentationData.addText(key + ": ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            String valueString = value.toString();
            if (value instanceof Number) {
                try {
                    valueString = NumberFormat.getInstance().format(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            presentationData.addText(valueString, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        @NotNull
        public SimpleNode[] getChildren() {
            if (NO_CHILDREN == null) {
                DetailsNode.$$$reportNull$$$0(0);
            }
            return NO_CHILDREN;
        }

        public boolean isAlwaysLeaf() {
            return true;
        }

        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.myName, this.getParent()};
            if (objectArray == null) {
                DetailsNode.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/spring/boot/run/lifecycle/health/tab/HealthTreeStructure$DetailsNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEqualityObjects";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class StatusNode
    extends SimpleNode {
        private final Map<Object, Object> myDetails;
        private SimpleNode[] myChildren;

        StatusNode(Project project, SimpleNode parent, String name, Map<?, ?> details) {
            this(project, parent, name, details, null);
        }

        StatusNode(Project project, SimpleNode parent, String name, Map<?, ?> details, String tailText) {
            super(project, (NodeDescriptor)parent);
            this.myName = name;
            this.myDetails = new HashMap<Object, Object>();
            details.forEach((key, value) -> {
                if (HealthTreeStructure.DETAILS_KEY.equals(key) && value instanceof Map) {
                    this.myDetails.putAll((Map)value);
                } else {
                    this.myDetails.put(key, value);
                }
            });
            PresentationData presentationData = this.getTemplatePresentation();
            presentationData.addText(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            Object status = details.get(HealthTreeStructure.STATUS_KEY);
            if (status instanceof String) {
                presentationData.setTooltip(SpringBootRunBundle.message("spring.boot.application.endpoints.health.status", status));
                if (HealthTreeStructure.STATUS_UP.equals(status)) {
                    this.setIcon(AllIcons.RunConfigurations.TestPassed);
                } else if (HealthTreeStructure.STATUS_DOWN.equals(status)) {
                    this.setIcon(AllIcons.RunConfigurations.TestFailed);
                } else if (HealthTreeStructure.STATUS_OUT_OF_SERVICE.equals(status)) {
                    this.setIcon(AllIcons.RunConfigurations.TestError);
                } else if (HealthTreeStructure.STATUS_UNKNOWN.equals(status)) {
                    this.setIcon(AllIcons.RunConfigurations.TestUnknown);
                } else {
                    presentationData.addText(" [" + status + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.setIcon(AllIcons.RunConfigurations.TestCustom);
                }
            }
            if (tailText != null) {
                presentationData.addText(" [" + tailText + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        @NotNull
        public SimpleNode[] getChildren() {
            if (this.myChildren != null) {
                if (this.myChildren == null) {
                    StatusNode.$$$reportNull$$$0(0);
                }
                return this.myChildren;
            }
            ArrayList children = new ArrayList();
            this.myDetails.forEach((key, value) -> {
                if (key == null || value == null || HealthTreeStructure.STATUS_KEY.equals(key)) {
                    return;
                }
                if (value instanceof Map && !((Map)value).isEmpty()) {
                    children.add(new StatusNode(this.getProject(), this, key.toString(), (Map)value));
                } else {
                    children.add(new DetailsNode(this.getProject(), this, key.toString(), value));
                }
            });
            Collections.sort(children, (o1, o2) -> {
                if (o1 instanceof StatusNode) {
                    if (o2 instanceof DetailsNode) {
                        return 1;
                    }
                    return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
                }
                if (o2 instanceof StatusNode) {
                    return -1;
                }
                return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
            });
            this.myChildren = children.toArray(NO_CHILDREN);
            if (this.myChildren == null) {
                StatusNode.$$$reportNull$$$0(1);
            }
            return this.myChildren;
        }

        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.myName, this.getParent()};
            if (objectArray == null) {
                StatusNode.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        public boolean isAutoExpandNode() {
            SimpleNode parent = this.getParent();
            if (!(parent instanceof StatusNode)) {
                return true;
            }
            if (!(parent.getParent() instanceof StatusNode)) {
                return parent.getChildCount() == 1;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/spring/boot/run/lifecycle/health/tab/HealthTreeStructure$StatusNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEqualityObjects";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

