/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.gutter;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.spring.boot.run.lifecycle.beans.gutter.LiveBeansNavigationHandler;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.util.XmlTagUtil;
import icons.SpringBootRunIcons;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveBeansDomLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public String getId() {
        return "LiveBeansDomLineMarkerProvider";
    }

    public String getName() {
        return "Runtime Beans (XML)";
    }

    public Icon getIcon() {
        return SpringBootRunIcons.Gutter.LiveBean;
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            LiveBeansDomLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        PsiElement psiElement;
        if (elements == null) {
            LiveBeansDomLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            LiveBeansDomLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        PsiFile file = elements.get(0).getContainingFile();
        if (!LiveBeansDomLineMarkerProvider.isSpringXml(file)) {
            return;
        }
        if (!LiveBeansNavigationHandler.hasLiveBeansModels(psiElement.getProject())) {
            return;
        }
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            LiveBeansDomLineMarkerProvider.annotate(elements.get(i), result);
        }
    }

    private static void annotate(@NotNull PsiElement psiElement, @NotNull Collection<LineMarkerInfo> result) {
        if (psiElement == null) {
            LiveBeansDomLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            LiveBeansDomLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (!(psiElement instanceof XmlToken)) {
            return;
        }
        PsiElement parent = psiElement.getParent();
        if (!(parent instanceof XmlTag)) {
            return;
        }
        XmlTag tag = (XmlTag)parent;
        if (XmlTagUtil.getStartTagNameElement((XmlTag)tag) != psiElement) {
            return;
        }
        DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement(tag);
        if (!(element instanceof SpringBean)) {
            return;
        }
        String beanName = ((SpringBean)element).getBeanName();
        if (beanName == null) {
            return;
        }
        Predicate<LiveBean> beanMatcher = liveBean -> {
            if (psiElement == null) {
                LiveBeansDomLineMarkerProvider.$$$reportNull$$$0(5);
            }
            LiveResource liveResource = liveBean.getResource();
            PsiFile containingResource = psiElement.getContainingFile();
            assert (containingResource instanceof XmlFile);
            return liveResource != null && liveResource.matchesXmlConfig((XmlFile)containingResource);
        };
        LiveBeansNavigationHandler.addLiveBeansGutterIcon(beanName, beanMatcher, psiElement.getProject(), psiElement, result);
    }

    private static boolean isSpringXml(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlFile xmlFile = (XmlFile)file;
        return SpringDomUtils.isSpringXml((XmlFile)xmlFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansDomLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$annotate$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

