/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.spring.boot.run.lifecycle.AsyncApplicationLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootModuleDescriptor;
import org.jetbrains.annotations.Nullable;

class ServerConfigurationLiveProperty
extends AsyncApplicationLiveProperty<SpringBootApplicationServerConfiguration> {
    ServerConfigurationLiveProperty(LiveProperty<SpringBootModuleDescriptor> moduleDescriptor, LiveProperty<String> serviceUrl, LifecycleErrorHandler errorHandler, Disposable parent) {
        super(moduleDescriptor, serviceUrl, errorHandler, parent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SpringBootApplicationServerConfiguration doCompute() {
        try (SpringBootApplicationConnector connector = this.getApplicationConnector();){
            boolean sslEnabled = false;
            Object keyStore = connector.getProperty("server.ssl.key-store");
            if (keyStore != null) {
                sslEnabled = connector.getBooleanProperty("server.ssl.enabled", true);
            }
            Object contextPath = connector.getProperty(SpringBootApplicationConnector.SERVER_CONTEXT_PATH_PROPERTY);
            Object servletPath = connector.getProperty(SpringBootApplicationConnector.SERVER_SERVLET_PATH_PROPERTY);
            Object address = connector.getProperty("server.address");
            MyApplicationServerConfiguration myApplicationServerConfiguration = new MyApplicationServerConfiguration(sslEnabled, contextPath == null ? null : contextPath.toString(), servletPath == null ? null : servletPath.toString(), address == null ? null : address.toString());
            return myApplicationServerConfiguration;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static class MyApplicationServerConfiguration
    implements SpringBootApplicationServerConfiguration {
        private final boolean mySslEnabled;
        private final String myContextPath;
        private final String myServletPath;
        private final String myAddress;

        MyApplicationServerConfiguration(boolean sslEnabled, String contextPath, String servletPath, String address) {
            this.mySslEnabled = sslEnabled;
            this.myContextPath = contextPath;
            this.myServletPath = servletPath;
            this.myAddress = address;
        }

        public boolean isSslEnabled() {
            return this.mySslEnabled;
        }

        @Nullable
        public String getContextPath() {
            return this.myContextPath;
        }

        @Nullable
        public String getServletPath() {
            return this.myServletPath;
        }

        @Nullable
        public String getAddress() {
            return this.myAddress;
        }
    }
}

