/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.tree.events.impl;

import com.intellij.lang.ASTNode;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TreeChangeImpl
implements TreeChange,
Comparable<TreeChangeImpl> {
    private final CompositeElement myParent;
    private final List<CompositeElement> mySuperParents;
    private final LinkedHashSet<TreeElement> myInitialChildren;
    private final Map<TreeElement, Integer> myInitialLengths;
    private final Set<TreeElement> myContentChangeChildren;
    private Map<TreeElement, ChangeInfoImpl> myChanges;

    public TreeChangeImpl(@NotNull CompositeElement parent) {
        if (parent == null) {
            TreeChangeImpl.$$$reportNull$$$0(0);
        }
        this.myInitialChildren = new LinkedHashSet();
        this.myInitialLengths = new HashMap<TreeElement, Integer>();
        this.myContentChangeChildren = new HashSet<TreeElement>();
        this.myParent = parent;
        assert (this.myParent.getPsi() != null) : this.myParent.getElementType() + " of " + this.myParent.getClass();
        this.mySuperParents = JBIterable.generate((Object)parent.getTreeParent(), TreeElement::getTreeParent).toList();
        for (TreeElement child2 : this.getCurrentChildren()) {
            this.myInitialChildren.add(child2);
            this.myInitialLengths.put(child2, child2.getTextLength());
        }
    }

    List<CompositeElement> getSuperParents() {
        return this.mySuperParents;
    }

    @NotNull
    private JBIterable<TreeElement> getCurrentChildren() {
        JBIterable jBIterable = JBIterable.generate((Object)this.myParent.getFirstChildNode(), TreeElement::getTreeNext);
        if (jBIterable == null) {
            TreeChangeImpl.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @Override
    public int compareTo(@NotNull TreeChangeImpl o) {
        if (o == null) {
            TreeChangeImpl.$$$reportNull$$$0(2);
        }
        List thisParents = ContainerUtil.reverse(this.getSuperParents());
        List thatParents = ContainerUtil.reverse(o.getSuperParents());
        for (int i = 1; i <= thisParents.size() && i <= thatParents.size(); ++i) {
            CompositeElement thatParent;
            CompositeElement thisParent = i < thisParents.size() ? (CompositeElement)thisParents.get(i) : this.myParent;
            int result2 = TreeChangeImpl.compareNodePositions(thisParent, thatParent = i < thatParents.size() ? (CompositeElement)thatParents.get(i) : o.myParent);
            if (result2 == 0) continue;
            return result2;
        }
        return 0;
    }

    private static int compareNodePositions(CompositeElement node1, CompositeElement node2) {
        int o2;
        if (node1 == node2) {
            return 0;
        }
        int o1 = node1.getStartOffsetInParent();
        return o1 != (o2 = node2.getStartOffsetInParent()) ? Integer.compare(o1, o2) : Integer.compare(TreeChangeImpl.getChildIndex(node1), TreeChangeImpl.getChildIndex(node2));
    }

    private static int getChildIndex(CompositeElement e) {
        return ArrayUtil.indexOf((Object[])e.getTreeParent().getChildren(null), (Object)e);
    }

    int getLengthDelta() {
        return this.getAllChanges().values().stream().mapToInt(ChangeInfoImpl::getLengthDelta).sum();
    }

    void clearCache() {
        this.myChanges = null;
    }

    private Map<TreeElement, ChangeInfoImpl> getAllChanges() {
        if (this.myChanges == null) {
            this.myChanges = new ChildrenDiff().calcChanges();
        }
        return this.myChanges;
    }

    @NotNull
    public CompositeElement getChangedParent() {
        CompositeElement compositeElement = this.myParent;
        if (compositeElement == null) {
            TreeChangeImpl.$$$reportNull$$$0(3);
        }
        return compositeElement;
    }

    void fireEvents(PsiFile file2) {
        int start2 = this.myParent.getStartOffset();
        Collection<ChangeInfoImpl> changes2 = this.getAllChanges().values();
        if (ContainerUtil.exists(changes2, c -> c.hasNoPsi())) {
            ChangeInfoImpl.childrenChanged(ChangeInfoImpl.createEvent(file2, start2), this.myParent, this.myParent.getTextLength() - this.getLengthDelta());
            return;
        }
        for (ChangeInfoImpl change : changes2) {
            change.fireEvent(start2, file2, this.myParent);
        }
    }

    @NotNull
    public TreeElement[] getAffectedChildren() {
        TreeElement[] treeElementArray = this.getAllChanges().keySet().toArray(TreeElement.EMPTY_ARRAY);
        if (treeElementArray == null) {
            TreeChangeImpl.$$$reportNull$$$0(4);
        }
        return treeElementArray;
    }

    @Override
    public ChangeInfo getChangeByChild(ASTNode child2) {
        return this.getAllChanges().get((TreeElement)child2);
    }

    public String toString() {
        return this.myParent + ": " + this.getAllChanges().values();
    }

    void appendChanges(@NotNull TreeChangeImpl next) {
        if (next == null) {
            TreeChangeImpl.$$$reportNull$$$0(5);
        }
        this.myContentChangeChildren.addAll(next.myContentChangeChildren);
        this.clearCache();
    }

    public void markChildChanged(@NotNull TreeElement child2, int lengthDelta) {
        if (child2 == null) {
            TreeChangeImpl.$$$reportNull$$$0(6);
        }
        this.myContentChangeChildren.add(child2);
        Integer oldLength = this.myInitialLengths.get(child2);
        if (oldLength != null && lengthDelta != 0) {
            this.myInitialLengths.put(child2, oldLength - lengthDelta);
        }
        this.clearCache();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/pom/tree/events/impl/TreeChangeImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/pom/tree/events/impl/TreeChangeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendChanges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markChildChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ChildrenDiff {
        LinkedHashSet<TreeElement> currentChildren;
        Iterator<TreeElement> itOld;
        Iterator<TreeElement> itNew;
        TreeElement oldChild;
        TreeElement newChild;
        int oldOffset;
        LinkedHashMap<TreeElement, ChangeInfoImpl> result;

        private ChildrenDiff() {
            this.currentChildren = (LinkedHashSet)TreeChangeImpl.this.getCurrentChildren().addAllTo(new LinkedHashSet());
            this.itOld = TreeChangeImpl.this.myInitialChildren.iterator();
            this.itNew = this.currentChildren.iterator();
            this.oldOffset = 0;
            this.result = new LinkedHashMap();
        }

        void advanceOld() {
            this.oldOffset += this.oldChild == null ? 0 : (Integer)TreeChangeImpl.this.myInitialLengths.get(this.oldChild);
            this.oldChild = this.itOld.hasNext() ? this.itOld.next() : null;
        }

        void advanceNew() {
            this.newChild = this.itNew.hasNext() ? this.itNew.next() : null;
        }

        Map<TreeElement, ChangeInfoImpl> calcChanges() {
            this.advanceOld();
            this.advanceNew();
            while (this.oldChild != null || this.newChild != null) {
                if (this.oldChild == this.newChild) {
                    if (TreeChangeImpl.this.myContentChangeChildren.contains(this.oldChild)) {
                        this.addChange(new ChangeInfoImpl(this.oldChild, this.oldChild, this.oldOffset, (Integer)TreeChangeImpl.this.myInitialLengths.get(this.oldChild)));
                    }
                    this.advanceOld();
                    this.advanceNew();
                    continue;
                }
                boolean oldDisappeared = this.oldChild != null && !this.currentChildren.contains(this.oldChild);
                boolean newAppeared = this.newChild != null && !TreeChangeImpl.this.myInitialChildren.contains(this.newChild);
                this.addChange(new ChangeInfoImpl(oldDisappeared ? this.oldChild : null, newAppeared ? this.newChild : null, this.oldOffset, oldDisappeared ? (Integer)TreeChangeImpl.this.myInitialLengths.get(this.oldChild) : 0));
                if (oldDisappeared) {
                    this.advanceOld();
                }
                if (!newAppeared) continue;
                this.advanceNew();
            }
            return this.result;
        }

        private void addChange(ChangeInfoImpl change) {
            this.result.put(change.getAffectedChild(), change);
            this.oldOffset += change.getLengthDelta();
        }
    }
}

