/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.GroupedLogMessage;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class MessagePool {
    private static final int MAX_POOL_SIZE = 100;
    private static final int MAX_GROUP_SIZE = 20;
    private static final int GROUP_TIME_SPAN_MS = 1000;
    private final List<AbstractMessage> myErrors = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<MessagePoolListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final MessageGrouper myGrouper = new MessageGrouper();

    public static MessagePool getInstance() {
        return MessagePoolHolder.ourInstance;
    }

    private MessagePool() {
    }

    public void addIdeFatalMessage(@NotNull IdeaLoggingEvent event) {
        if (event == null) {
            MessagePool.$$$reportNull$$$0(0);
        }
        if (this.myErrors.size() < 100) {
            Object data = event.getData();
            if (data instanceof GroupedLogMessage) {
                this.myGrouper.addToGroup(new LogMessage(new Throwable(), "illegal reuse of a grouped message", Collections.emptyList()));
            } else if (data instanceof AbstractMessage) {
                this.myGrouper.addToGroup((AbstractMessage)data);
            } else {
                this.myGrouper.addToGroup(new LogMessage(event.getThrowable(), event.getMessage(), Collections.emptyList()));
            }
        } else if (this.myErrors.size() == 100) {
            TooManyErrorsException e = new TooManyErrorsException();
            this.myGrouper.addToGroup(new LogMessage(e, null, Collections.emptyList()));
        }
    }

    public State getState() {
        if (this.myErrors.isEmpty()) {
            return State.NoErrors;
        }
        for (AbstractMessage message : this.myErrors) {
            if (message.isRead()) continue;
            return State.UnreadErrors;
        }
        return State.ReadErrors;
    }

    public List<AbstractMessage> getFatalErrors(boolean includeReadMessages, boolean includeSubmittedMessages) {
        ArrayList<AbstractMessage> result2 = new ArrayList<AbstractMessage>();
        for (AbstractMessage message : this.myErrors) {
            if (!(!message.isRead() && !message.isSubmitted() || message.isRead() && includeReadMessages) && (!message.isSubmitted() || !includeSubmittedMessages)) continue;
            result2.add(message);
        }
        return result2;
    }

    public void clearErrors() {
        for (AbstractMessage message : this.myErrors) {
            message.setRead(true);
        }
        this.myErrors.clear();
        this.notifyPoolCleared();
    }

    public void addListener(MessagePoolListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(MessagePoolListener listener2) {
        this.myListeners.remove(listener2);
    }

    private void notifyEntryAdded() {
        this.myListeners.forEach(MessagePoolListener::newEntryAdded);
    }

    private void notifyPoolCleared() {
        this.myListeners.forEach(MessagePoolListener::poolCleared);
    }

    private void notifyEntryRead() {
        this.myListeners.forEach(MessagePoolListener::entryWasRead);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/MessagePool", "addIdeFatalMessage"));
    }

    public static class TooManyErrorsException
    extends Exception {
        private TooManyErrorsException() {
            super(DiagnosticBundle.message("error.monitor.too.many.errors", new Object[0]));
        }
    }

    private class MessageGrouper
    implements Runnable {
        private final List<AbstractMessage> myMessages = new ArrayList<AbstractMessage>();
        private Future<?> myAlarm = CompletableFuture.completedFuture(null);

        private MessageGrouper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<AbstractMessage> list2 = this.myMessages;
            synchronized (list2) {
                if (this.myMessages.size() > 0) {
                    this.post();
                }
            }
        }

        private void post() {
            AbstractMessage message = this.myMessages.size() == 1 ? this.myMessages.get(0) : new GroupedLogMessage(new ArrayList<AbstractMessage>(this.myMessages));
            message.setOnReadCallback(() -> MessagePool.this.notifyEntryRead());
            this.myMessages.clear();
            MessagePool.this.myErrors.add(message);
            MessagePool.this.notifyEntryAdded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToGroup(@NotNull AbstractMessage message) {
            if (message == null) {
                MessageGrouper.$$$reportNull$$$0(0);
            }
            List<AbstractMessage> list2 = this.myMessages;
            synchronized (list2) {
                this.myMessages.add(message);
                if (this.myMessages.size() >= 20) {
                    this.post();
                } else {
                    this.myAlarm.cancel(false);
                    this.myAlarm = AppExecutorUtil.getAppScheduledExecutorService().schedule(this, 1000L, TimeUnit.MILLISECONDS);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diagnostic/MessagePool$MessageGrouper", "addToGroup"));
        }
    }

    private static class MessagePoolHolder {
        private static final MessagePool ourInstance = new MessagePool();

        private MessagePoolHolder() {
        }
    }

    public static enum State {
        NoErrors,
        ReadErrors,
        UnreadErrors;

    }
}

