/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.legend;

import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SeriesLegend
implements Legend {
    @NotNull
    private final Range myRange;
    @NotNull
    private final RangedContinuousSeries mySeries;
    @NotNull
    private final BaseAxisFormatter myFormatter;
    @NotNull
    private final String myName;
    @NotNull
    private final Interpolatable<Long, Double> myInterpolator;

    public SeriesLegend(@NotNull RangedContinuousSeries series, @NotNull BaseAxisFormatter formatter, @NotNull Range range) {
        if (series == null) {
            SeriesLegend.$$$reportNull$$$0(0);
        }
        if (formatter == null) {
            SeriesLegend.$$$reportNull$$$0(1);
        }
        if (range == null) {
            SeriesLegend.$$$reportNull$$$0(2);
        }
        this(series, formatter, range, Interpolatable.SegmentInterpolator);
    }

    public SeriesLegend(@NotNull RangedContinuousSeries series, @NotNull BaseAxisFormatter formatter, @NotNull Range range, @NotNull Interpolatable<Long, Double> interpolator) {
        if (series == null) {
            SeriesLegend.$$$reportNull$$$0(3);
        }
        if (formatter == null) {
            SeriesLegend.$$$reportNull$$$0(4);
        }
        if (range == null) {
            SeriesLegend.$$$reportNull$$$0(5);
        }
        if (interpolator == null) {
            SeriesLegend.$$$reportNull$$$0(6);
        }
        this(series, formatter, range, series.getName(), interpolator);
    }

    public SeriesLegend(@NotNull RangedContinuousSeries series, @NotNull BaseAxisFormatter formatter, @NotNull Range range, @NotNull String name, @NotNull Interpolatable<Long, Double> interpolator) {
        if (series == null) {
            SeriesLegend.$$$reportNull$$$0(7);
        }
        if (formatter == null) {
            SeriesLegend.$$$reportNull$$$0(8);
        }
        if (range == null) {
            SeriesLegend.$$$reportNull$$$0(9);
        }
        if (name == null) {
            SeriesLegend.$$$reportNull$$$0(10);
        }
        if (interpolator == null) {
            SeriesLegend.$$$reportNull$$$0(11);
        }
        this.myRange = range;
        this.mySeries = series;
        this.myFormatter = formatter;
        this.myName = name;
        this.myInterpolator = interpolator;
    }

    @Override
    @Nullable
    public String getValue() {
        double time = this.myRange.getMax();
        List<SeriesData<Long>> data = this.mySeries.getDataSeries().getDataForXRange(new Range(time, time));
        if (data.isEmpty()) {
            return null;
        }
        return this.myFormatter.getFormattedString(this.mySeries.getYRange().getLength(), this.getInterpolatedValueAt(time, data), true);
    }

    /*
     * WARNING - void declaration
     */
    private double getInterpolatedValueAt(double time, @NotNull List<SeriesData<Long>> list) {
        SeriesData<Long> key;
        void data;
        int index;
        if (list == null) {
            SeriesLegend.$$$reportNull$$$0(12);
        }
        if ((index = Collections.binarySearch(data, key = new SeriesData<Long>((long)time, 0L), (left, right) -> {
            long diff = left.x - right.x;
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        })) >= 0) {
            return ((Long)((SeriesData)data.get((int)index)).value).longValue();
        }
        if ((index = -(index + 1)) == 0) {
            return ((Long)((SeriesData)data.get((int)index)).value).longValue();
        }
        if (index >= data.size()) {
            return ((Long)((SeriesData)data.get((int)(data.size() - 1))).value).longValue();
        }
        return this.myInterpolator.interpolate((SeriesData)data.get(index - 1), (SeriesData)data.get(index), time);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SeriesLegend.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "series";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpolator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/model/legend/SeriesLegend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/model/legend/SeriesLegend";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInterpolatedValueAt";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

