/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Set;

public abstract class MouseAdapterComponent<K>
extends AnimatedComponent
implements MouseListener,
MouseMotionListener {
    private static final double EPISLON = 1.0E-7;
    private static final double HEIGHT_DELTA_PER_FRAME = 0.1;
    private double myNormalizedMouseX;
    private double myDefaultHeight = 0.0;
    private double myExpandedHeight = 0.0;
    private double myHeightFactor = 1.0;
    private final HashMap<K, Rectangle2D.Float> myRectangles;

    public MouseAdapterComponent(double defaultHeightPercent, double expandedHeightPercent) {
        this.myDefaultHeight = defaultHeightPercent;
        this.myExpandedHeight = expandedHeightPercent;
        this.myRectangles = new HashMap();
        this.attach();
    }

    public void attach() {
        this.detach();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void detach() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    private void updateRect(Rectangle2D.Float rect, double xPercent, double yPercent, double widthPercent, double vGap) {
        double height = rect.getHeight() + vGap;
        height = this.myNormalizedMouseX != 0.0 && xPercent < this.myNormalizedMouseX && xPercent + widthPercent > this.myNormalizedMouseX ? (height + 1.0E-7 < this.myExpandedHeight ? (height += 0.1) : this.myExpandedHeight) : (height - 1.0E-7 > this.myDefaultHeight ? (height -= 0.1) : this.myDefaultHeight);
        rect.setRect(xPercent, yPercent + (1.0 - height), widthPercent, (height - vGap) * this.myHeightFactor);
    }

    public Set<K> getRectangleKeys() {
        return ContainerUtil.newHashSet(this.myRectangles.keySet());
    }

    public void removeRectangle(K key) {
        this.myRectangles.remove(key);
    }

    public int getRectangleCount() {
        return this.myRectangles.size();
    }

    public Rectangle2D.Float getRectangle(K key) {
        return this.myRectangles.get(key);
    }

    public void setHeightFactor(double factor) {
        this.myHeightFactor = factor;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setMousePointAndForwardEvent(e.getX(), e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setMousePointAndForwardEvent(e.getX(), e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setMousePointAndForwardEvent(e.getX(), e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setMousePointAndForwardEvent(e.getX(), e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setMousePointAndForwardEvent(0.0, e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setMousePointAndForwardEvent(e.getX(), e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setMousePointAndForwardEvent(e.getX(), e);
    }

    private void setMousePointAndForwardEvent(double x, MouseEvent e) {
        this.myNormalizedMouseX = x / (1.0 * (double)this.getWidth());
        this.getParent().dispatchEvent(e);
    }

    protected final Rectangle2D.Float setRectangleData(K key, double previousX, double currentX, double minX, double maxX, float rectY, double vGap) {
        Rectangle2D.Float rectangle = this.getRectangle(key);
        if (rectangle == null) {
            rectangle = new Rectangle2D.Float();
            this.myRectangles.put(key, rectangle);
        }
        this.updateRect(rectangle, (previousX - minX) / (maxX - minX), rectY, (currentX - previousX) / (maxX - minX), vGap);
        return rectangle;
    }
}

