/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.index;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.clones.configuration.DuplicatePersistentSettings;
import com.jetbrains.clones.languagescope.DuplicateScopeExtension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/clones/index/HashIndexFileFilter;", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "()V", "acceptInput", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isGenerated", "project", "Lcom/intellij/openapi/project/Project;", "isIndexed", "intellij.platform.duplicatesDetector"})
public final class HashIndexFileFilter
implements FileBasedIndex.InputFilter {
    public boolean acceptInput(@NotNull VirtualFile file) {
        boolean bl;
        block1: {
            Project[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project[] projectArray = projectManager.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
            Project[] projectArray2 = $receiver$iv = projectArray;
            int n = projectArray2.length;
            for (int i = 0; i < n; ++i) {
                Project element$iv;
                Project project;
                Project project2 = project = (element$iv = projectArray2[i]);
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                if (!this.isIndexed(project2, file)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIndexed(Project project, VirtualFile file) {
        boolean bl;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        ProjectFileIndex projectIndex = projectFileIndex;
        if (this.isGenerated(project, file)) {
            return false;
        }
        if (projectIndex.isInTestSourceContent(file)) {
            if (DuplicatePersistentSettings.INSTANCE.getTestsDisabled()) return false;
            bl = true;
        } else {
            if (!projectIndex.isInSourceContent(file)) return false;
            bl = true;
        }
        boolean isIndexedContent = bl;
        if (!isIndexedContent) return false;
        FileType fileType = file.getFileType();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"file.fileType");
        if (DuplicateScopeExtension.Companion.findDuplicateScope(fileType) == null) return false;
        return true;
    }

    private final boolean isGenerated(Project project, VirtualFile file) {
        return VfsUtilCore.findContainingDirectory((VirtualFile)file, (CharSequence)"generated") != null || JavaProjectRootsUtil.isInGeneratedCode((VirtualFile)file, (Project)project);
    }
}

