/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.WordOptimizer;
import com.intellij.structuralsearch.impl.matcher.filters.AnnotationFilter;
import com.intellij.structuralsearch.impl.matcher.filters.BlockFilter;
import com.intellij.structuralsearch.impl.matcher.filters.ClassFilter;
import com.intellij.structuralsearch.impl.matcher.filters.CommentFilter;
import com.intellij.structuralsearch.impl.matcher.filters.ConstantFilter;
import com.intellij.structuralsearch.impl.matcher.filters.DeclarationFilter;
import com.intellij.structuralsearch.impl.matcher.filters.DefaultFilter;
import com.intellij.structuralsearch.impl.matcher.filters.ExpressionFilter;
import com.intellij.structuralsearch.impl.matcher.filters.JavaDocFilter;
import com.intellij.structuralsearch.impl.matcher.filters.MethodFilter;
import com.intellij.structuralsearch.impl.matcher.filters.StatementFilter;
import com.intellij.structuralsearch.impl.matcher.filters.SymbolNodeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.TypeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.TypeParameterFilter;
import com.intellij.structuralsearch.impl.matcher.filters.TypedSymbolNodeFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.AnnotationHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.DeclarationStatementHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.DocDataHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.ExpressionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.LiteralWithSubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.StatementHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SymbolHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TypedSymbolHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.DocValuesIterator;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class JavaCompilingVisitor
extends JavaRecursiveElementWalkingVisitor {
    final GlobalCompilingVisitor myCompilingVisitor;
    @NonNls
    private static final String COMMENT = "\\s*(__\\$_\\w+)\\s*";
    private static final Pattern ourPattern = Pattern.compile("//\\s*(__\\$_\\w+)\\s*", 32);
    private static final Pattern ourPattern2 = Pattern.compile("/\\*\\s*(__\\$_\\w+)\\s*\\*/", 32);
    private static final Pattern ourPattern3 = Pattern.compile("/\\*\\*\\s*(__\\$_\\w+)\\s*\\*/", 32);
    static final Set<String> excludedKeywords = ContainerUtil.newHashSet((Object[])new String[]{"class", "interface", "enum", "throws", "extends", "implements"});

    public JavaCompilingVisitor(GlobalCompilingVisitor compilingVisitor) {
        this.myCompilingVisitor = compilingVisitor;
    }

    public void compile(PsiElement[] topLevelElements) {
        JavaWordOptimizer optimizer = new JavaWordOptimizer();
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        for (PsiElement element : topLevelElements) {
            element.accept((PsiElementVisitor)this);
            element.accept((PsiElementVisitor)optimizer);
            pattern.setHandler(element, new TopLevelMatchingHandler(pattern.getHandler(element)));
        }
    }

    public void visitDocTag(PsiDocTag psiDocTag) {
        super.visitDocTag(psiDocTag);
        DocValuesIterator sons = new DocValuesIterator(psiDocTag.getFirstChild());
        while (((NodeIterator)sons).hasNext()) {
            this.myCompilingVisitor.setHandler(((NodeIterator)sons).current(), new DocDataHandler());
            ((NodeIterator)sons).advance();
        }
    }

    public void visitComment(PsiComment comment) {
        MatchingHandler handler;
        super.visitComment(comment);
        String text = comment.getText();
        Matcher matcher = ourPattern.matcher(text);
        boolean matches = false;
        if (!matcher.matches()) {
            matcher = ourPattern2.matcher(text);
            if (!matcher.matches()) {
                matcher = ourPattern3.matcher(text);
            } else {
                matches = true;
            }
        } else {
            matches = true;
        }
        if (matches || matcher.matches()) {
            String str = matcher.group(1);
            comment.putUserData(CompiledPattern.HANDLER_KEY, (Object)str);
            GlobalCompilingVisitor.setFilter(this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)comment), CommentFilter.getInstance());
            SubstitutionHandler handler2 = (SubstitutionHandler)this.myCompilingVisitor.getContext().getPattern().getHandler(str);
            if (handler2 == null) {
                throw new MalformedPatternException();
            }
            RegExpPredicate predicate = handler2.findRegExpPredicate();
            if (GlobalCompilingVisitor.isSuitablePredicate(predicate, handler2)) {
                this.myCompilingVisitor.processTokenizedName(predicate.getRegExp(), true, GlobalCompilingVisitor.OccurenceKind.COMMENT);
            }
            matches = true;
        }
        if (!matches && (handler = this.myCompilingVisitor.processPatternStringWithFragments(text, GlobalCompilingVisitor.OccurenceKind.COMMENT)) != null) {
            comment.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
        }
    }

    public void visitExpression(PsiExpression expression) {
        MatchingHandler handler;
        super.visitExpression(expression);
        if (!(expression.getParent() instanceof PsiExpressionStatement) && !(expression instanceof PsiParenthesizedExpression) && (handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)expression)).getFilter() == null) {
            handler.setFilter(e -> DefaultFilter.accepts((PsiElement)expression, (PsiElement)(e instanceof PsiExpression ? PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)e)) : e)));
        }
    }

    public void visitLiteralExpression(PsiLiteralExpression expression) {
        String text = expression.getText();
        if (StringUtil.isQuotedString((String)text)) {
            MatchingHandler handler = this.myCompilingVisitor.processPatternStringWithFragments(text, GlobalCompilingVisitor.OccurenceKind.LITERAL);
            if (PsiType.CHAR.equals((Object)expression.getType()) && (handler instanceof LiteralWithSubstitutionHandler || handler == null && expression.getValue() == null)) {
                throw new MalformedPatternException("Bad character literal");
            }
            if (handler != null) {
                expression.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
            }
        } else if (!PsiType.NULL.equals((Object)expression.getType()) && expression.getValue() == null) {
            throw new MalformedPatternException("Bad literal");
        }
        super.visitLiteralExpression(expression);
    }

    public void visitField(PsiField psiField) {
        super.visitField(psiField);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandler((PsiElement)psiField);
        if (JavaCompilingVisitor.needsSupers((PsiElement)psiField, handler)) {
            assert (pattern instanceof JavaCompiledPattern);
            ((JavaCompiledPattern)pattern).setRequestsSuperFields(true);
        }
    }

    public void visitMethod(PsiMethod psiMethod) {
        super.visitMethod(psiMethod);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandler((PsiElement)psiMethod);
        if (JavaCompilingVisitor.needsSupers((PsiElement)psiMethod, handler)) {
            assert (pattern instanceof JavaCompiledPattern);
            ((JavaCompiledPattern)pattern).setRequestsSuperMethods(true);
        }
        GlobalCompilingVisitor.setFilter(handler, MethodFilter.getInstance());
    }

    public void visitReferenceExpression(PsiReferenceExpression reference) {
        MatchingHandler handler;
        this.visitElement((PsiElement)reference);
        boolean typedVarProcessed = false;
        PsiElement referenceParent = reference.getParent();
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        if (pattern.isRealTypedVar((PsiElement)reference) && reference.getQualifierExpression() == null && !(referenceParent instanceof PsiExpressionStatement)) {
            handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)reference);
            GlobalCompilingVisitor.setFilter(handler, ExpressionFilter.getInstance());
            PsiElement parent = reference.getParent();
            if (parent instanceof PsiSwitchLabelStatement && handler instanceof SubstitutionHandler) {
                SubstitutionHandler handler1 = (SubstitutionHandler)handler;
                pattern.setHandler(parent, new SubstitutionHandler("__case_" + parent.getTextOffset(), false, handler1.getMinOccurs(), handler1.getMaxOccurs(), true));
            }
            typedVarProcessed = true;
        }
        handler = pattern.getHandler((PsiElement)reference);
        String referencedName = reference.getReferenceName();
        if (!typedVarProcessed && !(handler instanceof SubstitutionHandler)) {
            PsiElement resolve = reference.resolve();
            PsiElement referenceQualifier = reference.getQualifier();
            if (resolve instanceof PsiClass || resolve == null && (referencedName != null && Character.isUpperCase(referencedName.charAt(0)) || referenceQualifier == null)) {
                PsiExpression qualifier;
                boolean hasNoNestedSubstitutionHandlers = false;
                PsiReferenceExpression currentReference = reference;
                while ((qualifier = currentReference.getQualifierExpression()) != null) {
                    if (!(qualifier instanceof PsiReferenceExpression) || pattern.getHandler((PsiElement)qualifier) instanceof SubstitutionHandler) {
                        hasNoNestedSubstitutionHandlers = true;
                        break;
                    }
                    currentReference = (PsiReferenceExpression)qualifier;
                }
                if (!hasNoNestedSubstitutionHandlers && PsiTreeUtil.getChildOfType((PsiElement)reference, PsiAnnotation.class) == null) {
                    this.createAndSetSubstitutionHandlerFromReference((PsiElement)reference, resolve != null ? ((PsiClass)resolve).getQualifiedName() : reference.getText(), referenceParent instanceof PsiReferenceExpression);
                }
            } else if (referenceQualifier == null || reference.getParent() instanceof PsiExpressionStatement) {
                // empty if block
            }
        }
    }

    public void visitBlockStatement(PsiBlockStatement psiBlockStatement) {
        super.visitBlockStatement(psiBlockStatement);
        this.myCompilingVisitor.setFilterSimple((PsiElement)psiBlockStatement, BlockFilter.getInstance());
    }

    public void visitVariable(PsiVariable variable) {
        super.visitVariable(variable);
        this.myCompilingVisitor.setFilterSimple((PsiElement)variable, e -> e instanceof PsiVariable);
    }

    public void visitParameter(PsiParameter parameter) {
        super.visitParameter(parameter);
        PsiElement parent = parameter.getParent();
        if (!(parent instanceof PsiCatchSection)) {
            return;
        }
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandlerSimple((PsiElement)parameter);
        String name = "__catch_" + parent.getTextOffset();
        SubstitutionHandler substitutionHandler = handler instanceof SubstitutionHandler ? new SubstitutionHandler(name, false, ((SubstitutionHandler)handler).getMinOccurs(), ((SubstitutionHandler)handler).getMaxOccurs(), true) : new SubstitutionHandler(name, false, 1, 1, true);
        pattern.setHandler(parent, substitutionHandler);
    }

    public void visitDeclarationStatement(PsiDeclarationStatement psiDeclarationStatement) {
        super.visitDeclarationStatement(psiDeclarationStatement);
        PsiElement firstChild = psiDeclarationStatement.getFirstChild();
        if (firstChild instanceof PsiTypeElement) {
            PsiJavaCodeReferenceElement reference = ((PsiTypeElement)firstChild).getInnermostComponentReferenceElement();
            if (reference != null && reference.getParameterList().getTypeParameterElements().length > 0) {
                PsiTypeElement[] params;
                this.myCompilingVisitor.setHandler((PsiElement)psiDeclarationStatement, new TypedSymbolHandler());
                this.myCompilingVisitor.setFilterSimple((PsiElement)psiDeclarationStatement, TypedSymbolNodeFilter.getInstance());
                for (PsiTypeElement param : params = reference.getParameterList().getTypeParameterElements()) {
                    if (param.getInnermostComponentReferenceElement() == null || !this.myCompilingVisitor.getContext().getPattern().isRealTypedVar(param.getInnermostComponentReferenceElement().getReferenceNameElement())) continue;
                    this.myCompilingVisitor.setFilterSimple((PsiElement)param, TypeParameterFilter.getInstance());
                }
                return;
            }
        } else if (firstChild instanceof PsiModifierList) {
            PsiModifierList modifierList = (PsiModifierList)firstChild;
            PsiAnnotation[] annotations = modifierList.getAnnotations();
            if (annotations.length != 1) {
                throw new MalformedPatternException();
            }
            for (String modifier : PsiModifier.MODIFIERS) {
                if (!modifierList.hasExplicitModifier(modifier)) continue;
                throw new MalformedPatternException();
            }
            this.myCompilingVisitor.setHandler((PsiElement)psiDeclarationStatement, new AnnotationHandler());
            this.myCompilingVisitor.setFilterSimple((PsiElement)psiDeclarationStatement, AnnotationFilter.getInstance());
            return;
        }
        DeclarationStatementHandler handler = new DeclarationStatementHandler();
        this.myCompilingVisitor.getContext().getPattern().setHandler((PsiElement)psiDeclarationStatement, handler);
        PsiElement previousNonWhiteSpace = PsiTreeUtil.skipWhitespacesBackward((PsiElement)psiDeclarationStatement);
        if (previousNonWhiteSpace instanceof PsiComment) {
            handler.setCommentHandler(this.myCompilingVisitor.getContext().getPattern().getHandler(previousNonWhiteSpace));
            this.myCompilingVisitor.getContext().getPattern().setHandler(previousNonWhiteSpace, handler);
        }
        handler.setFilter(DeclarationFilter.getInstance());
    }

    public void visitDocComment(PsiDocComment psiDocComment) {
        super.visitDocComment(psiDocComment);
        this.myCompilingVisitor.setFilterSimple((PsiElement)psiDocComment, JavaDocFilter.getInstance());
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        PsiNewExpression newExpression;
        super.visitReferenceElement(reference);
        PsiElement parent = reference.getParent();
        if (parent != null && parent.getParent() instanceof PsiClass) {
            GlobalCompilingVisitor.setFilter(this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)reference), TypeFilter.getInstance());
        } else if (parent instanceof PsiNewExpression && (newExpression = (PsiNewExpression)parent).getArrayInitializer() != null) {
            GlobalCompilingVisitor.setFilter(this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)reference), e -> e instanceof PsiJavaCodeReferenceElement || e instanceof PsiKeyword);
        }
    }

    public void visitClass(PsiClass psiClass) {
        super.visitClass(psiClass);
        CompileContext context = this.myCompilingVisitor.getContext();
        CompiledPattern pattern = context.getPattern();
        MatchingHandler handler = pattern.getHandler((PsiElement)psiClass);
        if (JavaCompilingVisitor.needsSupers((PsiElement)psiClass, handler)) {
            ((JavaCompiledPattern)pattern).setRequestsSuperInners(true);
        }
        GlobalCompilingVisitor.setFilter(handler, ClassFilter.getInstance());
        if (!(handler instanceof SubstitutionHandler) || ((SubstitutionHandler)handler).getMinOccurs() > 0) {
            if (psiClass.isInterface()) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord("interface", true, GlobalCompilingVisitor.OccurenceKind.CODE, context);
            } else if (psiClass.isEnum()) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord("enum", true, GlobalCompilingVisitor.OccurenceKind.CODE, context);
            } else {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord("interface", false, GlobalCompilingVisitor.OccurenceKind.CODE, context);
                GlobalCompilingVisitor.addFilesToSearchForGivenWord("enum", false, GlobalCompilingVisitor.OccurenceKind.CODE, context);
                GlobalCompilingVisitor.addFilesToSearchForGivenWord("class", true, GlobalCompilingVisitor.OccurenceKind.CODE, context);
            }
        }
    }

    private void createAndSetSubstitutionHandlerFromReference(PsiElement expr, String referenceText, boolean classQualifier) {
        SubstitutionHandler substitutionHandler = new SubstitutionHandler("__" + referenceText.replace('.', '_'), false, classQualifier ? 0 : 1, 1, true);
        boolean caseSensitive = this.myCompilingVisitor.getContext().getOptions().isCaseSensitiveMatch();
        substitutionHandler.setPredicate(new RegExpPredicate(StructuralSearchUtil.shieldRegExpMetaChars(referenceText), caseSensitive, null, false, false));
        this.myCompilingVisitor.getContext().getPattern().setHandler(expr, substitutionHandler);
    }

    public void visitExpressionStatement(PsiExpressionStatement expressionStatement) {
        super.visitExpressionStatement(expressionStatement);
        PsiElement child = expressionStatement.getLastChild();
        if (!(child instanceof PsiJavaToken) && !(child instanceof PsiComment)) {
            PsiElement reference = expressionStatement.getFirstChild();
            CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
            MatchingHandler referenceHandler = pattern.getHandler(reference);
            if (referenceHandler instanceof SubstitutionHandler && reference instanceof PsiReferenceExpression) {
                pattern.setHandler((PsiElement)expressionStatement, referenceHandler);
                referenceHandler.setFilter(SymbolNodeFilter.getInstance());
                this.myCompilingVisitor.setHandler((PsiElement)expressionStatement, new SymbolHandler((SubstitutionHandler)referenceHandler));
            } else if (reference instanceof PsiLiteralExpression) {
                ExpressionHandler handler = new ExpressionHandler();
                this.myCompilingVisitor.setHandler((PsiElement)expressionStatement, handler);
                handler.setFilter(ConstantFilter.getInstance());
            } else {
                ExpressionHandler handler = new ExpressionHandler();
                this.myCompilingVisitor.setHandler((PsiElement)expressionStatement, handler);
                handler.setFilter(ExpressionFilter.getInstance());
            }
        } else {
            MatchingHandler handler;
            CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
            if (expressionStatement.getExpression() instanceof PsiReferenceExpression && pattern.isRealTypedVar((PsiElement)expressionStatement) && (handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)expressionStatement)) instanceof SubstitutionHandler) {
                SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
                substitutionHandler.setFilter(new StatementFilter());
                substitutionHandler.setMatchHandler(new StatementHandler());
            }
        }
    }

    public void visitElement(PsiElement element) {
        this.myCompilingVisitor.handle(element);
        super.visitElement(element);
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        for (PsiElement el = block.getFirstChild(); el != null; el = el.getNextSibling()) {
            if (GlobalCompilingVisitor.getFilter().accepts(el)) {
                if (!(el instanceof PsiWhiteSpace)) continue;
                this.myCompilingVisitor.addLexicalNode(el);
                continue;
            }
            el.accept((PsiElementVisitor)this);
        }
    }

    private static boolean needsSupers(PsiElement element, MatchingHandler handler) {
        if (element.getParent() instanceof PsiClass && handler instanceof SubstitutionHandler) {
            SubstitutionHandler handler2 = (SubstitutionHandler)handler;
            return handler2.isStrictSubtype() || handler2.isSubtype();
        }
        return false;
    }

    private class JavaWordOptimizer
    extends JavaRecursiveElementWalkingVisitor
    implements WordOptimizer {
        private JavaWordOptimizer() {
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            String word = reference.getReferenceName();
            if (!this.handleWord(word, JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            if (reference.isQualified() && this.isClassFromJavaLangPackage(reference.resolve())) {
                return;
            }
            super.visitReferenceElement(reference);
        }

        private boolean isClassFromJavaLangPackage(PsiElement target) {
            if (!(target instanceof PsiClass)) {
                return false;
            }
            PsiFile file = target.getContainingFile();
            if (!(file instanceof PsiJavaFile)) {
                return false;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            return "java.lang".equals(javaFile.getPackageName());
        }

        public void visitMethod(PsiMethod method) {
            if (!this.handleWord(method.getName(), JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitMethod(method);
        }

        public void visitVariable(PsiVariable variable) {
            if (!this.handleWord(variable.getName(), JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitVariable(variable);
        }

        public void visitClass(PsiClass aClass) {
            if (!this.handleWord(aClass.getName(), JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitClass(aClass);
        }

        public void visitElement(PsiElement element) {
            String keyword;
            super.visitElement(element);
            if (element instanceof PsiMethodReferenceExpression) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord("::", true, GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext());
            } else if (element instanceof PsiLambdaExpression) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord("->", true, GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext());
            } else if (element instanceof PsiKeyword && !excludedKeywords.contains(keyword = element.getText())) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord(keyword, true, GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext());
            }
        }

        @Override
        public List<String> getDescendantsOf(String className, boolean includeSelf, Project project) {
            SmartList result = new SmartList();
            GlobalSearchScope projectAndLibraries = ProjectScope.getAllScope((Project)project);
            PsiClass[] classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(className, projectAndLibraries);
            if (classes2.length == 0) {
                result.add((Object)className);
                return result;
            }
            for (PsiClass aClass : classes2) {
                String name;
                if (includeSelf && (name = aClass.getName()) != null) {
                    result.add((Object)name);
                }
                ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)projectAndLibraries, (boolean)true).forEach(c -> {
                    String name = c.getName();
                    if (name != null) {
                        result.add((Object)name);
                    }
                    return true;
                });
            }
            return result;
        }
    }
}

