/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableAccessFromInnerClassFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.ArrayInitializerAwareConversionDescriptor;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRuleUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadLocalConversionRule
extends TypeConversionRule {
    private static final Logger LOG = Logger.getInstance(ThreadLocalConversionRule.class);

    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        if (to instanceof PsiClassType && ThreadLocalConversionRule.isThreadLocalTypeMigration(from, (PsiClassType)to, context)) {
            return ThreadLocalConversionRule.findDirectConversion((PsiElement)context, to, from, labeler);
        }
        return null;
    }

    private static boolean isThreadLocalTypeMigration(PsiType from, PsiClassType to, PsiExpression context) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)to);
        PsiClass threadLocalClass = resolveResult.getElement();
        if (threadLocalClass != null) {
            String typeQualifiedName = threadLocalClass.getQualifiedName();
            if (!Comparing.strEqual((String)typeQualifiedName, (String)ThreadLocal.class.getName())) {
                return false;
            }
            PsiTypeParameter[] typeParameters = threadLocalClass.getTypeParameters();
            if (typeParameters.length != 1) {
                return !PsiUtil.isLanguageLevel5OrHigher((PsiElement)context);
            }
            PsiType toTypeParameterValue = resolveResult.getSubstitutor().substitute(typeParameters[0]);
            if (toTypeParameterValue != null) {
                if (from instanceof PsiPrimitiveType) {
                    PsiPrimitiveType unboxedInitialType = PsiPrimitiveType.getUnboxedType((PsiType)toTypeParameterValue);
                    if (unboxedInitialType != null) {
                        return TypeConversionUtil.areTypesConvertible((PsiType)from, (PsiType)unboxedInitialType);
                    }
                } else {
                    return TypeConversionUtil.isAssignable((PsiType)from, (PsiType)PsiUtil.captureToplevelWildcards((PsiType)toTypeParameterValue, (PsiElement)context));
                }
            }
            return !PsiUtil.isLanguageLevel5OrHigher((PsiElement)context);
        }
        return false;
    }

    @Nullable
    public static TypeConversionDescriptor findDirectConversion(PsiElement context, PsiType to, PsiType from, TypeMigrationLabeler labeler) {
        IElementType operationSign;
        PsiClass toTypeClass = PsiUtil.resolveClassInType((PsiType)to);
        LOG.assertTrue(toTypeClass != null);
        if (context instanceof PsiArrayAccessExpression) {
            return new TypeConversionDescriptor("$qualifier$[$val$]", "$qualifier$.get()[$val$]");
        }
        PsiElement parent = context.getParent();
        if (parent instanceof PsiAssignmentExpression && (operationSign = ((PsiAssignmentExpression)parent).getOperationTokenType()) == JavaTokenType.EQ) {
            boolean rightInfected = ((PsiAssignmentExpression)parent).getLExpression() == context;
            String replacement = rightInfected ? "$qualifier$ = $val$.get()" : "$qualifier$.set(" + ThreadLocalConversionRule.toBoxed("$val$", from, context) + ")";
            return new TypeConversionDescriptor("$qualifier$ = $val$", replacement, (PsiExpression)((PsiAssignmentExpression)parent));
        }
        if (context instanceof PsiReferenceExpression) {
            PsiExpression qualifierExpression = ((PsiReferenceExpression)context).getQualifierExpression();
            PsiExpression expression = context.getParent() instanceof PsiMethodCallExpression && qualifierExpression != null ? qualifierExpression : (PsiExpression)context;
            return new TypeConversionDescriptor("$qualifier$", ThreadLocalConversionRule.toPrimitive("$qualifier$.get()", from, context), expression);
        }
        if (context instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)context;
            String sign = binaryExpression.getOperationSign().getText();
            return new TypeConversionDescriptor("$qualifier$" + sign + "$val$", ThreadLocalConversionRule.toPrimitive("$qualifier$.get()", from, context) + " " + sign + " $val$");
        }
        if (parent instanceof PsiVariable && ((PsiVariable)parent).getInitializer() == context) {
            return ThreadLocalConversionRule.wrapWithNewExpression(to, from, (PsiExpression)context);
        }
        if (parent instanceof PsiExpressionStatement) {
            if (context instanceof PsiPostfixExpression) {
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)context;
                String sign = postfixExpression.getOperationSign().getText();
                return new TypeConversionDescriptor("$qualifier$" + sign, "$qualifier$.set(" + ThreadLocalConversionRule.getBoxedWrapper(from, to, ThreadLocalConversionRule.toPrimitive("$qualifier$.get()", from, context) + " " + sign.charAt(0) + " 1", labeler, context, postfixExpression.getOperand().getText() + sign.charAt(0) + " 1") + ")");
            }
            if (context instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)context;
                PsiJavaToken operationSign2 = ((PsiPrefixExpression)context).getOperationSign();
                if (operationSign2.getTokenType() == JavaTokenType.EXCL) {
                    return new TypeConversionDescriptor("!$qualifier$", "!$qualifier$.get()");
                }
                String sign = operationSign2.getText();
                PsiExpression operand = prefixExpression.getOperand();
                return new TypeConversionDescriptor(sign + "$qualifier$", "$qualifier$.set(" + ThreadLocalConversionRule.getBoxedWrapper(from, to, ThreadLocalConversionRule.toPrimitive("$qualifier$.get()", from, context) + " " + sign.charAt(0) + " 1", labeler, context, operand != null ? operand.getText() + sign.charAt(0) + " 1" : null) + ")");
            }
            if (context instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)context;
                PsiJavaToken signToken = assignmentExpression.getOperationSign();
                IElementType operationSign3 = signToken.getTokenType();
                String sign = signToken.getText();
                PsiExpression lExpression = assignmentExpression.getLExpression();
                if (operationSign3 == JavaTokenType.EQ) {
                    PsiElement element;
                    if (lExpression instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable && ((PsiVariable)element).hasModifierProperty("final")) {
                        return ThreadLocalConversionRule.wrapWithNewExpression(to, from, ((PsiAssignmentExpression)context).getRExpression());
                    }
                    return new TypeConversionDescriptor("$qualifier$ = $val$", "$qualifier$.set(" + ThreadLocalConversionRule.toBoxed("$val$", from, context) + ")");
                }
                PsiExpression rExpression = assignmentExpression.getRExpression();
                return new TypeConversionDescriptor("$qualifier$" + sign + "$val$", "$qualifier$.set(" + ThreadLocalConversionRule.getBoxedWrapper(from, to, ThreadLocalConversionRule.toPrimitive("$qualifier$.get()", from, context) + " " + sign.charAt(0) + " $val$", labeler, context, rExpression != null ? lExpression.getText() + sign.charAt(0) + rExpression.getText() : null) + ")");
            }
        }
        return null;
    }

    public static TypeConversionDescriptor wrapWithNewExpression(PsiType to, PsiType from, PsiExpression initializer) {
        String boxedTypeName = from instanceof PsiPrimitiveType ? ((PsiPrimitiveType)from).getBoxedTypeName() : from.getCanonicalText();
        List<PsiVariable> toMakeFinal = TypeConversionRuleUtil.getVariablesToMakeFinal(initializer);
        if (toMakeFinal == null) {
            return null;
        }
        return new WrappingWithInnerClassOrLambdaDescriptor("$qualifier$", ThreadLocalConversionRule.createThreadLocalInitializerReplacement(to, from, initializer, boxedTypeName), initializer, toMakeFinal);
    }

    private static String createThreadLocalInitializerReplacement(PsiType to, PsiType from, PsiExpression initializer, String boxedTypeName) {
        if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)initializer)) {
            return "java.lang.ThreadLocal.withInitial(() -> $qualifier$)";
        }
        return "new " + to.getCanonicalText() + "() {\n@Override\nprotected " + boxedTypeName + " initialValue() {\n  return " + (PsiUtil.isLanguageLevel5OrHigher((PsiElement)initializer) ? initializer.getText() : (from instanceof PsiPrimitiveType ? "new " + ((PsiPrimitiveType)from).getBoxedTypeName() + "($qualifier$)" : "$qualifier$")) + ";\n}\n}";
    }

    private static String toPrimitive(String replaceByArg, PsiType from, PsiElement context) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)context) ? replaceByArg : (from instanceof PsiPrimitiveType ? "((" + ((PsiPrimitiveType)from).getBoxedTypeName() + ")" + replaceByArg + ")." + from.getCanonicalText() + "Value()" : "((" + from.getCanonicalText() + ")" + replaceByArg + ")");
    }

    private static String toBoxed(String replaceByArg, PsiType from, PsiElement context) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)context) ? replaceByArg : (from instanceof PsiPrimitiveType ? "new " + ((PsiPrimitiveType)from).getBoxedTypeName() + "(" + replaceByArg + ")" : replaceByArg);
    }

    private static String getBoxedWrapper(PsiType from, PsiType to, @NotNull String arg, TypeMigrationLabeler labeler, PsiElement context, @Nullable String tryType) {
        if (arg == null) {
            ThreadLocalConversionRule.$$$reportNull$$$0(0);
        }
        if (from instanceof PsiPrimitiveType) {
            PsiType initial;
            PsiPrimitiveType unboxedInitialType;
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)to);
            PsiClass threadLocalClass = resolveResult.getElement();
            LOG.assertTrue(threadLocalClass != null);
            PsiTypeParameter[] typeParameters = threadLocalClass.getTypeParameters();
            if (typeParameters.length == 1 && (unboxedInitialType = PsiPrimitiveType.getUnboxedType((PsiType)(initial = resolveResult.getSubstitutor().substitute(typeParameters[0])))) != null) {
                PsiType exprType;
                if (tryType != null && (exprType = labeler.getTypeEvaluator().evaluateType(JavaPsiFacade.getElementFactory((Project)threadLocalClass.getProject()).createExpressionFromText(tryType, context))) != null && unboxedInitialType.isAssignableFrom(exprType)) {
                    return ThreadLocalConversionRule.toBoxed(arg, from, context);
                }
                return "new " + initial.getCanonicalText() + "((" + unboxedInitialType.getCanonicalText() + ")(" + arg + "))";
            }
        }
        return ThreadLocalConversionRule.toBoxed(arg, from, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/refactoring/typeMigration/rules/ThreadLocalConversionRule", "getBoxedWrapper"));
    }

    private static class WrappingWithInnerClassOrLambdaDescriptor
    extends ArrayInitializerAwareConversionDescriptor {
        private final List<PsiVariable> myVariablesToMakeFinal;

        private WrappingWithInnerClassOrLambdaDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString, PsiExpression expression, @NotNull List<PsiVariable> toMakeFinal) {
            if (toMakeFinal == null) {
                WrappingWithInnerClassOrLambdaDescriptor.$$$reportNull$$$0(0);
            }
            super(stringToReplace, replaceByString, expression);
            this.myVariablesToMakeFinal = toMakeFinal;
        }

        @Override
        public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
            if (evaluator == null) {
                WrappingWithInnerClassOrLambdaDescriptor.$$$reportNull$$$0(1);
            }
            PsiExpression replaced = super.replace(expression, evaluator);
            boolean atLeastJava8 = PsiUtil.isLanguageLevel8OrHigher((PsiElement)replaced);
            for (PsiVariable var : this.myVariablesToMakeFinal) {
                if (atLeastJava8 && HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)var, (PsiElement)replaced, null)) continue;
                VariableAccessFromInnerClassFix.fixAccess((PsiVariable)var, (PsiElement)replaced);
            }
            return replaced;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toMakeFinal";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/ThreadLocalConversionRule$WrappingWithInnerClassOrLambdaDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

