/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.codeInspection.export.HTMLExportUtil;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesRoot;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.treeHash.DuplocatorHashCallback;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ExportHTMLAction
extends AnAction
implements DumbAware {
    private final GroupNode[] myGroupNodes;
    @NonNls
    private static final String HTML = "HTML";
    @NonNls
    private static final String XML = "XML";
    private final DuplicatesRoot myRoot;

    ExportHTMLAction(DuplicatesRoot root) {
        super("Export", null, AllIcons.ToolbarDecorator.Export);
        this.myGroupNodes = root.getChildren();
        this.myRoot = root;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ExportHTMLAction.$$$reportNull$$$0(0);
        }
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(InspectionsBundle.message((String)"inspection.action.export.popup.title", (Object[])new Object[0]), new String[]{HTML, XML}){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> ExportHTMLAction.this.export(project, Comparing.strEqual((String)selectedValue, (String)ExportHTMLAction.HTML)));
            }
        });
        InputEvent event = e.getInputEvent();
        if (event instanceof MouseEvent) {
            popup.showUnderneathOf(event.getComponent());
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    private void export(Project project, boolean toHtml) {
        ExportToHTMLDialog exportToHTMLDialog = new ExportToHTMLDialog(project, true);
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance((Project)project);
        if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
            exportToHTMLSettings.OUTPUT_DIRECTORY = PathManager.getHomePath() + File.separator + "inspections";
        }
        exportToHTMLDialog.reset();
        if (!exportToHTMLDialog.showAndGet()) {
            return;
        }
        exportToHTMLDialog.apply();
        String outputDirectoryName = exportToHTMLSettings.OUTPUT_DIRECTORY;
        try {
            if (toHtml) {
                int groupIdx = 0;
                StringBuffer groupFrameBuffer = new StringBuffer();
                for (GroupNode groupNode : this.myGroupNodes) {
                    String groupName = "group" + groupIdx++;
                    StringBuffer buffer = new StringBuffer();
                    for (CodeNode codeNode : groupNode.getChildren()) {
                        ExportHTMLAction.outputCodeFragment(project, outputDirectoryName, groupName, buffer, codeNode);
                    }
                    String groupFile = groupName + "-index.html";
                    HTMLExportUtil.writeFile((String)outputDirectoryName, (String)groupFile, (CharSequence)XmlStringUtil.wrapInHtml((CharSequence)buffer), (Project)project);
                    groupFrameBuffer.append("<a href=\"").append(StringUtil.escapeXml((String)groupFile)).append("\" target=\"codeFragmentFrame\">").append(groupName).append(" (").append(groupNode.getTitle(false).getText()).append(")").append("</a>").append("<br>");
                }
                HTMLExportUtil.writeFile((String)outputDirectoryName, (String)"groupIndex.html", (CharSequence)XmlStringUtil.wrapInHtml((CharSequence)groupFrameBuffer), (Project)project);
                ExportHTMLAction.outputMainFrame(project, outputDirectoryName);
                if (exportToHTMLSettings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((File)new File(outputDirectoryName, "index.html"));
                }
            } else {
                DuplocatorHashCallback.writeDuplicates(outputDirectoryName, project, this.myRoot.getDuplicates());
            }
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
        }
    }

    private static void outputCodeFragment(Project project, String outputDirectoryName, String groupName, StringBuffer buffer, CodeNode codeNode) throws InvalidatedException {
        PsiFragment codeNodeFragment = codeNode.getFragment();
        VirtualFile virtualFile = codeNode.getVirtualFile();
        TextRange range = codeNode.getTextRange();
        PsiFile file = codeNodeFragment.getFile();
        if (file == null) {
            return;
        }
        String fragment = file.getText().substring(range.getStartOffset(), range.getEndOffset());
        String codeFragmentFile = groupName + "/" + virtualFile.getNameWithoutExtension() + codeNodeFragment.getStartOffset() + ".html";
        StringBuffer fragmentBuf = new StringBuffer();
        fragmentBuf.append("<head><h4>");
        fragmentBuf.append(codeNode.getTitle(false).getText());
        fragmentBuf.append("</h4></head>");
        fragmentBuf.append("<body>");
        fragmentBuf.append(StringUtil.escapeXml((String)fragment).replace("\n", "<br>"));
        fragmentBuf.append("</body>");
        HTMLExportUtil.writeFile((String)outputDirectoryName, (String)codeFragmentFile, (CharSequence)XmlStringUtil.wrapInHtml((CharSequence)fragmentBuf), (Project)project);
        buffer.append("<a href=\"").append(StringUtil.escapeXml((String)codeFragmentFile)).append("\" target=\"elementFrame\">").append(virtualFile.getPath()).append("</a>").append("<br>");
    }

    private static void outputMainFrame(Project project, String outputDirectoryName) {
        StringBuffer mainIndex = new StringBuffer();
        mainIndex.append("<HTML><HEAD><TITLE>");
        mainIndex.append(ApplicationNamesInfo.getInstance().getFullProductName());
        mainIndex.append("Locate Duplicates result");
        mainIndex.append("</TITLE></HEAD>");
        mainIndex.append("<FRAMESET cols=\"30%,70%\">");
        mainIndex.append("  <FRAMESET rows=\"30%,70%\">");
        mainIndex.append("    <FRAME src=\"groupIndex.html\" name=\"groupFrame\">");
        mainIndex.append("    <FRAME src=\"group0-index.html\" name=\"codeFragmentFrame\">");
        mainIndex.append("  </FRAMESET>");
        mainIndex.append("  <FRAME src=\"empty.html\" name=\"elementFrame\">");
        mainIndex.append("</FRAMESET></BODY></HTML");
        HTMLExportUtil.writeFile((String)outputDirectoryName, (String)"index.html", (CharSequence)mainIndex, (Project)project);
        HTMLExportUtil.writeFile((String)outputDirectoryName, (String)"empty.html", (CharSequence)new StringBuffer(), (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dupLocator/resultUI/ExportHTMLAction", "actionPerformed"));
    }
}

