/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.DuplocatorSettingsEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JavaDuplocatorSettingsEditor
implements DuplocatorSettingsEditor {
    private JPanel mySensitivityPanel;
    private JCheckBox myDistinguishLocalVariables;
    private JCheckBox myDistinguishMethods;
    private JCheckBox myDistinguishFields;
    private JCheckBox myDistinguishTypes;
    private JCheckBox myDistinguishLiterals;
    private JCheckBox myCheckValidity;
    private JSpinner myDiscardCostSpinner;
    private JSpinner myLowBoundSpinner;

    public JavaDuplocatorSettingsEditor() {
        this.$$$setupUI$$$();
        DuplocatorSettings comp = DuplocatorSettings.getInstance();
        int lowerBound = Math.max(10, Math.min(100, comp.LOWER_BOUND));
        this.myLowBoundSpinner.setModel(new SpinnerNumberModel(lowerBound, 10, 100, 1));
        this.myDistinguishLocalVariables.setSelected(!comp.DISTINGUISH_VARIABLES);
        this.myDistinguishMethods.setSelected(!comp.DISTINGUISH_METHODS);
        this.myDistinguishFields.setSelected(!comp.DISTINGUISH_FIELDS);
        this.myDistinguishTypes.setSelected(!comp.DISTINGUISH_TYPES);
        this.myDistinguishLiterals.setSelected(!comp.DISTINGUISH_LITERALS);
        this.myCheckValidity.setSelected(comp.CHECK_VALIDITY);
        int max = 15;
        int value = comp.DISCARD_COST;
        if (value < 0) {
            value = 0;
        }
        if (value > max) {
            value = max;
        }
        this.myDiscardCostSpinner.setModel(new SpinnerNumberModel(value, 0, max, 1));
        this.myCheckValidity.setEnabled(comp.DISCARD_COST > 0);
        this.myDiscardCostSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                JavaDuplocatorSettingsEditor.this.validateComponent();
            }
        });
    }

    @Override
    public void apply() {
        DuplocatorSettings comp = DuplocatorSettings.getInstance();
        comp.DISTINGUISH_VARIABLES = !this.myDistinguishLocalVariables.isSelected();
        comp.DISTINGUISH_METHODS = !this.myDistinguishMethods.isSelected();
        comp.DISTINGUISH_FIELDS = !this.myDistinguishFields.isSelected();
        comp.DISTINGUISH_TYPES = !this.myDistinguishTypes.isSelected();
        comp.DISTINGUISH_LITERALS = !this.myDistinguishLiterals.isSelected();
        comp.DISCARD_COST = JavaDuplocatorSettingsEditor.getSpinnerValue(this.myDiscardCostSpinner);
        comp.CHECK_VALIDITY = this.myCheckValidity.isSelected();
        comp.LOWER_BOUND = JavaDuplocatorSettingsEditor.getSpinnerValue(this.myLowBoundSpinner);
    }

    private static int getSpinnerValue(JSpinner spinner) {
        return ((SpinnerNumberModel)spinner.getModel()).getNumber().intValue();
    }

    @Override
    public JComponent getComponent() {
        return this.mySensitivityPanel;
    }

    @Override
    public void validateComponent() {
        this.myCheckValidity.setEnabled(JavaDuplocatorSettingsEditor.getSpinnerValue(this.myDiscardCostSpinner) > 0);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JSpinner jSpinner;
        JCheckBox jCheckBox6;
        JSpinner jSpinner2;
        JPanel jPanel;
        this.mySensitivityPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 15, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDiscardCostSpinner = jSpinner2 = new JSpinner();
        jPanel2.add((Component)jSpinner2, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, new Dimension(50, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/DupLocatorBundle").getString("duplicate.anonymize.uncommon.description"));
        jPanel2.add((Component)jLabel, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/DupLocatorBundle").getString("duplication.anonymize.uncommon.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myCheckValidity = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/DupLocatorBundle").getString("duplicate.anonymize.uncommon.outside.scope.checkbox"));
        jPanel2.add((Component)jCheckBox6, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 2, 1, 0, 3, 0, 3, null, new Dimension(15, -1), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLowBoundSpinner = jSpinner = new JSpinner();
        jPanel2.add((Component)jSpinner, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, new Dimension(50, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/DupLocatorBundle").getString("duplication.minimum.cost.label"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 9, 3, 0, 0, null, null, null));
        this.myDistinguishLocalVariables = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/DupLocatorBundle").getString("duplication.anonymize.local.variables.checkbox"));
        jPanel4.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myDistinguishFields = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/DupLocatorBundle").getString("duplication.anonymize.fields.checkbox"));
        jPanel4.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myDistinguishMethods = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/DupLocatorBundle").getString("duplication.anonymize.methods.checkbox"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myDistinguishTypes = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/DupLocatorBundle").getString("duplication.anonymize.types.checkbox"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myDistinguishLiterals = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/DupLocatorBundle").getString("duplication.anonymize.literals.checkbox"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mySensitivityPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

