/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCaseWithNoTestMethodsInspection
extends BaseInspection {
    public boolean ignoreSupers = true;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("JUnitTestCaseWithNoTests" == null) {
            TestCaseWithNoTestMethodsInspection.$$$reportNull$$$0(0);
        }
        return "JUnitTestCaseWithNoTests";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.case.with.no.test.methods.display.name", new Object[0]);
        if (string == null) {
            TestCaseWithNoTestMethodsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("test.case.with.no.test.methods.problem.descriptor", new Object[0]);
        if (string == null) {
            TestCaseWithNoTestMethodsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("test.case.with.no.test.methods.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSupers");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestCaseWithNoTestMethodsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/TestCaseWithNoTestMethodsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class TestCaseWithNoTestMethodsVisitor
    extends BaseInspectionVisitor {
        private TestCaseWithNoTestMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                TestCaseWithNoTestMethodsVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType() || PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass) || aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            Set applicableFrameworks = TestFrameworks.detectApplicableFrameworks((PsiClass)aClass);
            if (applicableFrameworks.isEmpty()) {
                return;
            }
            Set<TestFramework> applicableToNestedClasses = applicableFrameworks.stream().filter(framework -> framework instanceof JavaTestFramework && ((JavaTestFramework)framework).acceptNestedClasses()).collect(Collectors.toSet());
            if (this.hasTestMethods(aClass, applicableFrameworks, applicableToNestedClasses, true)) {
                return;
            }
            if (TestCaseWithNoTestMethodsInspection.this.ignoreSupers) {
                PsiManager manager = aClass.getManager();
                for (PsiClass superClass = aClass.getSuperClass(); superClass != null && manager.isInProject((PsiElement)superClass); superClass = superClass.getSuperClass()) {
                    if (!this.hasTestMethods(superClass, applicableFrameworks, applicableToNestedClasses, false)) continue;
                    return;
                }
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private boolean hasTestMethods(@NotNull PsiClass aClass, Set<TestFramework> selfFrameworks, Set<TestFramework> nestedTestFrameworks, boolean checkSuite) {
            if (aClass == null) {
                TestCaseWithNoTestMethodsVisitor.$$$reportNull$$$0(1);
            }
            PsiMethod[] methods = aClass.getMethods();
            for (TestFramework framework : selfFrameworks) {
                if (checkSuite && framework instanceof JavaTestFramework && ((JavaTestFramework)framework).isSuiteClass(aClass)) {
                    return true;
                }
                if (!Arrays.stream(methods).anyMatch(method -> framework.isTestMethod((PsiElement)method, false))) continue;
                return true;
            }
            if (!nestedTestFrameworks.isEmpty()) {
                for (PsiClass innerClass : aClass.getInnerClasses()) {
                    if (innerClass.hasModifierProperty("static") || !this.hasTestMethods(innerClass, nestedTestFrameworks, nestedTestFrameworks, false)) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "aClass";
            objectArray2[1] = "com/siyeh/ig/junit/TestCaseWithNoTestMethodsInspection$TestCaseWithNoTestMethodsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasTestMethods";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

