/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodGroupingRule
extends SingleParentUsageGroupingRule {
    private static final Logger LOG = Logger.getInstance(MethodGroupingRule.class);
    @NotNull
    private final UsageViewSettings myUsageViewSettings;

    public MethodGroupingRule(@NotNull UsageViewSettings usageViewSettings) {
        if (usageViewSettings == null) {
            MethodGroupingRule.$$$reportNull$$$0(0);
        }
        this.myUsageViewSettings = usageViewSettings;
    }

    @Nullable
    protected UsageGroup getParentGroupFor(@NotNull Usage usage, @NotNull UsageTarget[] targets) {
        if (usage == null) {
            MethodGroupingRule.$$$reportNull$$$0(1);
        }
        if (targets == null) {
            MethodGroupingRule.$$$reportNull$$$0(2);
        }
        if (!(usage instanceof PsiElementUsage)) {
            return null;
        }
        PsiElement psiElement = ((PsiElementUsage)usage).getElement();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        PsiFile topLevelFile = manager.getTopLevelFile((PsiElement)containingFile);
        if (topLevelFile instanceof PsiJavaFile && !topLevelFile.getFileType().isBinary()) {
            PsiClass containingClass;
            PsiElement containingMethod;
            Object object = containingMethod = topLevelFile == containingFile ? psiElement : manager.getInjectionHost((PsiElement)containingFile);
            if (usage instanceof UsageInfo2UsageAdapter && topLevelFile == containingFile) {
                int offset = ((UsageInfo2UsageAdapter)usage).getUsageInfo().getNavigationOffset();
                containingMethod = containingFile.findElementAt(offset);
            }
            while ((containingMethod = PsiTreeUtil.getParentOfType((PsiElement)containingMethod, PsiMethod.class, (boolean)true)) != null && (containingClass = ((PsiMethod)containingMethod).getContainingClass()) != null && containingClass.getQualifiedName() == null) {
            }
            if (containingMethod != null) {
                return new MethodUsageGroup((PsiMethod)containingMethod, this.myUsageViewSettings);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
        }
        objectArray2[1] = "com/intellij/usages/impl/rules/MethodGroupingRule";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentGroupFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MethodUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final SmartPsiElementPointer<PsiMethod> myMethodPointer;
        private final String myName;
        private final Icon myIcon;
        private final Project myProject;
        @NotNull
        private final UsageViewSettings myUsageViewSettings;

        MethodUsageGroup(PsiMethod psiMethod, @NotNull UsageViewSettings usageViewSettings) {
            if (usageViewSettings == null) {
                MethodUsageGroup.$$$reportNull$$$0(0);
            }
            this.myName = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            this.myProject = psiMethod.getProject();
            this.myMethodPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)psiMethod);
            this.myIcon = MethodUsageGroup.getIconImpl(psiMethod);
            this.myUsageViewSettings = usageViewSettings;
        }

        public void update() {
        }

        private static Icon getIconImpl(PsiMethod psiMethod) {
            return psiMethod.getIcon(3);
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodUsageGroup)) {
                return false;
            }
            MethodUsageGroup group = (MethodUsageGroup)object;
            return Comparing.equal((String)this.myName, (String)((MethodUsageGroup)object).myName) && SmartPointerManager.getInstance((Project)this.myProject).pointToTheSameElement(this.myMethodPointer, group.myMethodPointer);
        }

        public Icon getIcon(boolean isOpen) {
            return this.myIcon;
        }

        private PsiMethod getMethod() {
            return (PsiMethod)this.myMethodPointer.getElement();
        }

        @NotNull
        public String getText(UsageView view) {
            String string = this.myName;
            if (string == null) {
                MethodUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        public FileStatus getFileStatus() {
            PsiFile file = this.myMethodPointer.getContainingFile();
            return file == null ? null : NavigationItemFileStatus.get((NavigationItem)file);
        }

        public boolean isValid() {
            PsiMethod method = this.getMethod();
            return method != null && method.isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            if (this.canNavigate()) {
                this.getMethod().navigate(focus);
            }
        }

        public boolean canNavigate() {
            return this.isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                MethodUsageGroup.$$$reportNull$$$0(2);
            }
            if (!(usageGroup instanceof MethodUsageGroup)) {
                LOG.error("MethodUsageGroup expected but " + usageGroup.getClass() + " found");
            }
            MethodUsageGroup other = (MethodUsageGroup)usageGroup;
            if (SmartPointerManager.getInstance((Project)this.myProject).pointToTheSameElement(this.myMethodPointer, other.myMethodPointer)) {
                return 0;
            }
            if (!this.myUsageViewSettings.isSortAlphabetically()) {
                Segment segment1 = this.myMethodPointer.getRange();
                Segment segment2 = other.myMethodPointer.getRange();
                if (segment1 != null && segment2 != null) {
                    return segment1.getStartOffset() - segment2.getStartOffset();
                }
            }
            return this.myName.compareToIgnoreCase(other.myName);
        }

        public void calcData(@NotNull DataKey key2, @NotNull DataSink sink) {
            PsiMethod method;
            if (key2 == null) {
                MethodUsageGroup.$$$reportNull$$$0(3);
            }
            if (sink == null) {
                MethodUsageGroup.$$$reportNull$$$0(4);
            }
            if (!this.isValid()) {
                return;
            }
            if (CommonDataKeys.PSI_ELEMENT == key2) {
                sink.put(CommonDataKeys.PSI_ELEMENT, (Object)this.getMethod());
            }
            if (UsageView.USAGE_INFO_KEY == key2 && (method = this.getMethod()) != null) {
                sink.put(UsageView.USAGE_INFO_KEY, (Object)new UsageInfo((PsiElement)method));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageViewSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/MethodGroupingRule$MethodUsageGroup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageGroup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/MethodGroupingRule$MethodUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "calcData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

