/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanonicalTypes {
    private CanonicalTypes() {
    }

    public static Type createTypeWrapper(@NotNull PsiType type2) {
        if (type2 == null) {
            CanonicalTypes.$$$reportNull$$$0(0);
        }
        return (Type)type2.accept((PsiTypeVisitor)Creator.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/refactoring/util/CanonicalTypes", "createTypeWrapper"));
    }

    private static class Creator
    extends PsiTypeVisitor<Type> {
        public static final Creator INSTANCE = new Creator();
        private static final Logger LOG = Logger.getInstance(Creator.class);

        private Creator() {
        }

        public Type visitPrimitiveType(PsiPrimitiveType type2) {
            return new Primitive(type2);
        }

        public Type visitEllipsisType(PsiEllipsisType type2) {
            return new Ellipsis((PsiType)type2, this.substituteComponents((PsiArrayType)type2));
        }

        public Type visitArrayType(PsiArrayType type2) {
            return new Array((PsiType)type2, this.substituteComponents(type2));
        }

        @NotNull
        private Type substituteComponents(PsiArrayType type2) {
            PsiType componentType = type2.getComponentType();
            Type substituted = (Type)componentType.accept((PsiTypeVisitor)this);
            LOG.assertTrue(substituted != null, (Object)componentType);
            Type type3 = substituted;
            if (type3 == null) {
                Creator.$$$reportNull$$$0(0);
            }
            return type3;
        }

        public Type visitWildcardType(PsiWildcardType type2) {
            PsiType bound = type2.getBound();
            return new WildcardType((PsiType)type2, type2.isExtends(), bound == null ? null : (Type)bound.accept((PsiTypeVisitor)this));
        }

        public Type visitClassType(PsiClassType type2) {
            PsiClassType.ClassResolveResult resolveResult = type2.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass instanceof PsiAnonymousClass) {
                return this.visitClassType(((PsiAnonymousClass)aClass).getBaseClassType());
            }
            if (aClass == null) {
                return new UnresolvedType((PsiType)type2);
            }
            HashMap substitutionMap = ContainerUtil.newHashMap();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                PsiType substitute = substitutor.substitute(typeParameter);
                substitutionMap.put(typeParameter.getName(), substitute != null ? (Type)substitute.accept((PsiTypeVisitor)this) : null);
            }
            String qualifiedName = (String)ObjectUtils.notNull((Object)aClass.getQualifiedName(), (Object)ObjectUtils.assertNotNull((Object)aClass.getName()));
            return new ClassType((PsiType)type2, qualifiedName, substitutionMap);
        }

        public Type visitDisjunctionType(PsiDisjunctionType type2) {
            List types = ContainerUtil.map((Collection)type2.getDisjunctions(), type1 -> (Type)type1.accept((PsiTypeVisitor)this));
            return new LogicalOperationType(types, true);
        }

        @Nullable
        public Type visitIntersectionType(PsiIntersectionType type2) {
            List types = ContainerUtil.map((Object[])type2.getConjuncts(), type1 -> (Type)type1.accept((PsiTypeVisitor)this));
            return new LogicalOperationType(types, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/CanonicalTypes$Creator", "substituteComponents"));
        }
    }

    private static class LogicalOperationType
    extends Type {
        private final List<Type> myTypes;
        private final boolean myDisjunction;

        private LogicalOperationType(List<Type> types, boolean disjunction) {
            this.myTypes = types;
            this.myDisjunction = disjunction;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            List types = ContainerUtil.map(this.myTypes, type2 -> type2.getType(context, manager));
            Object object = this.myDisjunction ? new PsiDisjunctionType(types, manager) : PsiIntersectionType.createIntersection((List)types);
            if (object == null) {
                LogicalOperationType.$$$reportNull$$$0(0);
            }
            return object;
        }

        @Override
        public String getTypeText() {
            return StringUtil.join(this.myTypes, type2 -> type2.getTypeText(), (String)(this.myDisjunction ? "|" : "&"));
        }

        @Override
        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            if (fragment == null) {
                LogicalOperationType.$$$reportNull$$$0(1);
            }
            for (Type type2 : this.myTypes) {
                type2.addImportsTo(fragment);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$LogicalOperationType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$LogicalOperationType";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ClassType
    extends AnnotatedType {
        private final String myPresentableText;
        private final String myClassQName;
        private final Map<String, Type> mySubstitutor;

        private ClassType(@NotNull PsiType original, @NotNull String classQName, @NotNull Map<String, Type> substitutor) {
            if (original == null) {
                ClassType.$$$reportNull$$$0(0);
            }
            if (classQName == null) {
                ClassType.$$$reportNull$$$0(1);
            }
            if (substitutor == null) {
                ClassType.$$$reportNull$$$0(2);
            }
            super(original.getAnnotationProvider());
            this.myPresentableText = original.getPresentableText();
            this.myClassQName = classQName;
            this.mySubstitutor = substitutor;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiElementFactory factory = facade.getElementFactory();
            PsiClass aClass = facade.getResolveHelper().resolveReferencedClass(this.myClassQName, context);
            if (aClass == null) {
                PsiType psiType = factory.createTypeFromText(this.myClassQName, context);
                if (psiType == null) {
                    ClassType.$$$reportNull$$$0(3);
                }
                return psiType;
            }
            HashMap substitutionMap = ContainerUtil.newHashMap();
            Iterator iterator = PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass).iterator();
            while (iterator.hasNext()) {
                PsiTypeParameter typeParameter;
                Type substitute = this.mySubstitutor.get((typeParameter = (PsiTypeParameter)iterator.next()).getName());
                substitutionMap.put(typeParameter, substitute != null ? substitute.getType(context, manager) : null);
            }
            PsiClassType psiClassType = factory.createType(aClass, factory.createSubstitutor((Map)substitutionMap), null).annotate(this.myProvider);
            if (psiClassType == null) {
                ClassType.$$$reportNull$$$0(4);
            }
            return psiClassType;
        }

        @Override
        public String getTypeText() {
            return this.myPresentableText;
        }

        @Override
        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            if (fragment == null) {
                ClassType.$$$reportNull$$$0(5);
            }
            fragment.addImportsFromString(this.myClassQName);
            for (Type type2 : this.mySubstitutor.values()) {
                if (type2 == null) continue;
                type2.addImportsTo(fragment);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classQName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$ClassType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$ClassType";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UnresolvedType
    extends Type {
        private final String myPresentableText;
        private final String myCanonicalText;

        private UnresolvedType(@NotNull PsiType original) {
            if (original == null) {
                UnresolvedType.$$$reportNull$$$0(0);
            }
            this.myPresentableText = original.getPresentableText();
            this.myCanonicalText = original.getCanonicalText(true);
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiType psiType = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createTypeFromText(this.myCanonicalText, context);
            if (psiType == null) {
                UnresolvedType.$$$reportNull$$$0(1);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return this.myPresentableText;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$UnresolvedType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$UnresolvedType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class WildcardType
    extends AnnotatedType {
        private final boolean myIsExtending;
        private final Type myBound;

        private WildcardType(@NotNull PsiType original, boolean isExtending, @Nullable Type bound) {
            if (original == null) {
                WildcardType.$$$reportNull$$$0(0);
            }
            super(original.getAnnotationProvider());
            this.myIsExtending = isExtending;
            this.myBound = bound;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiWildcardType type2 = this.myBound == null ? PsiWildcardType.createUnbounded((PsiManager)manager) : (this.myIsExtending ? PsiWildcardType.createExtends((PsiManager)manager, (PsiType)this.myBound.getType(context, manager)) : PsiWildcardType.createSuper((PsiManager)manager, (PsiType)this.myBound.getType(context, manager)));
            PsiType psiType = type2.annotate(this.myProvider);
            if (psiType == null) {
                WildcardType.$$$reportNull$$$0(1);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return this.myBound == null ? "?" : "? " + (this.myIsExtending ? "extends " : "super ") + this.myBound.getTypeText();
        }

        @Override
        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            if (fragment == null) {
                WildcardType.$$$reportNull$$$0(2);
            }
            if (this.myBound != null) {
                this.myBound.addImportsTo(fragment);
            }
        }

        @Override
        public boolean isValid() {
            return this.myBound == null || this.myBound.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$WildcardType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$WildcardType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Ellipsis
    extends Array {
        private Ellipsis(@NotNull PsiType original, @NotNull Type componentType) {
            if (original == null) {
                Ellipsis.$$$reportNull$$$0(0);
            }
            if (componentType == null) {
                Ellipsis.$$$reportNull$$$0(1);
            }
            super(original, componentType);
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiType psiType = new PsiEllipsisType(this.myComponentType.getType(context, manager)).annotate(this.myProvider);
            if (psiType == null) {
                Ellipsis.$$$reportNull$$$0(2);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return this.myComponentType.getTypeText() + "...";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$Ellipsis";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$Ellipsis";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Array
    extends AnnotatedType {
        final Type myComponentType;

        private Array(@NotNull PsiType original, @NotNull Type componentType) {
            if (original == null) {
                Array.$$$reportNull$$$0(0);
            }
            if (componentType == null) {
                Array.$$$reportNull$$$0(1);
            }
            super(original.getAnnotationProvider());
            this.myComponentType = componentType;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiType psiType = this.myComponentType.getType(context, manager).createArrayType().annotate(this.myProvider);
            if (psiType == null) {
                Array.$$$reportNull$$$0(2);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return this.myComponentType.getTypeText() + "[]";
        }

        @Override
        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            if (fragment == null) {
                Array.$$$reportNull$$$0(3);
            }
            this.myComponentType.addImportsTo(fragment);
        }

        @Override
        public boolean isValid() {
            return this.myComponentType.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$Array";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$Array";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Primitive
    extends AnnotatedType {
        private final PsiPrimitiveType myType;

        private Primitive(@NotNull PsiPrimitiveType type2) {
            if (type2 == null) {
                Primitive.$$$reportNull$$$0(0);
            }
            super(type2.getAnnotationProvider());
            this.myType = type2;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) {
            PsiPrimitiveType psiPrimitiveType = this.myType.annotate(this.myProvider);
            if (psiPrimitiveType == null) {
                Primitive.$$$reportNull$$$0(1);
            }
            return psiPrimitiveType;
        }

        @Override
        public String getTypeText() {
            return this.myType.getPresentableText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$Primitive";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$Primitive";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class AnnotatedType
    extends Type {
        protected final TypeAnnotationProvider myProvider;

        AnnotatedType(@NotNull TypeAnnotationProvider provider) {
            if (provider == null) {
                AnnotatedType.$$$reportNull$$$0(0);
            }
            PsiAnnotation[] annotations2 = (PsiAnnotation[])ContainerUtil.map((Object[])provider.getAnnotations(), annotation -> (PsiAnnotation)annotation.copy(), (Object[])PsiAnnotation.EMPTY_ARRAY);
            this.myProvider = TypeAnnotationProvider.Static.create((PsiAnnotation[])annotations2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/util/CanonicalTypes$AnnotatedType", "<init>"));
        }
    }

    public static abstract class Type {
        @NotNull
        public abstract PsiType getType(@Nullable PsiElement var1, PsiManager var2) throws IncorrectOperationException;

        @NotNull
        public PsiType getType(@NotNull PsiElement context) {
            if (context == null) {
                Type.$$$reportNull$$$0(0);
            }
            PsiType psiType = this.getType(context, context.getManager());
            if (psiType == null) {
                Type.$$$reportNull$$$0(1);
            }
            return psiType;
        }

        @NonNls
        public abstract String getTypeText();

        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            if (fragment == null) {
                Type.$$$reportNull$$$0(2);
            }
        }

        public boolean isValid() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$Type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$Type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

