/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.typeMigration.ClassTypeArgumentMigrationProcessor;
import com.intellij.refactoring.typeMigration.MigrateGetterNameSetting;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationReplacementUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.TypeMigrationStatementProcessor;
import com.intellij.refactoring.typeMigration.Util;
import com.intellij.refactoring.typeMigration.usageInfo.OverriddenUsageInfo;
import com.intellij.refactoring.typeMigration.usageInfo.OverriderUsageInfo;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeMigrationLabeler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.typeMigration.TypeMigrationLabeler");
    private boolean myShowWarning = true;
    private volatile MigrateException myException;
    private final Semaphore myDialogSemaphore = new Semaphore();
    private final Project myProject;
    private final TypeMigrationRules myRules;
    private final Function<PsiElement, PsiType> myMigrationRootTypeFunction;
    @Nullable
    private final Set<PsiElement> myAllowedRoots;
    private TypeEvaluator myTypeEvaluator;
    private final LinkedHashMap<PsiElement, Object> myConversions;
    private final Map<Pair<SmartPsiElementPointer<PsiExpression>, PsiType>, TypeMigrationUsageInfo> myFailedConversions;
    private LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> myMigrationRoots;
    private final LinkedHashMap<TypeMigrationUsageInfo, PsiType> myNewExpressionTypeChange;
    private final LinkedHashMap<TypeMigrationUsageInfo, PsiClassType> myClassTypeArgumentsChange;
    private TypeMigrationUsageInfo[] myMigratedUsages;
    private TypeMigrationUsageInfo myCurrentRoot;
    private final Map<TypeMigrationUsageInfo, HashSet<Pair<TypeMigrationUsageInfo, PsiType>>> myRootsTree = new HashMap<TypeMigrationUsageInfo, HashSet<Pair<TypeMigrationUsageInfo, PsiType>>>();
    private final Map<Pair<TypeMigrationUsageInfo, TypeMigrationUsageInfo>, Set<PsiElement>> myRootUsagesTree = new HashMap<Pair<TypeMigrationUsageInfo, TypeMigrationUsageInfo>, Set<PsiElement>>();
    private final Set<TypeMigrationUsageInfo> myProcessedRoots = new HashSet<TypeMigrationUsageInfo>();
    private final Set<PsiTypeParameter> myDisappearedTypeParameters = new HashSet<PsiTypeParameter>();

    public TypeMigrationRules getRules() {
        return this.myRules;
    }

    public TypeMigrationLabeler(TypeMigrationRules rules, PsiType rootType, Project project) {
        this(rules, (Function<PsiElement, PsiType>)Functions.constant((Object)rootType), null, project);
    }

    public TypeMigrationLabeler(TypeMigrationRules rules, Function<PsiElement, PsiType> migrationRootTypeFunction, @Nullable(value="any root accepted if null") PsiElement[] allowedRoots, Project project) {
        this.myRules = rules;
        this.myMigrationRootTypeFunction = migrationRootTypeFunction;
        this.myAllowedRoots = allowedRoots == null ? null : ContainerUtil.set((Object[])allowedRoots);
        this.myConversions = new LinkedHashMap();
        this.myFailedConversions = new LinkedHashMap<Pair<SmartPsiElementPointer<PsiExpression>, PsiType>, TypeMigrationUsageInfo>();
        this.myNewExpressionTypeChange = new LinkedHashMap();
        this.myClassTypeArgumentsChange = new LinkedHashMap();
        this.myProject = project;
    }

    public boolean hasFailedConversions() {
        return this.myFailedConversions.size() > 0;
    }

    public Function<PsiElement, PsiType> getMigrationRootTypeFunction() {
        return this.myMigrationRootTypeFunction;
    }

    public String[] getFailedConversionsReport() {
        String[] report = new String[this.myFailedConversions.size()];
        int j = 0;
        for (Pair<SmartPsiElementPointer<PsiExpression>, PsiType> p : this.myFailedConversions.keySet()) {
            PsiExpression element = (PsiExpression)((SmartPsiElementPointer)p.getFirst()).getElement();
            LOG.assertTrue(element != null);
            PsiType type2 = element.getType();
            report[j++] = "Cannot convert type of expression <b>" + StringUtil.escapeXml((String)element.getText()) + "</b>" + (type2 != null ? " from <b>" + StringUtil.escapeXml((String)type2.getCanonicalText()) + "</b> to <b>" + StringUtil.escapeXml((String)((PsiType)p.getSecond()).getCanonicalText()) + "</b>" : "") + "<br>";
        }
        return report;
    }

    public UsageInfo[] getFailedUsages(TypeMigrationUsageInfo root) {
        return TypeMigrationLabeler.map2Usages(ContainerUtil.mapNotNull(this.myFailedConversions.entrySet(), entry -> ((TypeMigrationUsageInfo)((Object)((Object)entry.getValue()))).equals((Object)root) ? (Pair)entry.getKey() : null));
    }

    public UsageInfo[] getFailedUsages() {
        return TypeMigrationLabeler.map2Usages(this.myFailedConversions.keySet());
    }

    @NotNull
    private static UsageInfo[] map2Usages(Collection<? extends Pair<SmartPsiElementPointer<PsiExpression>, PsiType>> usages) {
        UsageInfo[] usageInfoArray = (UsageInfo[])ContainerUtil.map2Array(usages, (Object[])new UsageInfo[usages.size()], pair -> {
            final PsiExpression expr = (PsiExpression)((SmartPsiElementPointer)pair.getFirst()).getElement();
            LOG.assertTrue(expr != null);
            return new UsageInfo((PsiElement)expr, (Pair)pair){
                final /* synthetic */ Pair val$pair;
                {
                    this.val$pair = pair;
                    super(arg0);
                }

                @Nullable
                public String getTooltipText() {
                    PsiType type2;
                    PsiType psiType = type2 = expr.isValid() ? expr.getType() : null;
                    if (type2 == null) {
                        return null;
                    }
                    return "Cannot convert type of the expression from " + type2.getCanonicalText() + " to " + ((PsiType)this.val$pair.getSecond()).getCanonicalText();
                }
            };
        });
        if (usageInfoArray == null) {
            TypeMigrationLabeler.$$$reportNull$$$0(0);
        }
        return usageInfoArray;
    }

    public TypeMigrationUsageInfo[] getMigratedUsages() {
        LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> declarations = this.getTypeEvaluator().getMigratedDeclarations();
        TypeMigrationUsageInfo[] usages = new TypeMigrationUsageInfo[declarations.size() + this.myConversions.size() + this.myNewExpressionTypeChange.size() + this.myClassTypeArgumentsChange.size()];
        int j = 0;
        for (final PsiElement psiElement : this.myConversions.keySet()) {
            final Object conv = this.myConversions.get(psiElement);
            usages[j++] = new TypeMigrationUsageInfo(psiElement){

                public String getTooltipText() {
                    if (conv instanceof String) {
                        String conversion = (String)conv;
                        return "Replaced with " + conversion.replaceAll("\\$", psiElement.getText());
                    }
                    return "Replaced with " + conv.toString();
                }

                @Override
                public boolean isExcluded() {
                    if (conv instanceof TypeConversionDescriptorBase) {
                        return ((TypeConversionDescriptorBase)conv).getRoot().isExcluded();
                    }
                    return super.isExcluded();
                }

                @Override
                public TypeMigrationUsageInfo getOwnerRoot() {
                    return conv instanceof TypeConversionDescriptorBase ? ((TypeConversionDescriptorBase)conv).getRoot() : null;
                }
            };
        }
        for (Pair pair : declarations) {
            TypeMigrationUsageInfo element = (TypeMigrationUsageInfo)((Object)pair.getFirst());
            usages[j++] = element;
        }
        for (TypeMigrationUsageInfo typeMigrationUsageInfo : this.myClassTypeArgumentsChange.keySet()) {
            usages[j++] = typeMigrationUsageInfo;
        }
        for (TypeMigrationUsageInfo typeMigrationUsageInfo : this.myNewExpressionTypeChange.keySet()) {
            usages[j++] = typeMigrationUsageInfo;
        }
        return this.sortMigratedUsages(usages);
    }

    private TypeMigrationUsageInfo[] sortMigratedUsages(TypeMigrationUsageInfo[] infos) {
        DFSTBuilder builder = new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)new InboundSemiGraph<TypeMigrationUsageInfo>(){

            @NotNull
            public Collection<TypeMigrationUsageInfo> getNodes() {
                HashSet<TypeMigrationUsageInfo> infos = new HashSet<TypeMigrationUsageInfo>();
                for (Map.Entry entry : TypeMigrationLabeler.this.myRootsTree.entrySet()) {
                    infos.add((TypeMigrationUsageInfo)((Object)entry.getKey()));
                    infos.addAll(ContainerUtil.map((Collection)((Collection)entry.getValue()), pair -> (TypeMigrationUsageInfo)((Object)((Object)pair.getFirst()))));
                }
                HashSet<TypeMigrationUsageInfo> hashSet = infos;
                if (hashSet == null) {
                    3.$$$reportNull$$$0(0);
                }
                return hashSet;
            }

            @NotNull
            public Iterator<TypeMigrationUsageInfo> getIn(TypeMigrationUsageInfo n) {
                HashSet rawNodes = (HashSet)TypeMigrationLabeler.this.myRootsTree.get((Object)n);
                if (rawNodes == null) {
                    Iterator<TypeMigrationUsageInfo> iterator = Collections.emptyList().iterator();
                    if (iterator == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return iterator;
                }
                List in = ContainerUtil.map((Collection)rawNodes, pair -> (TypeMigrationUsageInfo)((Object)((Object)pair.getFirst())));
                Iterator<TypeMigrationUsageInfo> iterator = in.iterator();
                if (iterator == null) {
                    3.$$$reportNull$$$0(2);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/refactoring/typeMigration/TypeMigrationLabeler$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
        Comparator cmp = builder.comparator();
        Arrays.sort(infos, (info1, info2) -> {
            TextRange range2;
            TypeMigrationUsageInfo i1 = info1.getOwnerRoot();
            TypeMigrationUsageInfo i2 = info2.getOwnerRoot();
            if (i1 == null && i2 == null) {
                return 0;
            }
            if (i1 == null) {
                return 1;
            }
            if (i2 == null) {
                return -1;
            }
            PsiElement element1 = info1.getElement();
            PsiElement element2 = info2.getElement();
            LOG.assertTrue(element1 != null && element2 != null);
            if (element1.equals(element2)) {
                return 0;
            }
            TextRange range1 = element1.getTextRange();
            if (range1.contains(range2 = element2.getTextRange())) {
                return 1;
            }
            if (range2.contains(range1)) {
                return -1;
            }
            int res = cmp.compare(i1, i2);
            if (res != 0) {
                return res;
            }
            return range2.getStartOffset() - range1.getStartOffset();
        });
        return infos;
    }

    MigrationProducer createMigratorFor(UsageInfo[] usages) {
        HashMap<UsageInfo, Object> conversions = new HashMap<UsageInfo, Object>();
        for (UsageInfo usage : usages) {
            Object conversion = this.getConversion(usage.getElement());
            if (conversion == null) continue;
            conversions.put(usage, conversion);
        }
        return new MigrationProducer(conversions);
    }

    @Nullable
    public <T> T getSettings(Class<T> aClass) {
        return this.myRules.getConversionSettings(aClass);
    }

    void postProcessNewExpression(@NotNull PsiNewExpression expression2) {
        if (expression2 == null) {
            TypeMigrationLabeler.$$$reportNull$$$0(1);
        }
        TypeMigrationReplacementUtil.tryToReplaceWithDiamond(expression2, null);
    }

    @Nullable
    Object getConversion(PsiElement element) {
        return this.myConversions.get(element);
    }

    public TypeMigrationUsageInfo[] getMigratedUsages(boolean autoMigrate, PsiElement ... roots) {
        if (this.myMigratedUsages == null) {
            this.myShowWarning = autoMigrate;
            this.migrate(autoMigrate, roots);
            this.myMigratedUsages = this.getMigratedUsages();
        }
        return this.myMigratedUsages;
    }

    @Nullable
    public Set<PsiElement> getTypeUsages(TypeMigrationUsageInfo element, TypeMigrationUsageInfo currentRoot) {
        return this.myRootUsagesTree.get(Pair.create((Object)((Object)element), (Object)((Object)currentRoot)));
    }

    void convertExpression(PsiExpression expr, PsiType toType, PsiType fromType, boolean isCovariantPosition) {
        TypeConversionDescriptorBase conversion = this.myRules.findConversion(fromType, toType, (PsiMember)(expr instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expr).resolveMethod() : null), expr, isCovariantPosition, this);
        if (conversion == null) {
            this.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)fromType, (Object)toType), expr);
        } else {
            this.setConversionMapping(expr, conversion);
        }
    }

    public void migrateExpressionType(PsiExpression expr, PsiType migrationType, PsiElement place, boolean alreadyProcessed, boolean isCovariant) {
        PsiType originalType = expr.getType();
        if (originalType == null || originalType.equals(migrationType)) {
            return;
        }
        if (originalType.equals(PsiType.NULL)) {
            if (migrationType instanceof PsiPrimitiveType) {
                this.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)originalType, (Object)migrationType), expr);
                return;
            }
            if (place instanceof PsiVariable) {
                PsiType type2 = ((PsiVariable)place).getType();
                if (((PsiVariable)place).getInitializer() == expr && this.myRules.shouldConvertNull(type2, migrationType, expr)) {
                    this.convertExpression(expr, migrationType, type2, isCovariant);
                }
            }
            return;
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiConditionalExpression condExpr = (PsiConditionalExpression)expr;
            for (PsiExpression e : ContainerUtil.newArrayList((Object[])new PsiExpression[]{condExpr.getThenExpression(), condExpr.getElseExpression()})) {
                if (e == null) continue;
                this.migrateExpressionType(e, migrationType, place, alreadyProcessed, false);
            }
            this.getTypeEvaluator().setType(new TypeMigrationUsageInfo((PsiElement)expr), migrationType);
            return;
        }
        if (expr instanceof PsiClassObjectAccessExpression) {
            if (!TypeConversionUtil.isAssignable((PsiType)migrationType, (PsiType)expr.getType())) {
                this.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)expr.getType(), (Object)migrationType), expr);
                return;
            }
        } else {
            if (expr instanceof PsiArrayInitializerExpression && migrationType instanceof PsiArrayType) {
                PsiExpression[] initializers;
                for (PsiExpression initializer : initializers = ((PsiArrayInitializerExpression)expr).getInitializers()) {
                    this.migrateExpressionType(initializer, ((PsiArrayType)migrationType).getComponentType(), (PsiElement)expr, alreadyProcessed, true);
                }
                this.getTypeEvaluator().setType(new TypeMigrationUsageInfo((PsiElement)expr), migrationType);
                return;
            }
            if (expr instanceof PsiArrayAccessExpression) {
                this.migrateExpressionType(((PsiArrayAccessExpression)expr).getArrayExpression(), (PsiType)migrationType.createArrayType(), place, alreadyProcessed, isCovariant);
                return;
            }
            if (expr instanceof PsiReferenceExpression) {
                PsiElement resolved = ((PsiReferenceExpression)expr).resolve();
                if (resolved != null && !this.addMigrationRoot(resolved, migrationType, place, alreadyProcessed, !isCovariant)) {
                    this.convertExpression(expr, migrationType, this.getTypeEvaluator().evaluateType(expr), isCovariant);
                }
                return;
            }
            if (expr instanceof PsiMethodCallExpression) {
                PsiMethod resolved = ((PsiMethodCallExpression)expr).resolveMethod();
                if (resolved != null && !this.addMigrationRoot((PsiElement)resolved, migrationType, place, alreadyProcessed, !isCovariant)) {
                    this.convertExpression(expr, migrationType, this.getTypeEvaluator().evaluateType(expr), isCovariant);
                }
                return;
            }
            if (expr instanceof PsiNewExpression) {
                if (originalType.getArrayDimensions() == migrationType.getArrayDimensions()) {
                    if (migrationType.getArrayDimensions() > 0) {
                        PsiType elementType = ((PsiArrayType)migrationType).getComponentType();
                        PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)expr).getArrayInitializer();
                        if (arrayInitializer != null) {
                            PsiExpression[] initializers = arrayInitializer.getInitializers();
                            for (int i = initializers.length - 1; i >= 0; --i) {
                                this.migrateExpressionType(initializers[i], elementType, place, alreadyProcessed, true);
                            }
                        }
                        if (TypeMigrationLabeler.isGenericsArrayType(elementType)) {
                            this.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)originalType, (Object)migrationType), expr);
                            return;
                        }
                        TypeMigrationUsageInfo usageInfo = new TypeMigrationUsageInfo((PsiElement)expr);
                        usageInfo.setOwnerRoot(this.myCurrentRoot);
                        this.myNewExpressionTypeChange.put(usageInfo, migrationType);
                        this.getTypeEvaluator().setType(new TypeMigrationUsageInfo((PsiElement)expr), migrationType);
                        return;
                    }
                    if (migrationType instanceof PsiClassType && originalType instanceof PsiClassType && ((PsiClassType)migrationType).rawType().isAssignableFrom((PsiType)((PsiClassType)originalType).rawType())) {
                        PsiType type3;
                        PsiClass originalClass = PsiUtil.resolveClassInType((PsiType)originalType);
                        if (originalClass instanceof PsiAnonymousClass) {
                            originalType = ((PsiAnonymousClass)originalClass).getBaseClassType();
                        }
                        if ((type3 = TypeEvaluator.substituteType(migrationType, originalType, true, ((PsiClassType)originalType).resolveGenerics().getElement(), (PsiType)JavaPsiFacade.getElementFactory((Project)expr.getProject()).createType(((PsiClassType)originalType).resolve(), PsiSubstitutor.EMPTY))) != null) {
                            TypeMigrationUsageInfo usageInfo = new TypeMigrationUsageInfo((PsiElement)expr);
                            usageInfo.setOwnerRoot(this.myCurrentRoot);
                            this.myNewExpressionTypeChange.put(usageInfo, type3);
                            this.getTypeEvaluator().setType(new TypeMigrationUsageInfo((PsiElement)expr), type3);
                            return;
                        }
                    }
                }
            } else if (expr instanceof PsiLambdaExpression) {
                return;
            }
        }
        this.convertExpression(expr, migrationType, originalType, isCovariant);
    }

    private static boolean isGenericsArrayType(PsiType elementType) {
        if (elementType instanceof PsiClassType && ((PsiClassType)elementType).hasParameters()) {
            return true;
        }
        if (elementType instanceof PsiArrayType) {
            PsiType componentType = ((PsiArrayType)elementType).getComponentType();
            return TypeMigrationLabeler.isGenericsArrayType(componentType);
        }
        return false;
    }

    boolean addMigrationRoot(PsiElement element, PsiType type2, PsiElement place, boolean alreadyProcessed, boolean isContraVariantPosition) {
        return this.addMigrationRoot(element, type2, place, alreadyProcessed, isContraVariantPosition, false);
    }

    boolean addMigrationRoot(PsiElement element, PsiType type2, PsiElement place, boolean alreadyProcessed, boolean isContraVariantPosition, boolean userDefinedType) {
        PsiMethod method;
        if (this.myAllowedRoots != null && !this.myAllowedRoots.contains(element)) {
            return false;
        }
        if (type2.equals(PsiType.NULL)) {
            return false;
        }
        PsiElement resolved = Util.normalizeElement(element);
        if (!TypeMigrationLabeler.canBeRoot(resolved, this.myRules.getSearchScope())) {
            return false;
        }
        PsiType originalType = TypeMigrationLabeler.getElementType(resolved);
        LOG.assertTrue(originalType != null);
        PsiType psiType = type2 = userDefinedType ? type2 : TypeEvaluator.substituteType(type2, originalType, isContraVariantPosition);
        if (userDefinedType) {
            Set<PsiTypeParameter> disappearedTypeParameters = TypeMigrationLabeler.getTypeParameters(originalType);
            disappearedTypeParameters.removeAll(TypeMigrationLabeler.getTypeParameters(type2));
            this.myDisappearedTypeParameters.addAll(disappearedTypeParameters);
        } else if (this.typeContainsTypeParameters(originalType, TypeMigrationLabeler.getTypeParameters(type2))) {
            return false;
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return false;
        }
        if (resolved instanceof PsiMethod) {
            PsiType expectedReturnType;
            PsiClass resolvedClass;
            PsiMethod superMethod;
            PsiType superReturnType;
            HierarchicalMethodSignature superSignature;
            PsiSubstitutor substitutor;
            HierarchicalMethodSignature signature;
            List superSignatures;
            method = (PsiMethod)resolved;
            PsiClass containingClass = method.getContainingClass();
            if (containingClass instanceof PsiAnonymousClass && !(superSignatures = (signature = method.getHierarchicalMethodSignature()).getSuperSignatures()).isEmpty() && !(substitutor = (superSignature = (HierarchicalMethodSignature)superSignatures.get(0)).getSubstitutor()).getSubstitutionMap().isEmpty() && (superReturnType = (superMethod = superSignature.getMethod()).getReturnType()) instanceof PsiClassType && (resolvedClass = ((PsiClassType)superReturnType).resolve()) instanceof PsiTypeParameter && Comparing.equal((Object)(expectedReturnType = substitutor.substitute((PsiTypeParameter)resolvedClass)), (Object)method.getReturnType())) {
                PsiClassType baseClassType = ((PsiAnonymousClass)containingClass).getBaseClassType();
                PsiClassType.ClassResolveResult result = baseClassType.resolveGenerics();
                PsiClass anonymousBaseClass = result.getElement();
                PsiSubstitutor superHierarchySubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)superMethod.getContainingClass(), (PsiClass)anonymousBaseClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                PsiType maybeTypeParameter = superHierarchySubstitutor.substitute((PsiTypeParameter)resolvedClass);
                if (maybeTypeParameter instanceof PsiClassType && ((PsiClassType)maybeTypeParameter).resolve() instanceof PsiTypeParameter) {
                    PsiSubstitutor newSubstitutor = result.getSubstitutor().put((PsiTypeParameter)((PsiClassType)maybeTypeParameter).resolve(), type2);
                    this.addRoot(new TypeMigrationUsageInfo((PsiElement)((PsiAnonymousClass)containingClass).getBaseClassReference().getParameterList()), (PsiType)new PsiImmediateClassType(anonymousBaseClass, newSubstitutor), place, alreadyProcessed);
                }
            }
            PsiMethod[] methods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY);
            OverriderUsageInfo[] overriders = new OverriderUsageInfo[methods.length];
            for (int i = -1; i < methods.length; ++i) {
                TypeMigrationUsageInfo m;
                if (i < 0) {
                    OverriddenUsageInfo overriddenUsageInfo;
                    m = overriddenUsageInfo = new OverriddenUsageInfo((PsiElement)method);
                    String newMethodName = this.isMethodNameCanBeChanged(method);
                    if (newMethodName != null) {
                        MigrateGetterNameSetting migrateGetterNameSetting = this.myRules.getConversionSettings(MigrateGetterNameSetting.class);
                        migrateGetterNameSetting.askUserIfNeed(overriddenUsageInfo, newMethodName, this.myTypeEvaluator.getType(this.myCurrentRoot));
                    }
                } else {
                    overriders[i] = new OverriderUsageInfo((PsiElement)methods[i], method);
                    m = overriders[i];
                }
                alreadyProcessed = this.addRoot(m, type2, place, alreadyProcessed);
            }
            return !alreadyProcessed;
        }
        if (resolved instanceof PsiParameter && ((PsiParameter)resolved).getDeclarationScope() instanceof PsiMethod) {
            method = (PsiMethod)((PsiParameter)resolved).getDeclarationScope();
            int index = method.getParameterList().getParameterIndex((PsiParameter)resolved);
            PsiMethod[] methods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY);
            OverriderUsageInfo[] overriders = new OverriderUsageInfo[methods.length];
            OverriddenUsageInfo overriddenUsageInfo = new OverriddenUsageInfo((PsiElement)method.getParameterList().getParameters()[index]);
            for (int i = -1; i < methods.length; ++i) {
                TypeMigrationUsageInfo paramUsageInfo;
                PsiMethod m = i < 0 ? method : methods[i];
                PsiParameter p = m.getParameterList().getParameters()[index];
                if (i < 0) {
                    paramUsageInfo = overriddenUsageInfo;
                } else {
                    overriders[i] = new OverriderUsageInfo((PsiElement)p, method);
                    paramUsageInfo = overriders[i];
                }
                alreadyProcessed = this.addRoot(paramUsageInfo, type2, place, alreadyProcessed);
            }
            return !alreadyProcessed;
        }
        return !this.addRoot(new TypeMigrationUsageInfo(resolved), type2, place, alreadyProcessed);
    }

    @NotNull
    private static Set<PsiTypeParameter> getTypeParameters(@NotNull PsiType type2) {
        if (type2 == null) {
            TypeMigrationLabeler.$$$reportNull$$$0(2);
        }
        if (type2 instanceof PsiClassType) {
            PsiTypesUtil.TypeParameterSearcher searcher = new PsiTypesUtil.TypeParameterSearcher();
            type2.accept((PsiTypeVisitor)searcher);
            Set set = searcher.getTypeParameters();
            if (set == null) {
                TypeMigrationLabeler.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<PsiTypeParameter> set = Collections.emptySet();
        if (set == null) {
            TypeMigrationLabeler.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Nullable
    private String isMethodNameCanBeChanged(PsiMethod method) {
        if (this.myCurrentRoot == null) {
            return null;
        }
        PsiElement root = this.myCurrentRoot.getElement();
        if (!(root instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)root;
        PsiType migrationType = this.myTypeEvaluator.getType(root);
        if (migrationType == null) {
            return null;
        }
        PsiType sourceType = field.getType();
        if (TypeConversionUtil.isAssignable((PsiType)migrationType, (PsiType)sourceType)) {
            return null;
        }
        if (!(migrationType.equals(PsiType.BOOLEAN) || migrationType.equals(PsiType.BOOLEAN.getBoxedType((PsiElement)field)) || sourceType.equals(PsiType.BOOLEAN) || sourceType.equals(PsiType.BOOLEAN.getBoxedType((PsiElement)field)))) {
            return null;
        }
        PsiMethod[] getters = GetterSetterPrototypeProvider.findGetters(field.getContainingClass(), field.getName(), field.hasModifierProperty("static"));
        if (getters != null) {
            for (PsiMethod getter : getters) {
                if (!getter.isEquivalentTo((PsiElement)method)) continue;
                String suggestedName = GenerateMembersUtil.suggestGetterName(field.getName(), migrationType, method.getProject());
                if (!suggestedName.equals(method.getName())) {
                    if (getter.getContainingClass().findMethodsByName(suggestedName, true).length != 0) {
                        return null;
                    }
                    return suggestedName;
                }
                return null;
            }
        }
        return null;
    }

    private boolean typeContainsTypeParameters(@Nullable PsiType type2, @NotNull Set<PsiTypeParameter> excluded) {
        if (excluded == null) {
            TypeMigrationLabeler.$$$reportNull$$$0(5);
        }
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiTypesUtil.TypeParameterSearcher searcher = new PsiTypesUtil.TypeParameterSearcher();
        type2.accept((PsiTypeVisitor)searcher);
        for (PsiTypeParameter parameter2 : searcher.getTypeParameters()) {
            if (excluded.contains(parameter2) || this.myDisappearedTypeParameters.contains(parameter2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiType getElementType(PsiElement resolved) {
        if (resolved instanceof PsiVariable) {
            return ((PsiVariable)resolved).getType();
        }
        if (resolved instanceof PsiMethod) {
            return ((PsiMethod)resolved).getReturnType();
        }
        if (resolved instanceof PsiExpression) {
            return ((PsiExpression)resolved).getType();
        }
        if (resolved instanceof PsiReferenceParameterList) {
            PsiElement parent = resolved.getParent();
            while (parent != null) {
                PsiSubstitutor classSubstitutor;
                LOG.assertTrue(parent instanceof PsiJavaCodeReferenceElement);
                PsiClass psiClass = (PsiClass)((PsiJavaCodeReferenceElement)parent).resolve();
                PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class);
                if (psiClass != null && containingClass != null && (classSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)psiClass, (PsiClass)containingClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)) != null) {
                    return JavaPsiFacade.getElementFactory((Project)parent.getProject()).createType(psiClass, classSubstitutor);
                }
                parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiJavaCodeReferenceElement.class, (boolean)true);
            }
        } else if (resolved instanceof PsiClass) {
            return JavaPsiFacade.getElementFactory((Project)resolved.getProject()).createType((PsiClass)resolved, PsiSubstitutor.EMPTY);
        }
        return null;
    }

    public void clearStopException() {
        this.myException = null;
    }

    boolean addRoot(TypeMigrationUsageInfo usageInfo, PsiType type2, PsiElement place, boolean alreadyProcessed) {
        if (this.myShowWarning && this.myMigrationRoots.size() > 10 && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.myShowWarning = false;
            this.myDialogSemaphore.down();
            try {
                Runnable checkTimeToStopRunnable = () -> {
                    if (Messages.showYesNoCancelDialog((String)"Found more than 10 roots to migrate. Do you want to preview?", (String)"Type Migration", (Icon)Messages.getWarningIcon()) == 0) {
                        this.myException = new MigrateException();
                    }
                    this.myDialogSemaphore.up();
                };
                SwingUtilities.invokeLater(checkTimeToStopRunnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.checkInterrupted();
        this.rememberRootTrace(usageInfo, type2, place, alreadyProcessed);
        if (!(alreadyProcessed || usageInfo.getElement() instanceof PsiExpression || this.getTypeEvaluator().setType(usageInfo, type2))) {
            alreadyProcessed = true;
        }
        if (!alreadyProcessed) {
            this.myMigrationRoots.addFirst((Pair<TypeMigrationUsageInfo, PsiType>)Pair.create((Object)((Object)usageInfo), (Object)type2));
        }
        return alreadyProcessed;
    }

    private void checkInterrupted() {
        if (this.myException != null) {
            throw this.myException;
        }
    }

    private void rememberRootTrace(TypeMigrationUsageInfo usageInfo, PsiType type2, PsiElement place, boolean alreadyProcessed) {
        if (this.myCurrentRoot != null) {
            if (!alreadyProcessed) {
                this.myProcessedRoots.add(usageInfo);
            }
            if (this.myProcessedRoots.contains((Object)usageInfo)) {
                HashSet<Object> infos = this.myRootsTree.get((Object)this.myCurrentRoot);
                if (infos == null) {
                    infos = new HashSet();
                    this.myRootsTree.put(this.myCurrentRoot, infos);
                }
                infos.add((Pair<TypeMigrationUsageInfo, PsiType>)Pair.create((Object)((Object)usageInfo), (Object)type2));
            }
            if (!(usageInfo instanceof OverriderUsageInfo)) {
                this.setTypeUsage(usageInfo, place);
            }
        }
    }

    private void setTypeUsage(TypeMigrationUsageInfo usageInfo, PsiElement place) {
        if (place != null) {
            Pair rooted = Pair.create((Object)((Object)usageInfo), (Object)((Object)this.myCurrentRoot));
            Set<PsiElement> usages = this.myRootUsagesTree.get(rooted);
            if (usages == null) {
                usages = new HashSet<PsiElement>();
                this.myRootUsagesTree.put((Pair<TypeMigrationUsageInfo, TypeMigrationUsageInfo>)rooted, usages);
            }
            usages.add(place);
        }
    }

    public void setTypeUsage(PsiElement element, PsiElement place) {
        this.setTypeUsage(new TypeMigrationUsageInfo(element), place);
    }

    void markFailedConversion(Pair<PsiType, PsiType> typePair, PsiExpression expression2) {
        LOG.assertTrue(typePair.getSecond() != null);
        Pair key2 = Pair.create((Object)SmartPointerManager.getInstance((Project)expression2.getProject()).createSmartPsiElementPointer((PsiElement)expression2), (Object)typePair.getSecond());
        if (!this.myFailedConversions.containsKey(key2)) {
            this.myFailedConversions.put((Pair<SmartPsiElementPointer<PsiExpression>, PsiType>)key2, this.getCurrentRoot());
        }
    }

    void setConversionMapping(PsiExpression expression2, Object obj) {
        if (this.myConversions.get(expression2) != null) {
            return;
        }
        if (obj instanceof TypeConversionDescriptorBase) {
            ((TypeConversionDescriptorBase)obj).setRoot(this.myCurrentRoot);
        }
        this.myConversions.put((PsiElement)expression2, obj);
    }

    public PsiReference[] markRootUsages(PsiElement element, PsiType migrationType) {
        return this.markRootUsages(element, migrationType, (PsiReference[])ReferencesSearch.search((PsiElement)element, (SearchScope)this.myRules.getSearchScope(), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY));
    }

    PsiReference[] markRootUsages(PsiElement element, PsiType migrationType, PsiReference[] refs) {
        ArrayList<PsiReference> validReferences = new ArrayList<PsiReference>();
        for (PsiReference ref1 : refs) {
            PsiElement ref = ref1.getElement();
            if (ref == null) continue;
            if (element instanceof PsiMethod) {
                PsiElement parent = Util.getEssentialParent(ref);
                if (!(parent instanceof PsiMethodCallExpression)) continue;
                this.getTypeEvaluator().setType(new TypeMigrationUsageInfo(parent), migrationType);
            } else if (element instanceof PsiVariable) {
                if (ref instanceof PsiReferenceExpression) {
                    this.getTypeEvaluator().setType(new TypeMigrationUsageInfo(ref), PsiUtil.captureToplevelWildcards((PsiType)migrationType, (PsiElement)ref));
                }
            } else {
                LOG.error("Method call expression or reference expression expected but found " + element.getClass().getName());
                continue;
            }
            validReferences.add(ref1);
        }
        Collections.sort(validReferences, Comparator.comparingInt(o -> o.getElement().getTextOffset()));
        return validReferences.toArray(PsiReference.EMPTY_ARRAY);
    }

    public void setRootAndMigrate(TypeMigrationUsageInfo newRootUsageInfo, PsiType migrationType, PsiReference[] usages) {
        TypeMigrationUsageInfo oldRoot = this.getCurrentRoot();
        this.myCurrentRoot = newRootUsageInfo;
        PsiElement root = newRootUsageInfo.getElement();
        if (root instanceof PsiMethod) {
            this.migrateMethodReturnExpression(migrationType, (PsiMethod)root);
        } else if (root instanceof PsiParameter && ((PsiParameter)root).getDeclarationScope() instanceof PsiMethod) {
            this.migrateMethodCallExpressions(migrationType, (PsiParameter)root, null);
        } else if (root instanceof PsiVariable || root instanceof PsiExpression) {
            PsiElement element = TypeMigrationLabeler.getContainingStatement(root);
            if (root instanceof PsiExpression) {
                this.migrateExpressionType((PsiExpression)root, migrationType, element, false, true);
                this.myTypeEvaluator.setType(newRootUsageInfo, migrationType);
            }
            element.accept((PsiElementVisitor)new TypeMigrationStatementProcessor(element, this));
        } else if (root instanceof PsiReferenceParameterList) {
            TypeMigrationUsageInfo info = new TypeMigrationUsageInfo(root);
            info.setOwnerRoot(oldRoot);
            this.myClassTypeArgumentsChange.put(info, (PsiClassType)migrationType);
            new ClassTypeArgumentMigrationProcessor(this).migrateClassTypeParameter((PsiReferenceParameterList)root, (PsiClassType)migrationType);
        }
        HashSet processed = new HashSet();
        for (PsiReference usage : usages) {
            this.migrateRootUsageExpression(usage, processed);
        }
    }

    private static PsiElement getContainingStatement(PsiElement root) {
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)root, PsiStatement.class);
        PsiExpression condition2 = TypeMigrationLabeler.getContainingCondition(root, statement);
        if (condition2 != null) {
            return condition2;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)root, PsiField.class);
        return statement != null ? statement : (field != null ? field : root);
    }

    private static PsiExpression getContainingCondition(PsiElement root, PsiStatement statement) {
        PsiExpression condition2 = null;
        if (statement instanceof PsiWhileStatement) {
            condition2 = ((PsiWhileStatement)statement).getCondition();
        } else if (statement instanceof PsiDoWhileStatement) {
            condition2 = ((PsiDoWhileStatement)statement).getCondition();
        } else if (statement instanceof PsiForStatement) {
            condition2 = ((PsiForStatement)statement).getCondition();
        } else if (statement instanceof PsiIfStatement) {
            condition2 = ((PsiIfStatement)statement).getCondition();
        }
        return PsiTreeUtil.isAncestor((PsiElement)condition2, (PsiElement)root, (boolean)false) ? condition2 : null;
    }

    void migrateRootUsageExpression(PsiReference usage, Set<? super PsiElement> processed) {
        PsiElement element;
        PsiElement ref = usage.getElement();
        if (ref != null && ref.getLanguage() == JavaLanguage.INSTANCE && (element = TypeMigrationLabeler.getContainingStatement(ref)) != null && !processed.contains(element)) {
            processed.add((PsiElement)element);
            element.accept((PsiElementVisitor)new TypeMigrationStatementProcessor(ref, this));
        }
    }

    void migrateMethodCallExpressions(PsiType migrationType, PsiParameter param, PsiClass psiClass) {
        boolean checkNumberOfArguments = false;
        if (param.getType() instanceof PsiEllipsisType && !(migrationType instanceof PsiEllipsisType)) {
            checkNumberOfArguments = true;
        }
        PsiType strippedType = migrationType instanceof PsiEllipsisType ? ((PsiEllipsisType)migrationType).getComponentType() : migrationType;
        PsiMethod method = (PsiMethod)param.getDeclarationScope();
        PsiParameterList parameterList = method.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        int index = parameterList.getParameterIndex(param);
        List<PsiReference> refs = TypeMigrationLabeler.filterReferences(psiClass, (Query<? extends PsiReference>)ReferencesSearch.search((PsiElement)method, (SearchScope)method.getUseScope().intersectWith(this.myRules.getSearchScope()), (boolean)false));
        for (PsiReference ref1 : refs) {
            PsiElement ref = ref1.getElement();
            PsiElement parent = Util.getEssentialParent(ref);
            if (parent instanceof PsiCallExpression) {
                PsiExpressionList argumentList = ((PsiCallExpression)parent).getArgumentList();
                if (argumentList == null) continue;
                PsiExpression[] expressions2 = argumentList.getExpressions();
                if (checkNumberOfArguments && parametersCount != expressions2.length) {
                    this.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)param.getType(), (Object)migrationType), (PsiExpression)((PsiCallExpression)parent));
                }
                if (index <= -1 || index >= expressions2.length) continue;
                for (int idx = index; idx < (param.isVarArgs() ? expressions2.length : index + 1); ++idx) {
                    PsiExpression actual = expressions2[idx];
                    PsiType type2 = this.getTypeEvaluator().evaluateType(actual);
                    if (type2 == null) continue;
                    this.migrateExpressionType(actual, strippedType, parent, TypeConversionUtil.isAssignable((PsiType)strippedType, (PsiType)type2), true);
                }
                continue;
            }
            if (!(ref instanceof PsiDocTagValue)) continue;
            this.myConversions.put(ref, method);
        }
    }

    private void migrateMethodReturnExpression(final PsiType migrationType, PsiMethod method) {
        PsiCodeBlock block = method.getBody();
        if (block != null) {
            block.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReturnStatement(PsiReturnStatement statement) {
                    PsiType type2;
                    PsiExpression value2 = statement.getReturnValue();
                    if (value2 != null && (type2 = TypeMigrationLabeler.this.getTypeEvaluator().evaluateType(value2)) != null && !type2.equals(migrationType)) {
                        TypeMigrationLabeler.this.migrateExpressionType(value2, migrationType, (PsiElement)statement, TypeConversionUtil.isAssignable((PsiType)migrationType, (PsiType)type2), true);
                    }
                }

                public void visitClass(PsiClass aClass) {
                }

                public void visitLambdaExpression(PsiLambdaExpression expression2) {
                }
            });
        }
    }

    private void iterate() {
        ArrayList<Pair<TypeMigrationUsageInfo, PsiType>> roots = new ArrayList<Pair<TypeMigrationUsageInfo, PsiType>>(this.myMigrationRoots);
        this.myMigrationRoots = new LinkedList();
        PsiReference[][] cachedUsages = new PsiReference[roots.size()][];
        int j = 0;
        for (Pair pair : roots) {
            cachedUsages[j++] = this.markRootUsages(((TypeMigrationUsageInfo)((Object)pair.getFirst())).getElement(), (PsiType)pair.getSecond());
        }
        j = 0;
        for (Pair pair : roots) {
            this.setRootAndMigrate((TypeMigrationUsageInfo)((Object)pair.getFirst()), (PsiType)pair.getSecond(), cachedUsages[j++]);
        }
    }

    private void migrate(boolean autoMigrate, PsiElement ... victims) {
        this.myMigrationRoots = new LinkedList();
        this.myTypeEvaluator = new TypeEvaluator(this.myMigrationRoots, this, this.myProject);
        SmartTypePointerManager smartTypePointerManager = SmartTypePointerManager.getInstance((Project)this.myProject);
        for (PsiElement victim : victims) {
            PsiType migrationType = smartTypePointerManager.createSmartTypePointer((PsiType)this.myMigrationRootTypeFunction.fun((Object)victim)).getType();
            this.addMigrationRoot(victim, migrationType, null, false, true, true);
        }
        if (autoMigrate) {
            while (this.myMigrationRoots.size() > 0) {
                this.iterate();
            }
        }
        this.myDialogSemaphore.waitFor();
        this.checkInterrupted();
    }

    @NotNull
    private PsiReference[] findReferences(PsiElement element) {
        PsiReference[] psiReferenceArray = (PsiReference[])ReferencesSearch.search((PsiElement)element, (SearchScope)this.myRules.getSearchScope(), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            TypeMigrationLabeler.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    public TypeEvaluator getTypeEvaluator() {
        return this.myTypeEvaluator;
    }

    public Map<TypeMigrationUsageInfo, HashSet<Pair<TypeMigrationUsageInfo, PsiType>>> getRootsTree() {
        return this.myRootsTree;
    }

    TypeMigrationUsageInfo getCurrentRoot() {
        return this.myCurrentRoot;
    }

    public LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> getMigrationRoots() {
        return this.myMigrationRoots;
    }

    public static List<PsiReference> filterReferences(PsiClass psiClass, Query<? extends PsiReference> memberReferences) {
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        for (PsiReference memberReference : memberReferences) {
            if (psiClass == null) {
                refs.add(memberReference);
                continue;
            }
            PsiElement referencedElement = memberReference.getElement();
            if (!(referencedElement instanceof PsiReferenceExpression)) continue;
            PsiExpression qualifierExpression2 = ((PsiReferenceExpression)referencedElement).getQualifierExpression();
            if (qualifierExpression2 != null) {
                PsiType qualifierType = qualifierExpression2.getType();
                if (!(qualifierType instanceof PsiClassType) || psiClass != ((PsiClassType)qualifierType).resolve()) continue;
                refs.add(memberReference);
                continue;
            }
            if (psiClass != PsiTreeUtil.getParentOfType((PsiElement)referencedElement, PsiClass.class)) continue;
            refs.add(memberReference);
        }
        return refs;
    }

    private static boolean canBeRoot(@Nullable PsiElement element, @NotNull SearchScope migrationScope) {
        if (migrationScope == null) {
            TypeMigrationLabeler.$$$reportNull$$$0(7);
        }
        if (element == null) {
            return false;
        }
        return element.isValid() && element.isPhysical() && PsiSearchScopeUtil.isInScope((SearchScope)migrationScope, (PsiElement)element);
    }

    public String getMigrationReport() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Types:\n").append(this.getTypeEvaluator().getReport()).append("\n");
        buffer.append("Conversions:\n");
        Object[] conversions = new String[this.myConversions.size()];
        int k = 0;
        for (PsiElement expr : this.myConversions.keySet()) {
            Object conversion = this.myConversions.get(expr);
            if (conversion instanceof Pair && ((Pair)conversion).first == null) {
                conversions[k++] = expr.getText() + " -> " + ((Pair)conversion).second + "\n";
                continue;
            }
            conversions[k++] = expr.getText() + " -> " + conversion + "\n";
        }
        Arrays.sort(conversions);
        for (Object conversion : conversions) {
            buffer.append((String)conversion);
        }
        buffer.append("\nNew expression type changes:\n");
        Object[] newChanges = new String[this.myNewExpressionTypeChange.size()];
        k = 0;
        for (Map.Entry<TypeMigrationUsageInfo, PsiType> entry : this.myNewExpressionTypeChange.entrySet()) {
            PsiElement element = entry.getKey().getElement();
            newChanges[k++] = (element != null ? element.getText() : entry.getKey()) + " -> " + entry.getValue().getCanonicalText() + "\n";
        }
        Arrays.sort(newChanges);
        for (Object change : newChanges) {
            buffer.append((String)change);
        }
        buffer.append("Fails:\n");
        ArrayList<Pair<SmartPsiElementPointer<PsiExpression>, PsiType>> failsList = new ArrayList<Pair<SmartPsiElementPointer<PsiExpression>, PsiType>>(this.myFailedConversions.keySet());
        Collections.sort(failsList, (o1, o2) -> {
            PsiElement element1 = ((SmartPsiElementPointer)o1.getFirst()).getElement();
            PsiElement element2 = ((SmartPsiElementPointer)o2.getFirst()).getElement();
            if (element1 == null || element2 == null) {
                return 0;
            }
            return element1.getText().compareTo(element2.getText());
        });
        for (Pair<SmartPsiElementPointer<PsiExpression>, PsiType> p : failsList) {
            PsiElement element = ((SmartPsiElementPointer)p.getFirst()).getElement();
            if (element == null) continue;
            buffer.append(element.getText()).append("->").append(((PsiType)p.getSecond()).getCanonicalText()).append("\n");
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/TypeMigrationLabeler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excluded";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Usages";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/TypeMigrationLabeler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "postProcessNewExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "typeContainsTypeParameters";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBeRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MigrateException
    extends RuntimeException {
    }

    class MigrationProducer {
        private final Map<UsageInfo, Object> myRemainConversions;
        private final MultiMap<PsiTypeElement, TypeMigrationUsageInfo> myVariableMigration = new MultiMap<PsiTypeElement, TypeMigrationUsageInfo>(){

            @NotNull
            protected Map<PsiTypeElement, Collection<TypeMigrationUsageInfo>> createMap() {
                THashMap tHashMap = new THashMap();
                if (tHashMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return tHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/TypeMigrationLabeler$MigrationProducer$1", "createMap"));
            }
        };

        private MigrationProducer(Map<UsageInfo, Object> conversions) {
            this.myRemainConversions = conversions;
        }

        public void change(@NotNull TypeMigrationUsageInfo usageInfo, @NotNull Consumer<? super PsiNewExpression> consumer) {
            PsiElement element;
            if (usageInfo == null) {
                MigrationProducer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MigrationProducer.$$$reportNull$$$0(1);
            }
            if ((element = usageInfo.getElement()) == null) {
                return;
            }
            Project project = element.getProject();
            if (element instanceof PsiExpression) {
                Object conversion;
                PsiExpression expression2 = (PsiExpression)element;
                if (element instanceof PsiNewExpression) {
                    for (Map.Entry<TypeMigrationUsageInfo, PsiType> entry : TypeMigrationLabeler.this.myNewExpressionTypeChange.entrySet()) {
                        PsiNewExpression newExpression;
                        PsiElement expressionToReplace = ((TypeMigrationUsageInfo)((Object)entry.getKey())).getElement();
                        if (!expression2.equals(expressionToReplace) || (newExpression = TypeMigrationReplacementUtil.replaceNewExpressionType(project, (PsiNewExpression)expressionToReplace, entry)) == null) continue;
                        consumer.consume((Object)newExpression);
                    }
                }
                if ((conversion = this.myRemainConversions.get((Object)usageInfo)) != null) {
                    this.myRemainConversions.remove((Object)usageInfo);
                    TypeMigrationReplacementUtil.replaceExpression(expression2, project, conversion, TypeMigrationLabeler.this.myTypeEvaluator);
                }
            } else if (element instanceof PsiReferenceParameterList) {
                for (Map.Entry entry : TypeMigrationLabeler.this.myClassTypeArgumentsChange.entrySet()) {
                    if (!element.equals(((TypeMigrationUsageInfo)((Object)entry.getKey())).getElement())) continue;
                    PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)project);
                    try {
                        element.getParent().replace((PsiElement)psiElementFactory.createReferenceElementByType((PsiClassType)entry.getValue()));
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            } else if ((element instanceof PsiField || element instanceof PsiLocalVariable) && this.isMultiVariableDeclaration((PsiVariable)element)) {
                PsiTypeElement typeElement = ((PsiVariable)element).getTypeElement();
                this.myVariableMigration.putValue((Object)typeElement, (Object)usageInfo);
            } else {
                String migrationName;
                TypeMigrationReplacementUtil.migrateMemberOrVariableType(element, project, TypeMigrationLabeler.this.getTypeEvaluator().getType(usageInfo));
                if (usageInfo instanceof OverriddenUsageInfo && (migrationName = ((OverriddenUsageInfo)usageInfo).getMigrateMethodName()) != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (element.isValid()) {
                            new RenameProcessor(project, element, migrationName, false, false).run();
                        }
                    });
                }
            }
        }

        public void flush() {
            for (Map.Entry entry : this.myVariableMigration.entrySet()) {
                PsiTypeElement typeElement = (PsiTypeElement)entry.getKey();
                if (!typeElement.isValid()) continue;
                Collection migrations = (Collection)entry.getValue();
                if (migrations.size() != 1) {
                    MultiMap variablesByMigrationType = new MultiMap();
                    for (TypeMigrationUsageInfo migration : migrations) {
                        PsiElement var = migration.getElement();
                        if (!(var instanceof PsiLocalVariable) && !(var instanceof PsiField)) continue;
                        PsiType type2 = TypeMigrationLabeler.this.getTypeEvaluator().getType(migration);
                        variablesByMigrationType.putValue((Object)type2, (Object)((PsiVariable)var));
                    }
                    if (variablesByMigrationType.size() == 1) {
                        Map.Entry migrationTypeAndVariables = (Map.Entry)ContainerUtil.getFirstItem((Collection)variablesByMigrationType.entrySet());
                        LOG.assertTrue(migrationTypeAndVariables != null);
                        PsiVariable[] variables = (PsiVariable[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement.getParent().getParent(), PsiVariable.class);
                        if (variables != null && variables.length == ((Collection)migrationTypeAndVariables.getValue()).size()) {
                            try {
                                PsiType migrationType = (PsiType)migrationTypeAndVariables.getKey();
                                Project project = variables[0].getProject();
                                migrationType = TypeMigrationReplacementUtil.revalidateType(migrationType, project);
                                typeElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createTypeElement(migrationType));
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                            continue;
                        }
                    }
                }
                for (TypeMigrationUsageInfo info : (Collection)entry.getValue()) {
                    this.migrateMultiDeclarationVariable(info);
                }
            }
        }

        private void migrateMultiDeclarationVariable(TypeMigrationUsageInfo varUsageInfo) {
            PsiElement var = varUsageInfo.getElement();
            if (!(var instanceof PsiLocalVariable) && !(var instanceof PsiField)) {
                return;
            }
            ((PsiVariable)var).normalizeDeclaration();
            TypeMigrationReplacementUtil.migrateMemberOrVariableType(var, var.getProject(), TypeMigrationLabeler.this.getTypeEvaluator().getType(varUsageInfo));
        }

        Object getConversion(UsageInfo info) {
            return this.myRemainConversions.remove(info);
        }

        private boolean isMultiVariableDeclaration(PsiVariable variable) {
            PsiElement parent = variable.getParent();
            LOG.assertTrue(parent != null);
            PsiVariable[] variables = (PsiVariable[])PsiTreeUtil.getChildrenOfType((PsiElement)parent, PsiVariable.class);
            LOG.assertTrue(variables != null);
            return variables.length != 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "usageInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/typeMigration/TypeMigrationLabeler$MigrationProducer";
            objectArray[2] = "change";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

