/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.refactoring.migration.PredefinedMigrationProvider;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrationMapSet {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.migration.MigrationMapSet");
    private ArrayList<MigrationMap> myMaps;
    @NonNls
    private static final String MIGRATION_MAP = "migrationMap";
    @NonNls
    private static final String ENTRY = "entry";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String OLD_NAME = "oldName";
    @NonNls
    private static final String NEW_NAME = "newName";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String TYPE = "type";
    @NonNls
    private static final String PACKAGE_TYPE = "package";
    @NonNls
    private static final String CLASS_TYPE = "class";
    @NonNls
    private static final String RECURSIVE = "recursive";
    @NonNls
    private static final String[] DEFAULT_MAPS = new String[]{"/com/intellij/refactoring/migration/res/Swing__1_0_3____1_1_.xml"};
    private final Set<String> myDeletedMaps = new TreeSet<String>();

    public void addMap(MigrationMap map2) {
        if (this.myMaps == null) {
            this.loadMaps();
        }
        this.myMaps.add(map2);
    }

    @Nullable
    public MigrationMap findMigrationMap(@NotNull String name) {
        if (name == null) {
            MigrationMapSet.$$$reportNull$$$0(0);
        }
        if (this.myMaps == null) {
            this.loadMaps();
        }
        for (MigrationMap map2 : this.myMaps) {
            if (!name.equals(map2.getName())) continue;
            return map2;
        }
        return null;
    }

    public void replaceMap(MigrationMap oldMap, MigrationMap newMap) {
        for (int i = 0; i < this.myMaps.size(); ++i) {
            if (this.myMaps.get(i) != oldMap) continue;
            this.myMaps.set(i, newMap);
        }
    }

    public void removeMap(MigrationMap map2) {
        if (this.myMaps == null) {
            this.loadMaps();
        }
        this.myMaps.remove(map2);
        String name = map2.getFileName();
        if (MigrationMapSet.isPredefined(name)) {
            this.myDeletedMaps.add(name);
        }
    }

    private static boolean isPredefined(String name) {
        for (PredefinedMigrationProvider provider : PredefinedMigrationProvider.EP_NAME.getExtensionList()) {
            URL migrationMap = provider.getMigrationMap();
            String fileName = FileUtil.getNameWithoutExtension((File)new File(migrationMap.getFile()));
            if (!fileName.equals(name)) continue;
            return true;
        }
        for (String defaultTemplate : DEFAULT_MAPS) {
            String fileName = FileUtil.getNameWithoutExtension((String)StringUtil.getShortName((String)defaultTemplate, (char)'/'));
            if (!fileName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public MigrationMap[] getMaps() {
        if (this.myMaps == null) {
            this.loadMaps();
        }
        MigrationMap[] ret = new MigrationMap[this.myMaps.size()];
        for (int i = 0; i < this.myMaps.size(); ++i) {
            ret[i] = this.myMaps.get(i);
        }
        return ret;
    }

    private static File getMapDirectory() {
        File dir = new File(PathManager.getConfigPath() + File.separator + "migration");
        if (!dir.exists() && !dir.mkdirs()) {
            LOG.error("cannot create directory: " + dir.getAbsolutePath());
            return null;
        }
        return dir;
    }

    private void copyPredefinedMaps(File dir) {
        File deletedFiles = new File(dir, "deleted.txt");
        if (deletedFiles.isFile()) {
            try {
                this.myDeletedMaps.addAll(Arrays.asList(FileUtil.loadFile((File)deletedFiles, (boolean)true).split("\n")));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        for (PredefinedMigrationProvider provider : PredefinedMigrationProvider.EP_NAME.getExtensionList()) {
            URL migrationMap = provider.getMigrationMap();
            String fileName = new File(migrationMap.getFile()).getName();
            if (this.myDeletedMaps.contains(FileUtil.getNameWithoutExtension((String)fileName))) continue;
            MigrationMapSet.copyMap(dir, migrationMap, fileName);
        }
        for (String defaultTemplate : DEFAULT_MAPS) {
            URL url = MigrationMapSet.class.getResource(defaultTemplate);
            LOG.assertTrue(url != null);
            String fileName = defaultTemplate.substring(defaultTemplate.lastIndexOf("/") + 1);
            if (this.myDeletedMaps.contains(FileUtil.getNameWithoutExtension((String)fileName))) continue;
            MigrationMapSet.copyMap(dir, url, fileName);
        }
    }

    private static void copyMap(File dir, URL url, String fileName) {
        File targetFile = new File(dir, fileName);
        if (targetFile.isFile()) {
            return;
        }
        try (FileOutputStream outputStream = new FileOutputStream(targetFile);
             InputStream inputStream = url.openStream();){
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static File[] getMapFiles(File dir) {
        if (dir == null) {
            return new File[0];
        }
        File[] ret = dir.listFiles(FileFilters.filesWithExtension((String)"xml"));
        if (ret == null) {
            LOG.error("cannot read directory: " + dir.getAbsolutePath());
            return new File[0];
        }
        return ret;
    }

    private void loadMaps() {
        File[] files;
        this.myMaps = new ArrayList();
        File dir = MigrationMapSet.getMapDirectory();
        this.copyPredefinedMaps(dir);
        for (File file : files = MigrationMapSet.getMapFiles(dir)) {
            try {
                MigrationMap map2 = MigrationMapSet.readMap(file);
                if (map2 == null) continue;
                map2.setFileName(FileUtil.getNameWithoutExtension((File)file));
                this.myMaps.add(map2);
            }
            catch (InvalidDataException | JDOMException e) {
                LOG.error("Invalid data in file: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static MigrationMap readMap(File file) throws JDOMException, InvalidDataException, IOException {
        if (!file.exists()) {
            return null;
        }
        Element root = JDOMUtil.load((File)file);
        if (!MIGRATION_MAP.equals(root.getName())) {
            throw new InvalidDataException();
        }
        MigrationMap map2 = new MigrationMap();
        for (Element node : root.getChildren()) {
            if (NAME.equals(node.getName())) {
                String name = node.getAttributeValue(VALUE);
                map2.setName(name);
            }
            if (DESCRIPTION.equals(node.getName())) {
                String description = node.getAttributeValue(VALUE);
                map2.setDescription(description);
            }
            if (!ENTRY.equals(node.getName())) continue;
            MigrationMapEntry entry = new MigrationMapEntry();
            String oldName = node.getAttributeValue(OLD_NAME);
            if (oldName == null) {
                throw new InvalidDataException();
            }
            entry.setOldName(oldName);
            String newName = node.getAttributeValue(NEW_NAME);
            if (newName == null) {
                throw new InvalidDataException();
            }
            entry.setNewName(newName);
            String typeStr = node.getAttributeValue(TYPE);
            if (typeStr == null) {
                throw new InvalidDataException();
            }
            entry.setType(1);
            if (typeStr.equals(PACKAGE_TYPE)) {
                entry.setType(0);
                String isRecursiveStr = node.getAttributeValue(RECURSIVE);
                if (isRecursiveStr != null && isRecursiveStr.equals("true")) {
                    entry.setRecursive(true);
                } else {
                    entry.setRecursive(false);
                }
            }
            map2.addEntry(entry);
        }
        return map2;
    }

    public void saveMaps() throws IOException {
        File dir = MigrationMapSet.getMapDirectory();
        if (dir == null) {
            return;
        }
        File[] files = MigrationMapSet.getMapFiles(dir);
        String[] filePaths = new String[this.myMaps.size()];
        Document[] documents = new Document[this.myMaps.size()];
        UniqueNameGenerator namesProvider = new UniqueNameGenerator();
        for (int i = 0; i < this.myMaps.size(); ++i) {
            MigrationMap map2 = this.myMaps.get(i);
            filePaths[i] = dir + File.separator + namesProvider.generateUniqueName(map2.getFileName()) + ".xml";
            documents[i] = MigrationMapSet.saveMap(map2);
        }
        JDOMUtil.updateFileSet((File[])files, (String[])filePaths, (Document[])documents, (String)CodeStyle.getDefaultSettings().getLineSeparator());
        if (!this.myDeletedMaps.isEmpty()) {
            FileUtil.writeToFile((File)new File(dir, "deleted.txt"), (String)StringUtil.join(this.myDeletedMaps, (String)"\n"));
        }
    }

    private static Document saveMap(MigrationMap map2) {
        Element root = new Element(MIGRATION_MAP);
        Element nameElement = new Element(NAME);
        nameElement.setAttribute(VALUE, map2.getName());
        root.addContent(nameElement);
        Element descriptionElement = new Element(DESCRIPTION);
        descriptionElement.setAttribute(VALUE, map2.getDescription());
        root.addContent(descriptionElement);
        for (int i = 0; i < map2.getEntryCount(); ++i) {
            MigrationMapEntry entry = map2.getEntryAt(i);
            Element element = new Element(ENTRY);
            element.setAttribute(OLD_NAME, entry.getOldName());
            element.setAttribute(NEW_NAME, entry.getNewName());
            if (entry.getType() == 0) {
                element.setAttribute(TYPE, PACKAGE_TYPE);
                element.setAttribute(RECURSIVE, Boolean.valueOf(entry.isRecursive()).toString());
            } else {
                element.setAttribute(TYPE, CLASS_TYPE);
            }
            root.addContent(element);
        }
        return new Document(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/refactoring/migration/MigrationMapSet", "findMigrationMap"));
    }
}

