/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.refactoring.extractMethod.preview.PreviewTreeListener;
import com.intellij.refactoring.extractMethod.preview.PreviewTreeModel;
import com.intellij.refactoring.extractMethod.preview.PreviewTreeRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreviewTree
implements Disposable {
    private final Project myProject;
    private final Tree myTree;
    private final List<PreviewTreeListener> myTreeListeners = new SmartList();
    private final PreviewTreeModel myModel;

    PreviewTree(ExtractMethodProcessor processor) {
        this.myProject = processor.getProject();
        this.myModel = new PreviewTreeModel(processor);
        this.myTree = this.createTree(this.myModel);
        this.myTree.setPaintBusy(true);
    }

    private Tree createTree(DefaultTreeModel model) {
        Tree tree = new Tree((TreeModel)model);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setCellRenderer((TreeCellRenderer)((Object)new PreviewTreeRenderer()));
        tree.setName("ExtractMethodPreview");
        tree.getSelectionModel().addTreeSelectionListener(e -> ApplicationManager.getApplication().invokeLater(() -> this.onSelectionUpdate()));
        SmartExpander.installOn((JTree)tree);
        TreeUtil.installActions((JTree)tree);
        TreeUtil.expand((JTree)tree, (int)2);
        TreeUtil.selectFirstNode((JTree)tree);
        PopupHandler.installPopupHandler((JComponent)tree, (String)"ExtractMethodToolWindow.TreePopup", (String)"unknown");
        return tree;
    }

    public void addTreeListener(PreviewTreeListener listener) {
        this.myTreeListeners.add(listener);
    }

    void onSelectionUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        FragmentNode firstSelectedNode = this.getFirstSelectedNode();
        if (firstSelectedNode != null) {
            for (PreviewTreeListener listener : this.myTreeListeners) {
                listener.onNodeSelected(firstSelectedNode);
            }
        }
    }

    @NotNull
    public List<FragmentNode> getSelectedNodes() {
        Object[] selectionPaths = this.myTree.getSelectionPaths();
        if (ArrayUtil.isEmpty((Object[])selectionPaths)) {
            List<FragmentNode> list = Collections.emptyList();
            if (list == null) {
                PreviewTree.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<FragmentNode> result = new ArrayList<FragmentNode>();
        for (Object path : selectionPaths) {
            result.addAll(PreviewTree.getFragmentNodes((TreePath)path));
        }
        ArrayList<FragmentNode> arrayList = result;
        if (arrayList == null) {
            PreviewTree.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    private FragmentNode getFirstSelectedNode() {
        Object[] selectionPaths = this.myTree.getSelectionPaths();
        if (ArrayUtil.isEmpty((Object[])selectionPaths)) {
            return null;
        }
        for (Object path : selectionPaths) {
            List<FragmentNode> nodes = PreviewTree.getFragmentNodes((TreePath)path);
            if (nodes.isEmpty()) continue;
            return nodes.get(0);
        }
        return null;
    }

    @NotNull
    private static List<FragmentNode> getFragmentNodes(@NotNull TreePath path) {
        Object component;
        if (path == null) {
            PreviewTree.$$$reportNull$$$0(2);
        }
        if ((component = path.getLastPathComponent()) instanceof FragmentNode) {
            List<FragmentNode> list = Collections.singletonList((FragmentNode)component);
            if (list == null) {
                PreviewTree.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (component instanceof TreeNode) {
            TreeNode node = (TreeNode)component;
            List list = IntStreamEx.range((int)0, (int)node.getChildCount()).mapToObj(node::getChildAt).select(FragmentNode.class).toList();
            if (list == null) {
                PreviewTree.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<FragmentNode> list = Collections.emptyList();
        if (list == null) {
            PreviewTree.$$$reportNull$$$0(5);
        }
        return list;
    }

    public PreviewTreeModel getModel() {
        return this.myModel;
    }

    public JComponent getComponent() {
        return this.myTree;
    }

    public void repaint() {
        this.myTree.repaint();
    }

    void onUpdateLater() {
        this.myTree.setPaintBusy(false);
        this.onSelectionUpdate();
    }

    void selectNode(FragmentNode node) {
        this.myTree.setSelectionPath(new TreePath(node.getPath()));
    }

    public boolean isValid() {
        return this.myModel.isValid();
    }

    public void setValid(boolean valid) {
        this.myModel.setValid(valid);
        this.repaint();
    }

    public void dispose() {
        this.myTreeListeners.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/preview/PreviewTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/preview/PreviewTree";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragmentNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

