/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.jvm.actions.ActionRequest;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00028\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/java/actions/CreateTargetAction;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "target", "request", "Lcom/intellij/lang/jvm/actions/ActionRequest;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/lang/jvm/actions/ActionRequest;)V", "myTargetPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getRequest", "()Lcom/intellij/lang/jvm/actions/ActionRequest;", "getTarget", "()Lcom/intellij/psi/PsiElement;", "getElementToMakeWritable", "currentFile", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "startInWriteAction", "intellij.java.impl"})
public abstract class CreateTargetAction<T extends PsiElement>
implements IntentionAction {
    private final SmartPsiElementPointer<T> myTargetPointer;
    @NotNull
    private final ActionRequest request;

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.myTargetPointer.getElement() != null && this.getRequest().isValid();
    }

    @NotNull
    protected final T getTarget() {
        PsiElement psiElement = this.myTargetPointer.getElement();
        if (psiElement == null) {
            String string = "Don't access this property if isAvailable() returned false";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (T)psiElement;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkParameterIsNotNull((Object)currentFile, (String)"currentFile");
        return this.getTarget();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    protected ActionRequest getRequest() {
        return this.request;
    }

    public CreateTargetAction(@NotNull T target, @NotNull ActionRequest request) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        this.request = request;
        this.myTargetPointer = PointersKt.createSmartPointer$default(target, null, 1, null);
    }
}

