/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PackageViewLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PackageViewProjectNode
extends AbstractProjectNode {
    public PackageViewProjectNode(@NotNull Project project, ViewSettings viewSettings) {
        if (project == null) {
            PackageViewProjectNode.$$$reportNull$$$0(0);
        }
        super(project, project, viewSettings);
    }

    public boolean canRepresent(Object element) {
        Project project = (Project)this.getValue();
        if (project == element) {
            return true;
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            element = directory.getVirtualFile();
        }
        if (element instanceof VirtualFile) {
            ProjectRootManager manager;
            ProjectRootManager projectRootManager = manager = project == null || project.isDisposed() ? null : ProjectRootManager.getInstance((Project)project);
            if (manager != null) {
                for (VirtualFile root : manager.getContentSourceRoots()) {
                    if (!element.equals(root)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        if (this.getSettings().isShowModules()) {
            ArrayList<LoadedModuleDescriptionImpl> modulesWithSourceRoots = new ArrayList<LoadedModuleDescriptionImpl>();
            for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                if (ModuleRootManager.getInstance((Module)module).getSourceRoots().length <= 0) continue;
                modulesWithSourceRoots.add(new LoadedModuleDescriptionImpl(module));
            }
            Collection collection = this.modulesAndGroups(modulesWithSourceRoots);
            if (collection == null) {
                PackageViewProjectNode.$$$reportNull$$$0(1);
            }
            return collection;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        HashSet<PsiPackage> topLevelPackages = new HashSet<PsiPackage>();
        for (VirtualFile root : projectRootManager.getContentSourceRoots()) {
            PsiDirectory directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage directoryPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (directoryPackage == null || PackageUtil.isPackageDefault(directoryPackage)) {
                PsiDirectory[] subdirectories;
                for (PsiDirectory subdirectory : subdirectories = directory.getSubdirectories()) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                    if (aPackage == null || PackageUtil.isPackageDefault(aPackage)) continue;
                    topLevelPackages.add(aPackage);
                }
                children.addAll(ProjectViewDirectoryHelper.getInstance((Project)this.myProject).getDirectoryChildren(directory, this.getSettings(), false));
                continue;
            }
            topLevelPackages.add(directoryPackage);
        }
        for (PsiPackage psiPackage : topLevelPackages) {
            PackageUtil.addPackageAsChild(children, psiPackage, null, this.getSettings(), false);
        }
        if (this.getSettings().isShowLibraryContents()) {
            children.add((AbstractTreeNode)new PackageViewLibrariesNode(this.getProject(), null, this.getSettings()));
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            PackageViewProjectNode.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    protected AbstractTreeNode createModuleGroup(@NotNull Module module) {
        if (module == null) {
            PackageViewProjectNode.$$$reportNull$$$0(3);
        }
        PackageViewModuleNode packageViewModuleNode = new PackageViewModuleNode(this.getProject(), module, this.getSettings());
        if (packageViewModuleNode == null) {
            PackageViewProjectNode.$$$reportNull$$$0(4);
        }
        return packageViewModuleNode;
    }

    @NotNull
    protected AbstractTreeNode createModuleGroupNode(@NotNull ModuleGroup moduleGroup) {
        if (moduleGroup == null) {
            PackageViewProjectNode.$$$reportNull$$$0(5);
        }
        PackageViewModuleGroupNode packageViewModuleGroupNode = new PackageViewModuleGroupNode(this.getProject(), moduleGroup, this.getSettings());
        if (packageViewModuleGroupNode == null) {
            PackageViewProjectNode.$$$reportNull$$$0(6);
        }
        return packageViewModuleGroupNode;
    }

    public boolean someChildContainsFile(VirtualFile file) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/PackageViewProjectNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/PackageViewProjectNode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleGroup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleGroupNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createModuleGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createModuleGroupNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

