/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.RootsProvider;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageElement
implements Queryable,
RootsProvider {
    public static final DataKey<PackageElement> DATA_KEY = DataKey.create((String)"package.element");
    @Nullable
    private final Module myModule;
    @NotNull
    private final PsiPackage myElement;
    private final boolean myIsLibraryElement;

    public PackageElement(@Nullable Module module, @NotNull PsiPackage element, boolean isLibraryElement) {
        if (element == null) {
            PackageElement.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myElement = element;
        this.myIsLibraryElement = isLibraryElement;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public PsiPackage getPackage() {
        PsiPackage psiPackage = this.myElement;
        if (psiPackage == null) {
            PackageElement.$$$reportNull$$$0(1);
        }
        return psiPackage;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        PsiDirectory[] dirs;
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        for (PsiDirectory each : dirs = PackageUtil.getDirectories(this.getPackage(), this.myModule, this.isLibraryElement())) {
            roots.add(each.getVirtualFile());
        }
        HashSet<VirtualFile> hashSet = roots;
        if (hashSet == null) {
            PackageElement.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageElement)) {
            return false;
        }
        PackageElement packageElement = (PackageElement)o;
        if (this.myIsLibraryElement != packageElement.myIsLibraryElement) {
            return false;
        }
        if (!this.myElement.equals(packageElement.myElement)) {
            return false;
        }
        return !(this.myModule != null ? !this.myModule.equals(packageElement.myModule) : packageElement.myModule != null);
    }

    public int hashCode() {
        int result = this.myModule != null ? this.myModule.hashCode() : 0;
        result = 29 * result + this.myElement.hashCode();
        result = 29 * result + (this.myIsLibraryElement ? 1 : 0);
        return result;
    }

    public boolean isLibraryElement() {
        return this.myIsLibraryElement;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        PsiPackage pkg;
        if (info == null) {
            PackageElement.$$$reportNull$$$0(3);
        }
        if ((pkg = this.getPackage()) instanceof Queryable) {
            ((Queryable)pkg).putInfo(info);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/PackageElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/PackageElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

