/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class FindThrowUsagesDialog
extends JavaFindUsagesDialog<JavaThrowFindUsagesOptions> {
    private StateRestoringCheckBox myCbUsages;
    private JComboBox myCbExns;
    private boolean myHasFindWhatPanel;
    private ThrowSearchUtil.Root[] myRoots;

    public FindThrowUsagesDialog(@NotNull PsiElement element, @NotNull Project project, @NotNull JavaThrowFindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, @NotNull FindUsagesHandler handler) {
        if (element == null) {
            FindThrowUsagesDialog.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FindThrowUsagesDialog.$$$reportNull$$$0(1);
        }
        if (findUsagesOptions == null) {
            FindThrowUsagesDialog.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            FindThrowUsagesDialog.$$$reportNull$$$0(3);
        }
        super(element, project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    @Override
    protected void init() {
        this.myRoots = ThrowSearchUtil.getSearchRoots(this.myPsiElement);
        super.init();
    }

    public JComponent getPreferredFocusedControl() {
        return this.myHasFindWhatPanel ? this.myCbUsages : null;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.anchor = 13;
        this.myCbExns = new JComboBox<ThrowSearchUtil.Root>(this.myRoots);
        panel.add((Component)this.myCbExns, gbConstraints);
        return panel;
    }

    @Override
    public void calcFindUsagesOptions(JavaThrowFindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        options.isUsages = FindThrowUsagesDialog.isSelected((JCheckBox)this.myCbUsages) || !this.myHasFindWhatPanel;
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message((String)"find.what.group", (Object[])new Object[0]), (boolean)true));
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        this.myCbUsages = this.addCheckboxToPanel(FindBundle.message((String)"find.what.usages.checkbox", (Object[])new Object[0]), this.myFindUsagesOptions.isUsages, findWhatPanel, true);
        this.myHasFindWhatPanel = true;
        return findWhatPanel;
    }

    @Override
    protected void doOKAction() {
        ((JavaThrowFindUsagesOptions)((Object)this.getFindUsagesOptions())).setRoot((ThrowSearchUtil.Root)this.myCbExns.getSelectedItem());
        super.doOKAction();
    }

    protected void update() {
        if (!this.myHasFindWhatPanel) {
            this.setOKActionEnabled(true);
        } else {
            ((JavaThrowFindUsagesOptions)((Object)this.getFindUsagesOptions())).setRoot((ThrowSearchUtil.Root)this.myCbExns.getSelectedItem());
            boolean hasSelected = FindThrowUsagesDialog.isSelected((JCheckBox)this.myCbUsages);
            this.setOKActionEnabled(hasSelected);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "findUsagesOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "handler";
                break;
            }
        }
        objectArray[1] = "com/intellij/find/findUsages/FindThrowUsagesDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

