/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.ex.ClassPatternsPanel;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;

@State(name="EntryPointsManager")
public class EntryPointsManagerImpl
extends EntryPointsManagerBase
implements PersistentStateComponent<Element> {
    public EntryPointsManagerImpl(Project project) {
        super(project);
    }

    public void configureAnnotations() {
        final ArrayList<String> list = new ArrayList<String>((Collection<String>)this.ADDITIONAL_ANNOTATIONS);
        final ArrayList<String> writeList = new ArrayList<String>(this.myWriteAnnotations);
        final JPanel listPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl(list, "Mark as entry point if annotated by", true);
        Condition applicableToField = psiClass -> {
            Set annotationTargets = AnnotationTargetUtil.getAnnotationTargets((PsiClass)psiClass);
            return annotationTargets != null && annotationTargets.contains(PsiAnnotation.TargetType.FIELD);
        };
        final JPanel writtenAnnotationsPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl(writeList, "Mark field as implicitly written if annotated by", false, (Condition<? super PsiClass>)applicableToField);
        new DialogWrapper(this.myProject){
            {
                super(arg0);
                this.init();
                this.setTitle("Configure Annotations");
            }

            protected JComponent createCenterPanel() {
                JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
                panel.add(listPanel);
                panel.add(writtenAnnotationsPanel);
                return panel;
            }

            protected void doOKAction() {
                EntryPointsManagerImpl.this.ADDITIONAL_ANNOTATIONS.clear();
                EntryPointsManagerImpl.this.ADDITIONAL_ANNOTATIONS.addAll((Collection)list);
                EntryPointsManagerImpl.this.myWriteAnnotations.clear();
                EntryPointsManagerImpl.this.myWriteAnnotations.addAll(writeList);
                DaemonCodeAnalyzer.getInstance((Project)EntryPointsManagerImpl.this.myProject).restart();
                super.doOKAction();
            }
        }.show();
    }

    public static JButton createConfigureAnnotationsButton() {
        final JButton configureAnnotations = new JButton("Annotations...");
        configureAnnotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryPointsManagerBase.getInstance(ProjectUtil.guessCurrentProject((JComponent)configureAnnotations)).configureAnnotations();
            }
        });
        return configureAnnotations;
    }

    public static JButton createConfigureClassPatternsButton() {
        final JButton configureClassPatterns = new JButton("Code patterns...");
        configureClassPatterns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final Project project = ProjectUtil.guessCurrentProject((JComponent)configureClassPatterns);
                final EntryPointsManagerBase entryPointsManagerBase = EntryPointsManagerBase.getInstance(project);
                final ArrayList<EntryPointsManagerBase.ClassPattern> list = new ArrayList<EntryPointsManagerBase.ClassPattern>();
                for (EntryPointsManagerBase.ClassPattern pattern : entryPointsManagerBase.getPatterns()) {
                    list.add(new EntryPointsManagerBase.ClassPattern(pattern));
                }
                final ClassPatternsPanel panel = new ClassPatternsPanel(list);
                new DialogWrapper(entryPointsManagerBase.myProject){
                    {
                        super(arg0);
                        this.init();
                        this.setTitle("Configure Code Patterns");
                    }

                    protected JComponent createCenterPanel() {
                        return panel;
                    }

                    protected void doOKAction() {
                        String error = panel.getValidationError(project);
                        if (error != null) {
                            Messages.showErrorDialog((Component)panel, (String)error);
                            return;
                        }
                        LinkedHashSet<EntryPointsManagerBase.ClassPattern> patterns = entryPointsManagerBase.getPatterns();
                        patterns.clear();
                        patterns.addAll(list);
                        DaemonCodeAnalyzer.getInstance((Project)entryPointsManagerBase.myProject).restart();
                        super.doOKAction();
                    }
                }.show();
            }
        });
        return configureClassPatterns;
    }
}

