/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableSource;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.LongStream;
import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaExpressionFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory");
    private static final Condition<String> FALSE_GETTERS = DfaExpressionFactory.parseFalseGetters();
    private final DfaValueFactory myFactory;
    private final Map<Integer, ArrayElementSource> myMockIndices = ContainerUtil.newHashMap();

    private static Condition<String> parseFalseGetters() {
        try {
            String regex = Registry.stringValue((String)"ide.dfa.getters.with.side.effects").trim();
            if (!StringUtil.isEmpty((String)regex)) {
                Pattern pattern = Pattern.compile(regex);
                return s -> pattern.matcher((CharSequence)s).matches();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return Conditions.alwaysFalse();
    }

    DfaExpressionFactory(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    @Nullable
    public DfaValue getExpressionDfaValue(@Nullable PsiExpression expression2) {
        PsiType type2;
        DfaVariableValue qualifier;
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            return this.getExpressionDfaValue(((PsiParenthesizedExpression)expression2).getExpression());
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            DfaValue arrayElementValue;
            Object index;
            PsiExpression arrayExpression = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            qualifier = this.getQualifierVariable(arrayExpression);
            if (qualifier != null && (index = ExpressionUtils.computeConstantExpression(((PsiArrayAccessExpression)expression2).getIndexExpression())) instanceof Integer && (arrayElementValue = this.getArrayElementValue((DfaValue)qualifier, (Integer)index)) != null) {
                return arrayElementValue;
            }
            PsiType type3 = expression2.getType();
            if (type3 != null) {
                return this.myFactory.createTypeValue(type3, DfaPsiUtil.getElementNullability(type3, null));
            }
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return this.createReferenceValue(((PsiMethodCallExpression)expression2).getMethodExpression());
        }
        if (expression2 instanceof PsiReferenceExpression) {
            return this.createReferenceValue((PsiReferenceExpression)expression2);
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return this.myFactory.createLiteralValue((PsiLiteralExpression)expression2);
        }
        if (expression2 instanceof PsiNewExpression || expression2 instanceof PsiLambdaExpression) {
            return this.myFactory.createTypeValue(expression2.getType(), Nullability.NOT_NULL);
        }
        Object value2 = JavaConstantExpressionEvaluator.computeConstantExpression(expression2, false);
        if (value2 != null && (type2 = expression2.getType()) != null) {
            return this.myFactory.getConstFactory().createFromValue(value2, type2);
        }
        if (expression2 instanceof PsiThisExpression || expression2 instanceof PsiSuperExpression) {
            qualifier = ((PsiQualifiedExpression)expression2).getQualifier();
            PsiClass target = qualifier != null ? (PsiClass)ObjectUtils.tryCast((Object)qualifier.resolve(), PsiClass.class) : ClassUtils.getContainingClass((PsiElement)expression2);
            return target == null ? this.myFactory.createTypeValue(expression2.getType(), Nullability.NOT_NULL) : this.myFactory.getVarFactory().createThisValue(target);
        }
        return null;
    }

    private DfaValue createReferenceValue(@NotNull PsiReferenceExpression refExpr) {
        DfaValue constValue;
        boolean isVolatile;
        DfaValue specialValue;
        if (refExpr == null) {
            DfaExpressionFactory.$$$reportNull$$$0(0);
        }
        if ((specialValue = this.createFromSpecialField(refExpr)) != null) {
            return specialValue;
        }
        DfaVariableSource var = DfaExpressionFactory.getAccessedVariableOrGetter(refExpr.resolve());
        if (var == null) {
            return null;
        }
        PsiModifierListOwner psiElement = var.getPsiElement();
        boolean bl = isVolatile = psiElement != null && psiElement.hasModifierProperty("volatile");
        if (isVolatile) {
            PsiType type2 = refExpr.getType();
            return this.myFactory.createTypeValue(type2, DfaPsiUtil.getElementNullability(type2, psiElement));
        }
        if (psiElement instanceof PsiVariable && ((PsiVariable)psiElement).getType().equalsToText("java.lang.Void")) {
            return this.myFactory.getConstFactory().getNull();
        }
        if (psiElement instanceof PsiVariable && psiElement.hasModifierProperty("final") && !PsiUtil.isAccessedForWriting((PsiExpression)refExpr) && (constValue = this.myFactory.getConstFactory().create((PsiVariable)psiElement)) != null && !DfaExpressionFactory.maybeUninitializedConstant(constValue, refExpr, psiElement)) {
            return constValue;
        }
        if (psiElement instanceof PsiLocalVariable || psiElement instanceof PsiParameter || psiElement instanceof PsiField && psiElement.hasModifierProperty("static") && !psiElement.hasModifierProperty("final") || DfaExpressionFactory.isStaticFinalConstantWithoutInitializationHacks(psiElement) || psiElement instanceof PsiMethod && psiElement.hasModifierProperty("static")) {
            return this.myFactory.getVarFactory().createVariableValue(var, refExpr.getType());
        }
        DfaVariableValue qualifier = this.getQualifierOrThisVariable(refExpr);
        if (qualifier != null) {
            return this.myFactory.getVarFactory().createVariableValue(var, refExpr.getType(), qualifier);
        }
        PsiType type3 = refExpr.getType();
        return this.myFactory.createTypeValue(type3, DfaPsiUtil.getElementNullability(type3, psiElement));
    }

    @Nullable
    public DfaVariableValue getQualifierOrThisVariable(PsiReferenceExpression refExpr) {
        PsiElement element;
        PsiExpression qualifierExpression2 = refExpr.getQualifierExpression();
        if (qualifierExpression2 == null && (element = refExpr.resolve()) instanceof PsiMember && !((PsiMember)element).hasModifierProperty("static")) {
            PsiClass currentClass = ClassUtils.getContainingClass((PsiElement)refExpr);
            PsiClass memberClass = ((PsiMember)element).getContainingClass();
            if (memberClass != null && currentClass != null) {
                PsiClass target = currentClass == memberClass || InheritanceUtil.isInheritorOrSelf((PsiClass)currentClass, (PsiClass)memberClass, (boolean)true) ? currentClass : memberClass;
                return this.myFactory.getVarFactory().createThisValue(target);
            }
        }
        return this.getQualifierVariable(qualifierExpression2);
    }

    @Nullable
    private DfaVariableValue getQualifierVariable(PsiExpression qualifierExpression2) {
        Object constValue;
        DfaValue qualifierValue = this.getExpressionDfaValue(qualifierExpression2);
        DfaVariableValue qualifier = null;
        if (qualifierValue instanceof DfaVariableValue) {
            qualifier = (DfaVariableValue)qualifierValue;
        } else if (qualifierValue instanceof DfaConstValue && (constValue = ((DfaConstValue)qualifierValue).getValue()) instanceof PsiVariable) {
            qualifier = this.myFactory.getVarFactory().createVariableValue((PsiVariable)constValue);
        }
        return qualifier;
    }

    private static boolean maybeUninitializedConstant(DfaValue constValue, @NotNull PsiReferenceExpression refExpr, PsiModifierListOwner var) {
        if (refExpr == null) {
            DfaExpressionFactory.$$$reportNull$$$0(1);
        }
        if (!(constValue instanceof DfaConstValue) || ((DfaConstValue)constValue).getValue() != var) {
            return false;
        }
        if (!(var instanceof PsiField) || var instanceof PsiEnumConstant) {
            return false;
        }
        return PsiTreeUtil.getTopmostParentOfType((PsiElement)refExpr, PsiClass.class) == PsiTreeUtil.getTopmostParentOfType((PsiElement)var, PsiClass.class);
    }

    private static boolean isStaticFinalConstantWithoutInitializationHacks(PsiModifierListOwner var) {
        return var instanceof PsiField && var.hasModifierProperty("final") && var.hasModifierProperty("static") && !DfaUtil.hasInitializationHacks((PsiField)var);
    }

    @Nullable
    private DfaValue createFromSpecialField(PsiReferenceExpression refExpr) {
        PsiElement target = refExpr.resolve();
        if (!(target instanceof PsiModifierListOwner)) {
            return null;
        }
        SpecialField sf = SpecialField.findSpecialField(target);
        if (sf == null) {
            return null;
        }
        DfaVariableValue qualifier = this.getQualifierOrThisVariable(refExpr);
        if (qualifier == null) {
            return null;
        }
        return sf.createValue(this.myFactory, qualifier);
    }

    @Contract(value="null -> null")
    @Nullable
    public static DfaVariableSource getAccessedVariableOrGetter(PsiElement target) {
        if (target instanceof PsiVariable) {
            return new PlainSource((PsiVariable)target);
        }
        if (target instanceof PsiMethod) {
            String qName;
            PsiMethod method = (PsiMethod)target;
            if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method) && DfaExpressionFactory.isContractAllowedForGetter(method) && ((qName = PsiUtil.getMemberQualifiedName((PsiMember)method)) == null || !FALSE_GETTERS.value((Object)qName))) {
                return new GetterSource(method);
            }
            if (method.getParameterList().isEmpty() && (JavaMethodContractUtil.isPure(method) || AnnotationUtil.findAnnotation((PsiModifierListOwner)method.getContainingClass(), (String[])new String[]{"javax.annotation.concurrent.Immutable"}) != null) && DfaExpressionFactory.isContractAllowedForGetter(method)) {
                return new GetterSource(method);
            }
        }
        return null;
    }

    private static boolean isContractAllowedForGetter(PsiMethod method) {
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, null);
        if (contracts2.size() == 1) {
            MethodContract contract = contracts2.get(0);
            return contract.isTrivial() && contract.getReturnValue().equals(ContractReturnValue.returnNew());
        }
        return contracts2.isEmpty();
    }

    @NotNull
    private DfaValue getAdvancedExpressionDfaValue(@Nullable PsiExpression expression2, @Nullable PsiType targetType) {
        if (expression2 == null) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(2);
            }
            return dfaUnknownValue;
        }
        DfaValue value2 = this.getExpressionDfaValue(expression2);
        if (value2 != null) {
            DfaValue dfaValue = DfaUtil.boxUnbox(value2, targetType);
            if (dfaValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(3);
            }
            return dfaValue;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            DfaValue dfaValue = this.getAdvancedExpressionDfaValue(((PsiConditionalExpression)expression2).getThenExpression(), targetType).unite(this.getAdvancedExpressionDfaValue(((PsiConditionalExpression)expression2).getElseExpression(), targetType));
            if (dfaValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(4);
            }
            return dfaValue;
        }
        PsiType type2 = expression2.getType();
        if (type2 instanceof PsiPrimitiveType) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(5);
            }
            return dfaUnknownValue;
        }
        DfaValue dfaValue = DfaUtil.boxUnbox(this.myFactory.createTypeValue(type2, NullabilityUtil.getExpressionNullability(expression2)), targetType);
        if (dfaValue == null) {
            DfaExpressionFactory.$$$reportNull$$$0(6);
        }
        return dfaValue;
    }

    @NotNull
    public DfaValue getArrayElementValue(DfaValue array, LongRangeSet indexSet) {
        long max;
        if (!(array instanceof DfaVariableValue)) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(7);
            }
            return dfaUnknownValue;
        }
        if (indexSet.isEmpty()) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(8);
            }
            return dfaUnknownValue;
        }
        long min = indexSet.min();
        if (min == (max = indexSet.max()) && min >= 0L && min < Integer.MAX_VALUE) {
            DfaValue value3 = this.getArrayElementValue(array, (int)min);
            DfaValue dfaValue = value3 == null ? DfaUnknownValue.getInstance() : value3;
            if (dfaValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(9);
            }
            return dfaValue;
        }
        DfaVariableValue arrayDfaVar = (DfaVariableValue)array;
        PsiModifierListOwner arrayPsiVar = arrayDfaVar.getPsiVariable();
        if (!(arrayPsiVar instanceof PsiVariable)) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(10);
            }
            return dfaUnknownValue;
        }
        PsiType arrayType = ((PsiVariable)arrayPsiVar).getType();
        PsiType targetType = arrayType instanceof PsiArrayType ? ((PsiArrayType)arrayType).getComponentType() : null;
        PsiExpression[] elements = ExpressionUtils.getConstantArrayElements((PsiVariable)arrayPsiVar);
        if (elements == null || elements.length == 0) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(11);
            }
            return dfaUnknownValue;
        }
        if ((indexSet = indexSet.intersect(LongRangeSet.range(0L, elements.length - 1))).isEmpty() || indexSet.max() - indexSet.min() > 100L) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaExpressionFactory.$$$reportNull$$$0(12);
            }
            return dfaUnknownValue;
        }
        DfaValue dfaValue = ((StreamEx)((StreamEx)LongStreamEx.of((LongStream)indexSet.stream()).mapToObj(idx -> this.getAdvancedExpressionDfaValue(elements[(int)idx], targetType)).prefix(DfaValue::unite)).takeWhileInclusive(value2 -> value2 != DfaUnknownValue.getInstance())).reduce((a, b) -> b).orElse(DfaUnknownValue.getInstance());
        if (dfaValue == null) {
            DfaExpressionFactory.$$$reportNull$$$0(13);
        }
        return dfaValue;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public DfaValue getArrayElementValue(DfaValue array, int index) {
        PsiExpression constantArrayElement;
        if (!(array instanceof DfaVariableValue)) {
            return null;
        }
        DfaVariableValue arrayDfaVar = (DfaVariableValue)array;
        PsiType type2 = arrayDfaVar.getType();
        if (!(type2 instanceof PsiArrayType)) {
            return null;
        }
        PsiType componentType = ((PsiArrayType)type2).getComponentType();
        PsiModifierListOwner arrayPsiVar = arrayDfaVar.getPsiVariable();
        if (arrayPsiVar instanceof PsiVariable && (constantArrayElement = ExpressionUtils.getConstantArrayElement((PsiVariable)arrayPsiVar, index)) != null) {
            return this.getAdvancedExpressionDfaValue(constantArrayElement, componentType);
        }
        ArrayElementSource indexVariable = this.getArrayIndexVariable(index);
        if (indexVariable == null) {
            return null;
        }
        return this.myFactory.getVarFactory().createVariableValue(indexVariable, componentType, arrayDfaVar);
    }

    @Nullable
    private ArrayElementSource getArrayIndexVariable(int index) {
        if (index >= 0) {
            return this.myMockIndices.computeIfAbsent(index, ArrayElementSource::new);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdvancedExpressionDfaValue";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElementValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "maybeUninitializedConstant";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ThisSource
    implements DfaVariableSource {
        @NotNull
        private final PsiClass myQualifier;

        ThisSource(@NotNull PsiClass qualifier) {
            if (qualifier == null) {
                ThisSource.$$$reportNull$$$0(0);
            }
            this.myQualifier = qualifier;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.myQualifier.getName() + ".this";
            if (string == null) {
                ThisSource.$$$reportNull$$$0(1);
            }
            return string;
        }

        public PsiClass getPsiElement() {
            return this.myQualifier;
        }

        @Override
        public boolean isStable() {
            return true;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ThisSource && ((ThisSource)obj).myQualifier == this.myQualifier;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$ThisSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$ThisSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ArrayElementSource
    implements DfaVariableSource {
        private final int myIndex;

        ArrayElementSource(int index) {
            this.myIndex = index;
        }

        @Override
        @NotNull
        public String toString() {
            String string = "[" + this.myIndex + "]";
            if (string == null) {
                ArrayElementSource.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean isStable() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$ArrayElementSource", "toString"));
        }
    }

    private static final class GetterSource
    implements DfaVariableSource {
        @NotNull
        private final PsiMethod myGetter;

        GetterSource(@NotNull PsiMethod getter) {
            if (getter == null) {
                GetterSource.$$$reportNull$$$0(0);
            }
            this.myGetter = getter;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.myGetter.getName();
            if (string == null) {
                GetterSource.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public PsiMethod getPsiElement() {
            PsiMethod psiMethod = this.myGetter;
            if (psiMethod == null) {
                GetterSource.$$$reportNull$$$0(2);
            }
            return psiMethod;
        }

        @Override
        public boolean isStable() {
            return false;
        }

        @Override
        public boolean isCall() {
            return true;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof GetterSource && ((GetterSource)obj).myGetter == this.myGetter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$GetterSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$GetterSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class PlainSource
    implements DfaVariableSource {
        @NotNull
        private final PsiVariable myVariable;

        PlainSource(@NotNull PsiVariable variable) {
            if (variable == null) {
                PlainSource.$$$reportNull$$$0(0);
            }
            this.myVariable = variable;
        }

        @Override
        @NotNull
        public String toString() {
            String string = String.valueOf(this.myVariable.getName());
            if (string == null) {
                PlainSource.$$$reportNull$$$0(1);
            }
            return string;
        }

        public PsiVariable getPsiElement() {
            return this.myVariable;
        }

        @Override
        public boolean isStable() {
            return this.myVariable instanceof PsiLocalVariable || this.myVariable instanceof PsiParameter || this.myVariable.hasModifierProperty("final");
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof PlainSource && ((PlainSource)obj).myVariable == this.myVariable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$PlainSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory$PlainSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

