/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.HardCodedPurity;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

public class PurityAnalysis {
    static final int UN_ANALYZABLE_FLAG = 1792;

    @Nullable
    public static Equation analyze(Member method, MethodNode methodNode, boolean stable) {
        EKey key2 = new EKey(method, Direction.Pure, stable);
        Effects hardCodedSolution = HardCodedPurity.getInstance().getHardCodedSolution(method);
        if (hardCodedSolution != null) {
            return new Equation(key2, hardCodedSolution);
        }
        if ((methodNode.access & 0x700) != 0) {
            return null;
        }
        DataInterpreter dataInterpreter = new DataInterpreter(methodNode);
        try {
            new Analyzer((Interpreter)dataInterpreter).analyze("this", methodNode);
        }
        catch (AnalyzerException e) {
            return null;
        }
        EffectQuantum[] quanta = dataInterpreter.effects;
        DataValue returnValue = dataInterpreter.returnValue == null ? DataValue.UnknownDataValue1 : dataInterpreter.returnValue;
        HashSet<EffectQuantum> effects = new HashSet<EffectQuantum>();
        for (EffectQuantum effectQuantum : quanta) {
            if (effectQuantum == null) continue;
            if (effectQuantum == EffectQuantum.TopEffectQuantum) {
                return returnValue == DataValue.UnknownDataValue1 ? null : new Equation(key2, new Effects(returnValue, Effects.TOP_EFFECTS));
            }
            effects.add(effectQuantum);
        }
        return new Equation(key2, new Effects(returnValue, effects));
    }
}

