/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaMethodParameterUnwrapper
extends JavaUnwrapper {
    private static final Logger LOG = Logger.getInstance(JavaMethodParameterUnwrapper.class);

    public JavaMethodParameterUnwrapper() {
        super("");
    }

    private static PsiElement adjustElementToTheLeft(PsiElement element) {
        PsiElement prevSibling;
        if (PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.RPARENTH) && (prevSibling = element.getPrevSibling()) != null) {
            return prevSibling;
        }
        return element;
    }

    @NotNull
    public String getDescription(@NotNull PsiElement e) {
        String text2;
        if (e == null) {
            JavaMethodParameterUnwrapper.$$$reportNull$$$0(0);
        }
        if ((text2 = JavaMethodParameterUnwrapper.adjustElementToTheLeft(e).getText()).length() > 20) {
            text2 = text2.substring(0, 17) + "...";
        }
        String string = CodeInsightBundle.message((String)"unwrap.with.placeholder", (Object[])new Object[]{text2});
        if (string == null) {
            JavaMethodParameterUnwrapper.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        PsiExpressionList argumentList;
        if (e == null) {
            JavaMethodParameterUnwrapper.$$$reportNull$$$0(2);
        }
        e = JavaMethodParameterUnwrapper.adjustElementToTheLeft(e);
        PsiElement parent = e.getParent();
        if (e instanceof PsiExpression) {
            PsiExpressionList argumentList2;
            if (parent instanceof PsiExpressionList) {
                return true;
            }
            if (e instanceof PsiReferenceExpression && parent instanceof PsiCallExpression && (argumentList2 = ((PsiCall)parent).getArgumentList()) != null && argumentList2.getExpressionCount() == 1) {
                return true;
            }
        } else if (e instanceof PsiJavaCodeReferenceElement && parent instanceof PsiCall && (argumentList = ((PsiCall)parent).getArgumentList()) != null && argumentList.getExpressionCount() == 1) {
            return true;
        }
        return false;
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        if (e == null) {
            JavaMethodParameterUnwrapper.$$$reportNull$$$0(3);
        }
        if (toExtract == null) {
            JavaMethodParameterUnwrapper.$$$reportNull$$$0(4);
        }
        e = JavaMethodParameterUnwrapper.adjustElementToTheLeft(e);
        super.collectAffectedElements(e, toExtract);
        return JavaMethodParameterUnwrapper.isTopLevelCall(e) ? e.getParent() : e.getParent().getParent();
    }

    private static boolean isTopLevelCall(PsiElement e) {
        if (e instanceof PsiReferenceExpression && e.getParent() instanceof PsiCallExpression) {
            return true;
        }
        return e instanceof PsiJavaCodeReferenceElement && !(e instanceof PsiExpression);
    }

    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiElement parent = (element = JavaMethodParameterUnwrapper.adjustElementToTheLeft(element)).getParent();
        if (parent == null) {
            return;
        }
        PsiElement methodCall = JavaMethodParameterUnwrapper.isTopLevelCall(element) ? parent : parent.getParent();
        PsiElement extractedElement = JavaMethodParameterUnwrapper.isTopLevelCall(element) ? JavaMethodParameterUnwrapper.getArg(element) : element;
        context.extractElement(extractedElement, methodCall);
        if (methodCall.getParent() instanceof PsiExpressionList) {
            context.delete(methodCall);
        } else {
            context.deleteExactly(methodCall);
        }
    }

    private static PsiExpression getArg(PsiElement element) {
        PsiExpressionList argumentList = ((PsiCall)element.getParent()).getArgumentList();
        LOG.assertTrue(argumentList != null);
        PsiExpression[] args = argumentList.getExpressions();
        LOG.assertTrue(args.length == 1);
        return args[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/unwrap/JavaMethodParameterUnwrapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExtract";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/unwrap/JavaMethodParameterUnwrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

