/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeferFinalAssignmentFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.DeferFinalAssignmentFix");
    private final PsiVariable variable;
    private final PsiReferenceExpression expression;

    public DeferFinalAssignmentFix(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expression2) {
        if (variable == null) {
            DeferFinalAssignmentFix.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            DeferFinalAssignmentFix.$$$reportNull$$$0(1);
        }
        this.variable = variable;
        this.expression = expression2;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("defer.final.assignment.with.temp.family", new Object[0]);
        if (string == null) {
            DeferFinalAssignmentFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("defer.final.assignment.with.temp.text", this.variable.getName());
        if (string == null) {
            DeferFinalAssignmentFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            DeferFinalAssignmentFix.$$$reportNull$$$0(4);
        }
        return this.variable;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            DeferFinalAssignmentFix.$$$reportNull$$$0(5);
        }
        if (this.variable instanceof PsiField) {
            this.deferField((PsiField)this.variable);
        } else {
            this.deferLocalVariable((PsiLocalVariable)this.variable);
        }
    }

    private void deferField(PsiField field) throws IncorrectOperationException {
        PsiCodeBlock codeBlock = DeferFinalAssignmentFix.getEnclosingCodeBlock(field, (PsiElement)this.expression);
        if (codeBlock == null) {
            return;
        }
        this.deferVariable((PsiElement)codeBlock, (PsiVariable)field, null);
    }

    private static PsiCodeBlock getEnclosingCodeBlock(PsiField field, PsiElement element) {
        PsiClassInitializer[] initializers;
        PsiMethod[] constructors;
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return null;
        }
        for (PsiMethod constructor : constructors = aClass.getConstructors()) {
            PsiCodeBlock body2 = constructor.getBody();
            if (body2 == null || !PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)element, (boolean)true)) continue;
            return body2;
        }
        for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
            PsiCodeBlock body3 = initializer.getBody();
            if (!PsiTreeUtil.isAncestor((PsiElement)body3, (PsiElement)element, (boolean)true)) continue;
            return body3;
        }
        return null;
    }

    private void deferLocalVariable(PsiLocalVariable variable) throws IncorrectOperationException {
        PsiElement outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        this.deferVariable(outerCodeBlock, (PsiVariable)variable, variable.getParent());
    }

    private void deferVariable(PsiElement outerCodeBlock, PsiVariable variable, PsiElement tempDeclarationAnchor) throws IncorrectOperationException {
        ControlFlow controlFlow;
        if (outerCodeBlock == null) {
            return;
        }
        ArrayList outerReferences = new ArrayList();
        DeferFinalAssignmentFix.collectReferences(outerCodeBlock, variable, outerReferences);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
        Project project = variable.getProject();
        String tempName = DeferFinalAssignmentFix.suggestNewName(project, variable);
        PsiDeclarationStatement tempVariableDeclaration = factory.createVariableDeclarationStatement(tempName, variable.getType(), null);
        try {
            controlFlow = ControlFlowFactory.getInstance(project).getControlFlow(outerCodeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
        }
        catch (AnalysisCanceledException e) {
            return;
        }
        int minOffset = 0;
        boolean writeReferenceOccurred = false;
        PsiReferenceExpression writeReference = null;
        for (int i = outerReferences.size() - 1; i >= 0; --i) {
            PsiReferenceExpression reference = (PsiReferenceExpression)outerReferences.get(i);
            if (!writeReferenceOccurred && !PsiUtil.isAccessedForWriting((PsiExpression)reference)) {
                outerReferences.remove(i);
                continue;
            }
            writeReferenceOccurred = true;
            writeReference = reference;
            PsiElement element = PsiUtil.getEnclosingStatement((PsiElement)reference);
            int endOffset = element == null ? -1 : controlFlow.getEndOffset(element);
            minOffset = Math.max(minOffset, endOffset);
        }
        LOG.assertTrue(writeReference != null);
        PsiStatement finalAssignment = factory.createStatementFromText(writeReference.getText() + " = " + tempName + ";", outerCodeBlock);
        if (!DeferFinalAssignmentFix.insertToDefinitelyReachedPlace(outerCodeBlock, finalAssignment, controlFlow, minOffset, outerReferences)) {
            return;
        }
        outerCodeBlock.addAfter((PsiElement)tempVariableDeclaration, tempDeclarationAnchor);
        DeferFinalAssignmentFix.replaceReferences(outerReferences, (PsiElement)factory.createExpressionFromText(tempName, outerCodeBlock));
    }

    private static boolean insertToDefinitelyReachedPlace(PsiElement codeBlock, PsiStatement finalAssignment, ControlFlow controlFlow, int minOffset, @NotNull List<? extends PsiElement> references) throws IncorrectOperationException {
        int offset;
        if (references == null) {
            DeferFinalAssignmentFix.$$$reportNull$$$0(6);
        }
        if ((offset = ControlFlowUtil.getMinDefinitelyReachedOffset(controlFlow, minOffset, references)) == controlFlow.getSize()) {
            codeBlock.add((PsiElement)finalAssignment);
            return true;
        }
        PsiElement element = null;
        while (offset < controlFlow.getSize()) {
            for (element = controlFlow.getElement(offset); element != null && element.getParent() != codeBlock; element = element.getParent()) {
            }
            int startOffset = controlFlow.getStartOffset(element);
            if (startOffset != -1 && startOffset >= minOffset && element instanceof PsiStatement) break;
            ++offset;
        }
        if (offset >= controlFlow.getSize()) {
            return false;
        }
        if (ControlFlowUtil.isInstructionReachable(controlFlow, offset, offset)) {
            return false;
        }
        codeBlock.addBefore((PsiElement)finalAssignment, element);
        return true;
    }

    private static void replaceReferences(List references, PsiElement newExpression) throws IncorrectOperationException {
        for (Object reference1 : references) {
            PsiElement reference = (PsiElement)reference1;
            reference.replace(newExpression);
        }
    }

    private static void collectReferences(PsiElement context, final PsiVariable variable, final List<? super PsiReferenceExpression> references) {
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (expression2.resolve() == variable) {
                    references.add(expression2);
                }
                super.visitReferenceExpression(expression2);
            }
        });
    }

    private static String suggestNewName(Project project, PsiVariable variable) {
        String name = variable.getName();
        if (name.length() > 1 && Character.isDigit(name.charAt(name.length() - 1))) {
            name = name.substring(0, name.length() - 1);
        }
        return JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(name, (PsiElement)variable, true);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            DeferFinalAssignmentFix.$$$reportNull$$$0(7);
        }
        return this.variable.isValid() && !(this.variable instanceof PsiParameter) && !(this.variable instanceof ImplicitVariable) && this.expression.isValid() && BaseIntentionAction.canModify((PsiElement)this.variable);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/DeferFinalAssignmentFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/DeferFinalAssignmentFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertToDefinitelyReachedPlace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

