/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddVariableInitializerFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddReturnFix");
    private final PsiVariable myVariable;

    public AddVariableInitializerFix(@NotNull PsiVariable variable) {
        if (variable == null) {
            AddVariableInitializerFix.$$$reportNull$$$0(0);
        }
        this.myVariable = variable;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"quickfix.add.variable.text", (Object[])new Object[]{this.myVariable.getName()});
        if (string == null) {
            AddVariableInitializerFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"quickfix.add.variable.family.name", (Object[])new Object[0]);
        if (string == null) {
            AddVariableInitializerFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddVariableInitializerFix.$$$reportNull$$$0(3);
        }
        return this.myVariable.isValid() && BaseIntentionAction.canModify((PsiElement)this.myVariable) && !this.myVariable.hasInitializer() && !(this.myVariable instanceof PsiParameter);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            AddVariableInitializerFix.$$$reportNull$$$0(4);
        }
        PsiVariable psiVariable = this.myVariable;
        if (psiVariable == null) {
            AddVariableInitializerFix.$$$reportNull$$$0(5);
        }
        return psiVariable;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        LookupElement[] suggestedInitializers;
        if (project == null) {
            AddVariableInitializerFix.$$$reportNull$$$0(6);
        }
        LOG.assertTrue((suggestedInitializers = AddVariableInitializerFix.suggestInitializer(this.myVariable)).length > 0);
        LOG.assertTrue(suggestedInitializers[0] instanceof ExpressionLookupItem);
        PsiExpression initializer = (PsiExpression)suggestedInitializers[0].getObject();
        this.myVariable.setInitializer(initializer);
        Document document = Objects.requireNonNull(PsiDocumentManager.getInstance((Project)project).getDocument(file));
        PsiDocumentManager.getInstance((Project)initializer.getProject()).doPostponedOperationsAndUnblockDocument(document);
        AddVariableInitializerFix.runAssignmentTemplate(Collections.singletonList(this.myVariable.getInitializer()), suggestedInitializers, editor);
    }

    static void runAssignmentTemplate(@NotNull List<? extends PsiExpression> initializers, final @NotNull LookupElement[] suggestedInitializers, @Nullable Editor editor) {
        if (initializers == null) {
            AddVariableInitializerFix.$$$reportNull$$$0(7);
        }
        if (suggestedInitializers == null) {
            AddVariableInitializerFix.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            return;
        }
        LOG.assertTrue(!initializers.isEmpty());
        PsiExpression initializer = (PsiExpression)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(initializers));
        PsiExpression context = initializers.size() == 1 ? initializer : PsiTreeUtil.findCommonParent(initializers);
        TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)context);
        for (PsiExpression psiExpression : initializers) {
            builder.replaceElement((PsiElement)psiExpression, new Expression(){

                @NotNull
                public Result calculateResult(ExpressionContext context1) {
                    Result result = this.calculateQuickResult(context1);
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return result;
                }

                @NotNull
                public Result calculateQuickResult(ExpressionContext context1) {
                    PsiElementResult psiElementResult = new PsiElementResult(suggestedInitializers[0].getPsiElement());
                    if (psiElementResult == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return psiElementResult;
                }

                @NotNull
                public LookupElement[] calculateLookupItems(ExpressionContext context1) {
                    if (suggestedInitializers == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return suggestedInitializers;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "calculateResult";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "calculateQuickResult";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "calculateLookupItems";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            });
        }
        builder.run(editor, false);
    }

    @NotNull
    static LookupElement[] suggestInitializer(PsiVariable variable) {
        PsiType type2 = variable.getType();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
        SmartList result = new SmartList();
        String defaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
        ExpressionLookupItem defaultExpression = new ExpressionLookupItem(elementFactory.createExpressionFromText(defaultValue, (PsiElement)variable));
        result.add(defaultExpression);
        if (type2 instanceof PsiClassType) {
            PsiClass aClass;
            if (type2.equalsToText("java.lang.String")) {
                result.add(new ExpressionLookupItem(elementFactory.createExpressionFromText("\"\"", (PsiElement)variable)));
            }
            if ((aClass = PsiTypesUtil.getPsiClass((PsiType)type2)) != null && !aClass.hasModifierProperty("abstract") && PsiUtil.hasDefaultConstructor((PsiClass)aClass)) {
                String typeText = type2.getCanonicalText(false);
                if (aClass.getTypeParameters().length > 0 && PsiUtil.isLanguageLevel7OrHigher((PsiElement)variable) && !PsiDiamondTypeImpl.haveConstructorsGenericsParameters(aClass)) {
                    typeText = TypeConversionUtil.erasure((PsiType)type2).getCanonicalText(false) + "<>";
                }
                String expressionText = "new " + typeText + "()";
                PsiExpression initializer = elementFactory.createExpressionFromText(expressionText, (PsiElement)variable);
                String variableName = variable.getName();
                LOG.assertTrue(variableName != null);
                PsiDeclarationStatement statement = elementFactory.createVariableDeclarationStatement(variableName, variable.getType(), initializer, (PsiElement)variable);
                ExpressionLookupItem newExpression = new ExpressionLookupItem(((PsiLocalVariable)statement.getDeclaredElements()[0]).getInitializer());
                result.add(newExpression);
            }
        }
        LookupElement[] lookupElementArray = result.toArray(LookupElement.EMPTY_ARRAY);
        if (lookupElementArray == null) {
            AddVariableInitializerFix.$$$reportNull$$$0(9);
        }
        return lookupElementArray;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializers";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedInitializers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToMakeWritable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runAssignmentTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

