/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.LimitedAccessibleClassPreprocessor;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.AllClassesSearchExecutor;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AllClassesGetter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.AllClassesGetter");
    public static final InsertHandler<JavaPsiClassReferenceElement> TRY_SHORTENING = new InsertHandler<JavaPsiClassReferenceElement>(){

        private void _handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
            boolean insertFqn;
            RangeMarker toDelete;
            Document document;
            block15: {
                Editor editor = context.getEditor();
                PsiClass psiClass = item.getObject();
                if (!psiClass.isValid()) {
                    return;
                }
                int endOffset = editor.getCaretModel().getOffset();
                String qname = psiClass.getQualifiedName();
                if (qname == null) {
                    return;
                }
                if (endOffset == 0) {
                    return;
                }
                document = editor.getDocument();
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)psiClass.getProject());
                PsiFile file = context.getFile();
                if (file.findElementAt(endOffset - 1) == null) {
                    return;
                }
                OffsetKey key2 = OffsetKey.create((String)"endOffset", (boolean)false);
                context.getOffsetMap().addOffset(key2, endOffset);
                PostprocessReformattingAspect.getInstance((Project)context.getProject()).doPostponedFormatting();
                int newOffset = context.getOffsetMap().getOffset(key2);
                if (newOffset >= 0) {
                    endOffset = newOffset;
                } else {
                    LOG.error(endOffset + " became invalid: " + context.getOffsetMap() + "; inserting " + qname);
                }
                toDelete = JavaCompletionUtil.insertTemporary(endOffset, document, " ");
                psiDocumentManager.commitAllDocuments();
                PsiReference psiReference = file.findReferenceAt(endOffset - 1);
                insertFqn = true;
                if (psiReference != null) {
                    PsiManager psiManager = file.getManager();
                    if (psiManager.areElementsEquivalent((PsiElement)psiClass, JavaCompletionUtil.resolveReference(psiReference))) {
                        insertFqn = false;
                    } else if (psiClass.isValid()) {
                        try {
                            PsiElement psiElement;
                            context.setTailOffset(psiReference.getRangeInElement().getEndOffset() + psiReference.getElement().getTextRange().getStartOffset());
                            PsiElement newUnderlying = psiReference.bindToElement((PsiElement)psiClass);
                            if (newUnderlying == null || (psiElement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)newUnderlying)) == null) break block15;
                            for (PsiReference reference : psiElement.getReferences()) {
                                if (!psiManager.areElementsEquivalent((PsiElement)psiClass, JavaCompletionUtil.resolveReference(reference))) continue;
                                insertFqn = false;
                                break;
                            }
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (toDelete != null && toDelete.isValid()) {
                document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
                context.setTailOffset(toDelete.getStartOffset());
            }
            if (insertFqn) {
                INSERT_FQN.handleInsert(context, (LookupElement)item);
            }
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull JavaPsiClassReferenceElement item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            this._handleInsert(context, item);
            item.getTailType().processTail(context.getEditor(), context.getEditor().getCaretModel().getOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/AllClassesGetter$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final InsertHandler<JavaPsiClassReferenceElement> INSERT_FQN = (context, item) -> {
        String qName = item.getQualifiedName();
        if (qName != null) {
            int start = JavaCompletionUtil.findQualifiedNameStart(context);
            context.getDocument().replaceString(start, context.getTailOffset(), (CharSequence)qName);
            LOG.assertTrue(context.getTailOffset() >= 0);
        }
    };

    public static void processJavaClasses(@NotNull CompletionParameters parameters2, @NotNull PrefixMatcher prefixMatcher, boolean filterByScope, @NotNull Consumer<? super PsiClass> consumer) {
        if (parameters2 == null) {
            AllClassesGetter.$$$reportNull$$$0(0);
        }
        if (prefixMatcher == null) {
            AllClassesGetter.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            AllClassesGetter.$$$reportNull$$$0(2);
        }
        PsiElement context = parameters2.getPosition();
        Project project = context.getProject();
        GlobalSearchScope scope = filterByScope ? context.getContainingFile().getResolveScope() : GlobalSearchScope.allScope((Project)project);
        AllClassesGetter.processJavaClasses(prefixMatcher, project, scope, new LimitedAccessibleClassPreprocessor(parameters2, filterByScope, consumer));
    }

    public static void processJavaClasses(@NotNull PrefixMatcher prefixMatcher, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiClass> processor) {
        if (prefixMatcher == null) {
            AllClassesGetter.$$$reportNull$$$0(3);
        }
        if (project == null) {
            AllClassesGetter.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            AllClassesGetter.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            AllClassesGetter.$$$reportNull$$$0(6);
        }
        THashSet names = new THashSet(10000);
        AllClassesSearchExecutor.processClassNames(project, scope, (Consumer<? super String>)((Consumer)arg_0 -> AllClassesGetter.lambda$processJavaClasses$1(prefixMatcher, (Set)names, arg_0)));
        LinkedHashSet sorted = CompletionUtil.sortMatching((PrefixMatcher)prefixMatcher, (Collection)names);
        AllClassesSearchExecutor.processClassesByNames(project, scope, sorted, processor);
    }

    public static boolean isAcceptableInContext(@NotNull PsiElement context, @NotNull PsiClass psiClass, boolean filterByScope, boolean pkgContext) {
        if (context == null) {
            AllClassesGetter.$$$reportNull$$$0(7);
        }
        if (psiClass == null) {
            AllClassesGetter.$$$reportNull$$$0(8);
        }
        ProgressManager.checkCanceled();
        if (JavaCompletionUtil.isInExcludedPackage((PsiMember)psiClass, false)) {
            return false;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        if (!filterByScope && !(psiClass instanceof PsiCompiledElement)) {
            return true;
        }
        return JavaCompletionUtil.isSourceLevelAccessible(context, psiClass, pkgContext);
    }

    public static JavaPsiClassReferenceElement createLookupItem(@NotNull PsiClass psiClass, InsertHandler<JavaPsiClassReferenceElement> insertHandler) {
        if (psiClass == null) {
            AllClassesGetter.$$$reportNull$$$0(9);
        }
        JavaPsiClassReferenceElement item = new JavaPsiClassReferenceElement(psiClass);
        item.setInsertHandler(insertHandler);
        return item;
    }

    private static /* synthetic */ void lambda$processJavaClasses$1(@NotNull PrefixMatcher prefixMatcher, Set names, String s) {
        if (prefixMatcher == null) {
            AllClassesGetter.$$$reportNull$$$0(10);
        }
        if (prefixMatcher.prefixMatches(s)) {
            names.add(s);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/AllClassesGetter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processJavaClasses";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableInContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupItem";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processJavaClasses$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

